<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'WCPBC_Dependencies' ) ) :

/**
 * Checks if a plugin is enabled
 *
 * @class WCPBC_Dependencies
 * @version	1.0.0
 */

class WCPBC_Dependencies {

	private static $active_plugins;

	public static function init() {

		self::$active_plugins = (array) get_option( 'active_plugins', array() );

		if ( is_multisite() )
			self::$active_plugins = array_merge( self::$active_plugins, get_site_option( 'active_sitewide_plugins', array() ) );
	}

	public static function plugin_active_check( $slug ) {

		if ( ! self::$active_plugins ) self::init();

		return in_array( $slug, self::$active_plugins ) || array_key_exists( $slug, self::$active_plugins );
	}
}

/**
 * Retrun is a plugin is active by slug
 * 
 * @param array $slug 
 * return boolean
 */
function wcpbc_plugin_active_check( $slug ) {
	return WCPBC_Dependencies::plugin_active_check( $slug );
}

/**
 * WooCoommerce Detection
 *
 * @return boolean
 */
if ( ! function_exists( 'is_woocommerce_active' ) ) {
	
	function is_woocommerce_active(){
		return WCPBC_Dependencies::plugin_active_check('woocommerce/woocommerce.php');
	}
}

/**
 * WooCoommerce Price Based Country Detection
 *
 * @return boolean
 */
if ( ! function_exists( 'is_woocommerce_price_based_country_active' ) ) {
	
	function is_woocommerce_price_based_country_active(){
		return WCPBC_Dependencies::plugin_active_check('woocommerce-product-price-based-on-countries/woocommerce-product-price-based-on-countries.php');
	}
}

endif;

