<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if( ! class_exists('WC_Plugin_API_Wrapper') ) :

/**
 * WooCommerce Plugin API Wrapper Class
 *
 * Handle WooCommerce Plugin API calls
 *
 * @class 		WC_Plugin_API_Wrapper
 * @version		1.1
 * @author 		oscargare
 */
class WC_Plugin_API_Wrapper {

	/** API url */
	private static $api_url = 'https://www.pricebasedcountry.com/wc-api/plugin-api/';	

	/**
	 * Do a request to API
	 *
	 * @return array
	 * @access private
	 */
	private static function api_request( $action, $params, $assoc = false ){

        global $wp_version;
        
        $response = false;
        $url = add_query_arg( 'request', $action, self::$api_url );

        $response = wp_remote_post( $url, array(
            'body'       	=> $params,
			'redirection' 	=> 5,
			'timeout' 		=> 15,
			'httpversion' 	=> '1.0',
			'blocking' 		=> true,			
			'cookies' 		=> array(),
			'sslverify' 	=> false,
            'user-agent' 	=> 'WordPress/' . get_bloginfo( 'version' ) . '; ' . get_bloginfo( 'url' )			
        ) );             

        if ( ! is_wp_error( $response ) ) {

            if (  $response['response']['code'] != 200 ) {

                $error = json_decode( $response['body'], true );                                

                if ( ! empty( $error['errors'] ) ) {
                	
                	$response = new WP_Error();

	                foreach ( $error['errors'] as $code => $message ) {
	                    $response->add( $code, $message[0] );
	                }

                } else {
                	$response->add( 'wc-plugin-api-error', 'Error on API request: ' . $response['body'] );
                }

            } else {
            	
                //success
                $response = json_decode( $response['body'], $assoc );                
            }
        }

        return $response;
    }

    /**
	 * Activate a license key
	 *
	 * @return array
	 * @access public
	 */
	public static function activate_license( $license_key ) {	    

	    return self::api_request('activate', array(
	            'license'   => $license_key,
	            'home_url'  => get_bloginfo( 'url' )
	    ) );	    	    
	}
	
	/**
	 * Deactivate a license key
	 *
	 * @return array
	 * @access public
	 */
	public static function deactivate_license( $license_key, $api_key ) {	    

	    return self::api_request('deactivate', array(
	            'license'   => $license_key,
				'api-key' => $api_key	           
	    ) );	    	    
	}
	
	/**
	 * Check status of activation
	 *
	 * @return array
	 * @access public
	 */
	public static function status_check( $license_key, $api_key ) {	    

	    return self::api_request('status_check', array(
	            'license'   => $license_key,
				'api-key' => $api_key	           
	    ) );	    	    
	}

	/**
	 * Update check
	 *
	 * @return array
	 * @access public
	 */
	public static function update_check( $plugin_id, $api_key, $license_key ) {	    

	    return self::api_request('update_check', array(
    		    'id'      => $plugin_id,    		    
    			'api-key' => $api_key,
                'license' => $license_key
    		) );	    	    
	}

	/**
	 * Plugin information
	 *
	 * @return array
	 * @access public
	 */
	public static function plugin_information( $plugin_id, $api_key, $license_key ) {	    

	    $response = self::api_request('plugin_information', array(
    		    'id'      => $plugin_id,    		    
    			'api-key' => $api_key,
                'license' => $license_key
    		), true );	    	    

	    if ( ! is_wp_error( $response ) ) {
	    	
	    	$data = new StdClass();
		    foreach ($response as $key => $value) {
		    	$data->$key = $value;
		    }

		    $response = $data;		   
	    }

	    return $response;	    
	}
}

endif;