<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div id="wcpbc_bookings_pricing" class="panel panel woocommerce_options_panel hidden">

<?php foreach ( WCPBC()->get_regions() as $zone_id => $zone ) : ?>

	<div class="options_group wcpbc_pricing">
	<?php 
		$_id_prefix    = '_' . $zone_id;
		$_price_method = get_post_meta( get_the_ID(), $_id_prefix . '_price_method' , true );
		$_price_method = empty($_price_method) ? 'exchange_rate' : $_price_method;				

		woocommerce_wp_radio(
			array(
				'id' => $_id_prefix . '_booking_price_method',
				'value' => $_price_method,
				'class' => 'wcpbc_price_method',
				'label' => __( 'Costs for', 'wc-price-based-country' )  . ' ' . $zone['name']. ' (' . get_woocommerce_currency_symbol( $zone['currency'] ) . ')',								
				'options' => array(
					'exchange_rate'	=> __('Calculate cost by exchange rate', 'wc-price-based-country'),
					'manual' 		=> __('Set cost manually', 'wc-price-based-country')
				)
			)
		);		
	?>	
		<div style="display: <?php echo ($_price_method == 'exchange_rate' ? 'none' : 'block' ); ?>" class="wcpbc_show_if_manual">

		<?php woocommerce_wp_text_input( array(
				'id'                => $_id_prefix . '_wc_booking_cost',
				'label'             => __( 'Base cost', 'woocommerce-bookings' ),
				'description'       => __( 'One-off cost for the booking as a whole.', 'woocommerce-bookings' ),				
				'type'              => 'number',
				'desc_tip'          => true,
				'class'				=> 'wc_input_price',
				'custom_attributes' => array(
					'min'           => '',
					'step' 	        => '0.01',
				),
			) );

			woocommerce_wp_text_input( array(
				'id'                => $_id_prefix . '_wc_booking_base_cost',
				'label'             => __( 'Block cost', 'woocommerce-bookings' ),
				'description'       => __( 'This is the cost per block booked. All other costs (for resources and persons) are added to this.', 'woocommerce-bookings' ),				
				'type'              => 'number',
				'desc_tip'          => true,
				'class'				=> 'wc_input_price',
				'custom_attributes' => array(
					'min'           => '',
					'step' 	        => '0.01',
				),
			) );

			woocommerce_wp_text_input( array(
				'id'                => $_id_prefix . '_wc_display_cost',
				'label'             => __( 'Display cost', 'woocommerce-bookings' ),
				'description'       => __( 'The cost is displayed to the user on the frontend. Leave blank to have it calculated for you. If a booking has varying costs, this will be prefixed with the word "from:".', 'woocommerce-bookings' ),				
				'type'              => 'number',
				'desc_tip'          => true,
				'class'				=> 'wc_input_price',
				'custom_attributes' => array(
					'min'           => '',
					'step' 	        => '0.01',
				),
			) ); ?>

			<?php if ( ! empty( $pricing_rows ) && is_array( $pricing_rows ) ) : ?>

			<div class="pricing_warning" style="display:none;">
				<div id="message" class="inline notice woocommerce-message" style="margin: 10px;">
					<p><?php echo sprintf( __( 'Please, %ssave%s product changes before edit range cost by zone.', 'wc-price-based-country' ), '<strong>','</strong>'); ?></p>						
				</div>
			</div>

			<div class="table_grid">
				<table class="widefat">
					<thead>
						<tr>							
							<th><?php _e( 'Range type', 'woocommerce-bookings' ); ?></th>
							<th colspan="3"><?php _e( 'Range', 'woocommerce-bookings' ); ?></th>							
							<th><?php _e( 'Base cost', 'woocommerce-bookings' ); ?>&nbsp;<a class="tips" data-tip="<?php _e( 'Enter a cost for this rule. Applied to the booking as a whole.', 'woocommerce-bookings' ); ?>">[?]</a></th>
							<th><?php _e( 'Block cost', 'woocommerce-bookings' ); ?>&nbsp;<a class="tips" data-tip="<?php _e( 'Enter a cost for this rule. Applied to each booking block.', 'woocommerce-bookings' ); ?>">[?]</a></th>							
						</tr>
					</thead>
					<tfoot>
						<tr>
							<th colspan="6">								
								<span class="description"><?php printf( __( 'You can manage rules from the %sCost%s tab.', 'wc-price-based-country' ), '<strong>', '</strong>' ) ; ?></span>
							</th>
						</tr>
					</tfoot>					
					<tbody id="wcpbc_pricing_rows">										
					<?php $wcpbc_pricing = get_post_meta( get_the_ID(), "_{$zone_id}_pricing", true ); ?>
					<?php foreach ( $pricing_rows as $index => $data ) : $data[ 'type' ] = empty( $data[ 'type' ] ) ? 'custom' : $data[ 'type' ]; ?>
						<tr>
							<td style="width:180px;"><p><?php echo $type_labels[ $data[ 'type' ] ]; ?></p></td>							
							<?php self::the_range( $data, $intervals ); ?>
							<td><span class="cost_modifier"><?php echo $modifier_labels[ $data[ 'base_modifier' ] ]; ?></span><input type="text" class="wc_input_price" name="wcpbc_booking_pricing_base_cost[<?php echo esc_attr( $index ); ?>][<?php echo $zone_id; ?>]" value="<?php echo ( ! empty( $wcpbc_pricing[$index]['base_cost'] ) ? wc_format_localized_price( $wcpbc_pricing[$index]['base_cost'] ) : ''); ?>" placeholder="0" /></td>
							<td><span class="cost_modifier"><?php echo $modifier_labels[ $data[ 'modifier' ] ]; ?></span><input type="text" class="wc_input_price" name="wcpbc_booking_pricing_cost[<?php echo esc_attr( $index ); ?>][<?php echo $zone_id; ?>]" value="<?php echo ( ! empty( $wcpbc_pricing[$index]['cost'] ) ? wc_format_localized_price( $wcpbc_pricing[$index]['cost'] ) : '' ); ?>" placeholder="0" /></td>
						</tr>
					<?php endforeach; ?>					
					</tbody>
				</table>
			</div>	<!-- end table_grid -->
			
			<?php else : ?>
				<div id="message" class="inline notice woocommerce-message" style="margin: 10px;">
					<p><?php echo sprintf( __( 'No ranges have been found. If you want manage ranges cost by zone, add ranges on the %1$sCost%2$s tab and %1$ssave%2$s.', 'wc-price-based-country' ), '<strong>','</strong>'); ?></p>						
				</div>
			<?php endif; ?>

		</div> <!-- end wcpbc_show_if_manual -->
	</div> <!-- end wcpbc_pricing -->
	
	<?php endforeach; ?>

</div>