/* global wc_price_based_country_pro_admin_param */

jQuery( document ).ready( function( $ ){
	
	$('#woocommerce_currency_pos').closest('tr').hide();

	$('.wcpbc-region-settings #exchange_rate').closest('tr').insertAfter( $('input[name="auto_exchange_rate"]').closest('tr') );		
	
	$('#exchange_rate').closest('tr').toggle( ( $('input[name="auto_exchange_rate"]:checked').val() == 'no' ) );			
	
	$('input[name="auto_exchange_rate"]').on( 'click', function(){
		$('#exchange_rate').closest('tr').toggle( $(this).val() == 'no' );
	});		

	function price_preview() {
		var symbol = $('#woocommerce_currency option:selected').text();
		var symbolPos = symbol.indexOf('(');
		if (symbolPos>-1) {

			symbol = symbol.substr(symbolPos+1, 1);

			var code = $('#woocommerce_currency option:selected').val();
			var currencyFormat = $('#wc_price_based_currency_format').val();

			if ( currencyFormat.indexOf('[price]') < 0 ) {
				currencyFormat = currencyFormat + '[price]';
			}

			var currencyPreview = currencyFormat.replace('[price]', '99.99');
			currencyPreview = currencyPreview.replace('[code]', code);
			currencyPreview = currencyPreview.replace('[symbol]', symbol );				
			$('#wc_price_based_currency_format_preview').html(currencyPreview);
		}
	};

	$('#wc_price_based_currency_format').on('change', function(){
		price_preview();
	});					
	
	price_preview();
	
	
	// Subscriptions support	
	$('body').on( 'change', '.wcpbc_subscription_price[type=text]', function(){

		var subscription_price_field = $(this);				
		var subscription_price = parseFloat( accounting.unformat( subscription_price_field.val(), woocommerce_admin.mon_decimal_point ) );

		var regular_price_field = $('#' + subscription_price_field.attr('id').replace('_subscription','_regular') ) ;		
		regular_price_field.val(subscription_price);		

	});

	$('#woocommerce-product-data').on('woocommerce_variations_added woocommerce_variations_loaded', function(){		
			
		$('.wpbc_variable_pricing input[name*="variable_regular_price"]').closest('p.form-row').addClass('hide_if_variable-subscription');			

		if ( $('select#product-type').val()=='variable-subscription' ) {
			$('.wpbc_variable_pricing input[name*="variable_regular_price"]').closest('p.form-row').hide().next().removeClass('form-row-last').addClass('form-row-full');					
			$('.wcpbc_wrapper_variable_sale_price_dates').removeClass('form-row-full').addClass('form-row-last');
		}		
	});

	// Variation pricing bulk edit	
	$('select.variation_actions').on('wcpbc_variable_bluck_edit_ajax_data', function(e){										
		var value;			
		var data = {
			action:  $('select.variation_actions option:selected').data('action'),
			zone_id: $('select.variation_actions option:selected').data('zone-id'),						
		};

		switch ( data.action ) {
			case 'regular_price_increase' :
			case 'regular_price_decrease' :
			case 'sale_price_increase' :
			case 'sale_price_decrease' :
				value = window.prompt( wc_price_based_country_pro_admin_param.i18n_enter_a_value_fixed_or_percent );

				if ( value != null ) {
					if ( value.indexOf( '%' ) >= 0 ) {
						data.value = accounting.unformat( value.replace( /\%/, '' ), woocommerce_admin.mon_decimal_point ) + '%';
					} else {
						data.value = accounting.unformat( value, woocommerce_admin.mon_decimal_point );
					}
				}
				break;
			case 'regular_price' :
			case 'sale_price' :			
				value = window.prompt( wc_price_based_country_pro_admin_param.i18n_enter_a_value );

				if ( value != null ) {
					data.value = value;
				}
				break;
		}

		return data;			
	});

	// Bookings
	function wcpbc_booking_pricing_rows_change() {
		$('#wcpbc_bookings_pricing .table_grid').hide();
		$('#wcpbc_bookings_pricing .pricing_warning').show();
	}

	$('#pricing_rows').on( 'change', '.wc_booking_pricing_type select', function( event ){
		if ( event.originalEvent !== undefined ) {
			wcpbc_booking_pricing_rows_change();
		}		
	});

	$('#bookings_resources').on('change', '.booking_resource_price_method', function() {		
		var visible = $(this).val() == 'exchange_rate' ? 'hidden' : 'visible';
		$(this).closest('tr').find('.booking_resource_cost').css('visibility', visible );
	});	

	// Move tab under booking cost
	$('li.wcpbc_bookings_pricing_options.wcpbc_bookings_pricing_tab.show_if_booking').insertAfter('li.bookings_pricing_options.bookings_pricing_tab.show_if_booking');
});	