<?php
/**
 * Plugin Name: Frontend Reports for WooCommerce
 * Description: Provide access to preset WooCommerce reports from the frontend via a shortcode or widget.
 * Version: 1.0.3
 * Author: Potent Plugins
 * Author URI: https://potentplugins.com/?utm_source=frontend-reports-for-woocommerce&utm_medium=link&utm_campaign=wp-plugin-author-uri
 * License: GNU General Public License version 2 or later
 * License URI: http://www.gnu.org/licenses/old-licenses/gpl-2.0.en.html
 */

// Add About link in plugins list
add_filter('plugin_action_links_'.plugin_basename(__FILE__), 'pp_wcfer_action_links');
function pp_wcfer_action_links($links) {
	array_unshift($links, '<a href="'.esc_url(get_admin_url(null, 'admin.php?page=pp_wcfer')).'">About</a>');
	return $links;
}

// Add settings page
add_action('admin_menu', 'pp_wcfer_admin_menu');
function pp_wcfer_admin_menu() {
	add_submenu_page('woocommerce', 'Frontend Reports for WooCommerce', 'Frontend Reports', 'manage_woocommerce', 'pp_wcfer', 'pp_wcfer_page');
}

// Enqueue admin page CSS
add_action('admin_enqueue_scripts', 'pp_wcfer_admin_enqueue_scripts');
function pp_wcfer_admin_enqueue_scripts() {
	wp_enqueue_style('pp_wcfer_admin_style', plugins_url('css/admin.css', __FILE__));
}

// Display admin page
function pp_wcfer_page() {

	if (count(pp_wcfer_get_available_reports()) == 0)
		echo('<div class="notice notice-warning"><p>You currently have no compatible reporting plugins activated. You will not be able to select any reports to display on the frontend.</p></div>');

	echo('
		<div id="pp_wcfer_admin_page" class="wrap" style="max-width: 600px;">
			<h2>Frontend Reports for WooCommerce</h2>
			<div style="margin-bottom: 30px;">
	');
	$licensed = pp_wcfer_license_check(false);
	if ($licensed) {
		
		$reports = pp_wcfer_get_available_reports();
		echo('
				<p><strong>Thank you for purchasing the Frontend Reports for WooCommerce plugin!</strong> This add-on plugin allows you to provide access to your WooCommerce reports from the frontend via a shortcode or widget. As of this version, the following plugins are compatible:</p>
				<ul>
					<li><a href="https://potentplugins.com/free-plugins/product-sales-report-wordpress-plugin/?utm_source=frontend-reports-for-woocommerce&utm_medium=link&utm_campaign=wp-plugin-referral" target="_blank">Product Sales Report</a> (1.4.3+)</li>
					<li><a href="https://potentplugins.com/downloads/product-sales-report-pro-wordpress-plugin/?utm_source=frontend-reports-for-woocommerce&utm_medium=link&utm_campaign=wp-plugin-referral" target="_blank">Product Sales Report Pro</a> (1.5.5+)</li>
					<li><a href="https://potentplugins.com/free-plugins/export-order-items-wordpress-plugin/?utm_source=frontend-reports-for-woocommerce&utm_medium=link&utm_campaign=wp-plugin-referral" target="_blank">Export Order Items</a> (1.0.5+)</li>
					<li><a href="https://potentplugins.com/downloads/export-order-items-pro-wordpress-plugin/?utm_source=frontend-reports-for-woocommerce&utm_medium=link&utm_campaign=wp-plugin-referral" target="_blank">Export Order Items Pro</a> (1.0.9+)</li>
				</ul>
				<p>You must have one or more of the above plugins installed to use this add-on plugin.</p>
				<h3>Shortcode Generator</h3>
				<table class="form-table">
					<tr valign="top">
						<th scope="row">
							<label>Mode:</label>
						</th>
						<td>
							<label style="margin-right: 10px;">
								<input type="radio" name="pp_wcfer_mode" id="pp_wcfer_mode_display" checked="checked" />Display
							</label>
							<label>
								<input type="radio" name="pp_wcfer_mode" id="pp_wcfer_mode_download" />Download Link
							</label>
						</td>
					</tr>
					<tr valign="top">
						<th scope="row">
							<label>Report Source:</label>
						</th>
						<td>
							<select id="pp_wcfer_source">');
							foreach ($reports as $reportSourceId => $reportSourceData)
								echo('<option value="'.$reportSourceId.'">'.$reportSourceData['name'].'</option>');
	echo('
							</select>
						</td>
					</tr>
					<tr valign="top">
						<th scope="row">
							<label>Report Preset:</label>
						</th>
						<td>');
							foreach ($reports as $reportSourceId => $reportSourceData) {
								echo('<select id="pp_wcfer_'.$reportSourceId.'_report" class="pp_wcfer_reports" style="display: none;">');
								foreach ($reportSourceData['reports'] as $reportId => $reportName)
									echo('<option value="'.$reportId.'">'.htmlspecialchars($reportName).'</option>');
								echo('</select>');
							}
	echo('
						</td>
					</tr>
					<tr valign="top">
						<th scope="row">
							<label>Report Date Range:</label>
						</th>
						<td>
							<label class="pp_wcfer_mb5"><input type="radio" name="pp_wcfer_dates_from_preset" value="1" checked> Use date range from preset</label><br>
							<label><input type="radio" name="pp_wcfer_dates_from_preset" value="0"> Previous</label>
							<label style="margin-right: 20px;"><input type="number" id="pp_wcfer_days" value="7" min="1" step="1" style="width: 50px;" /> days</label>
							<label><input type="checkbox" id="pp_wcfer_includetoday" /> Include today</label>
						</td>
					</tr>
					<tr valign="top" id="pp_wcfer_display_options">
						<th scope="row">
							<label>Display Options:</label>
						</th>
						<td>
							<label class="pp_wcfer_mb5"><input type="checkbox" id="pp_wcfer_plain" /> Plain mode (no pagination, search, and re-ordering)</label><br />
							<label class="pp_wcfer_mb5"><input type="checkbox" id="pp_wcfer_nosearch" /> Hide search box</label><br />
							<label>Show <input type="number" id="pp_wcfer_perpage" value="25" min="1" step="1" style="width: 50px;" /> rows per page</label>
							
						</td>
					</tr>
					<tr valign="top" id="pp_wcfer_download_options">
						<th scope="row">
							<label>Link Text:</label>
						</th>
						<td>
							<input type="text" id="pp_wcfer_label" value="Download Report" />
						</td>
					</tr>
					<tr valign="top">
						<th scope="row">
							<label>Shortcode:</label>
						</th>
						<td>
							<input type="text" id="pp_wcfer_sc" readonly="readonly" style="width: 100%;" />
						</td>
					</tr>
				</table>
				<script>
				function pp_wcfer_sc_update() {
					var sc = \'[pp_wc_report\' + (jQuery(\'#pp_wcfer_mode_download\').is(\':checked\') ? \'_download\' : \'\');
					var reportSource = jQuery(\'#pp_wcfer_source\').val();
					sc += \' source="\' + reportSource + \'"\';
					sc += \' id="\' + jQuery(\'#pp_wcfer_\' + reportSource + \'_report\').val() + \'"\';
					if (jQuery(\'input[name="pp_wcfer_dates_from_preset"]:checked\').val() == 0) {
						sc += \' days="\' + jQuery(\'#pp_wcfer_days\').val() + \'"\';
						if (jQuery(\'#pp_wcfer_includetoday\').is(\':checked\'))
							sc += \' includetoday="1"\';
					}
					if (jQuery(\'#pp_wcfer_mode_display\').is(\':checked\')) {
						if (jQuery(\'#pp_wcfer_plain\').is(\':checked\')) {
							sc += \' plain="1"\';
						} else {
							if (jQuery(\'#pp_wcfer_nosearch\').is(\':checked\'))
								sc += \' nosearch="1"\';
							sc += \' perpage="\' + jQuery(\'#pp_wcfer_perpage\').val() + \'"\';
						}
					} else {
						sc += \' label="\' + jQuery(\'#pp_wcfer_label\').val() + \'"\';
					}
					sc += \']\';
					jQuery(\'#pp_wcfer_sc\').val(sc);
				}
				jQuery(\'#pp_wcfer_mode_display, #pp_wcfer_mode_download, #pp_wcfer_source, .pp_wcfer_reports, #pp_wcfer_days, #pp_wcfer_includetoday, #pp_wcfer_plain, #pp_wcfer_nosearch, #pp_wcfer_perpage, input[name="pp_wcfer_dates_from_preset"]\').change(pp_wcfer_sc_update);
				jQuery(\'#pp_wcfer_source\').change(function() {
					jQuery(\'.pp_wcfer_reports\').hide();
					jQuery(\'#pp_wcfer_\' + jQuery(this).val() + \'_report\').show();
				});
				jQuery(\'#pp_wcfer_mode_display, #pp_wcfer_mode_download\').change(function() {
					jQuery(\'#pp_wcfer_display_options\').toggle(jQuery(\'#pp_wcfer_mode_display\').is(\':checked\'));
					jQuery(\'#pp_wcfer_download_options\').toggle(jQuery(\'#pp_wcfer_mode_download\').is(\':checked\'));
				});
				jQuery(\'#pp_wcfer_plain\').change(function() {
					jQuery(\'#pp_wcfer_nosearch, #pp_wcfer_perpage\').prop(\'disabled\', jQuery(this).is(\':checked\'));
				});
				jQuery(document).ready(function() {
					jQuery(\'#pp_wcfer_source\').change();
					jQuery(\'#pp_wcfer_mode_display\').change();
				});
				</script>
	');			
	echo('
			</div>
	');
	
	}
	$potent_slug = 'frontend-reports-for-woocommerce';
	include(__DIR__.'/plugin-credit.php');
	
	if ($licensed) {
		echo('<br /><form action="" method="post">
				<strong>License Key:</strong> '.get_option( 'pp_wcfer_license_key' ));
			wp_nonce_field( 'pp_wcfer_license_deactivate_nonce', 'pp_wcfer_license_deactivate_nonce' );
			echo('<br /><button type="submit" name="pp_wcfer_license_deactivate" value="1" class="button-secondary" style="margin-top: 5px;">Deactivate License</button>
			</form>
		');
	}
	
	echo('
		</div>
	');
}

function pp_wcfer_get_available_reports() {
	global $pp_wcfer_available_reports;
	if (!isset($pp_wcfer_available_reports)) {
		$pp_wcfer_available_reports = array();
		$pp_wcfer_available_reports = apply_filters('pp_wc_get_schedulable_email_reports', $pp_wcfer_available_reports);
	}
	return $pp_wcfer_available_reports;
}

add_action('admin_enqueue_scripts', 'pp_wcfer_admin_scripts');
function pp_wcfer_admin_scripts() {
	wp_enqueue_style('pp_wcfer_admin', plugins_url('css/admin.css', __FILE__));
}

add_action('wp_enqueue_scripts', 'pp_wcfer_scripts');
function pp_wcfer_scripts() {
	wp_enqueue_style('datatables', plugins_url('js/datatables/datatables.min.css', __FILE__));
}	

add_action('init', 'pp_wcfer_init');
function pp_wcfer_init() {
	if (pp_wcfer_license_check()) {
		add_shortcode('pp_wc_report', 'pp_wcfer_shortcode');
		add_shortcode('pp_wc_report_download', 'pp_wcfer_download_shortcode');
	}
	
	if (!empty($_GET['pp_wcfer_download'])) {
		if (empty($_GET['source'])) {
			echo('Error: Missing report source attribute.');
			exit;
		}
		if (empty($_GET['id'])) {
			echo('Error: Missing report ID.');
			exit;
		}
		if (empty($_GET['key'])) {
			echo('Error: Missing key.');
			exit;
		}
		$validKey = false;
		$currentT = round(time() / 3600);
		$keys = get_option('pp_wcfer_download_keys');
		foreach ($keys as $t => $keys) {
			if ($t < $currentT - 1)
				continue;
			if (isset($keys[$_GET['key']]) && $keys[$_GET['key']] == $_GET['source'].':'.$_GET['id']) {
				$validKey = true;
				break;
			}
		}
		if (!$validKey) {
			echo('Error: Invalid key. Please try reloading the page and clicking the download link again.');
			exit;
		}
		$reports = pp_wcfer_get_available_reports();
		if (empty($reports[$_GET['source']]['callback']) || !function_exists($reports[$_GET['source']]['callback'])) {
			echo('Error: Invalid report source. Please ensure that the reporting plugin is activated.');
			exit;
		}
		if (!isset($reports[$_GET['source']]['reports'][$_GET['id']])) {
			echo('Error: Invalid report ID. The report preset may have been deleted.');
			exit;
		}
		if (empty($_GET['days'])) {
			$reportFile = $reports[$_GET['source']]['callback']($_GET['id'], null, null);
		} else if (is_numeric($_GET['days']) && $_GET['days'] > 0) {
			$reportEnd = strtotime('midnight', current_time('timestamp')) - (empty($_GET['includetoday']) ? 86400 : 0);
			$reportStart = $reportEnd - (86400 * ($_GET['days'] - 1));
			$reportFile = $reports[$_GET['source']]['callback']($_GET['id'], $reportStart, $reportEnd);
		} else {
			echo('Error: Invalid number of days.');
			exit;
		}
		
		
		if (empty($reportFile) || !is_file($reportFile)) {
			echo('Error: Unable to generate report. Please try again.');
			exit;
		}
		header('Content-Type: '.mime_content_type($reportFile));
		header('Content-Disposition: attachment; filename="'.basename($reportFile).'"');
		readfile($reportFile);
		@unlink($reportFile);
		exit;
	}
}

add_action('widgets_init', 'pp_wcfer_widgets_init');
function pp_wcfer_widgets_init() {
	if (pp_wcfer_license_check())
		register_widget('PP_WCFER_Widget');
}

function pp_wcfer_shortcode($atts) {
	if (!isset($GLOBALS['pp_wcfer_count']))
		$GLOBALS['pp_wcfer_count'] = 0;
	$tableId = ++$GLOBALS['pp_wcfer_count'];
	if (empty($atts['source'])) {
		return 'Error: Missing report source attribute.';
	}
	$reports = pp_wcfer_get_available_reports();
	if (empty($reports[$atts['source']]['callback']) || !function_exists($reports[$atts['source']]['callback'])) {
		return 'Error: Invalid report source. Please ensure that the reporting plugin is activated.';
	}
	if (empty($atts['id'])) {
		return 'Error: Missing report ID.';
	}
	if (!isset($reports[$atts['source']]['reports'][$atts['id']])) {
		return 'Error: Invalid report ID. The report preset may have been deleted.';
	}
	if (empty($atts['days'])) {
		$reportStart = null;
		$reportEnd = null;
	} else if (is_numeric($atts['days']) && $atts['days'] > 0) {
		$reportEnd = strtotime('midnight', current_time('timestamp')) - (empty($atts['includetoday']) ? 86400 : 0);
		$reportStart = $reportEnd - (86400 * ($atts['days'] - 1));
	} else {
		return 'Error: Invalid number of days.';
	}
	if (empty($atts['perpage']) || !is_numeric($atts['perpage']) || $atts['perpage'] < 0) {
		$perPage = 25;
	} else {
		$perPage = $atts['perpage'];
	}
	$dtDom = (empty($atts['nosearch']) ? 'lfrtip' : 'lrtip');
	
	
	ob_start();
	
	echo('<div id="pp_wc_report_'.$tableId.'" class="pp_wc_report">');
	$reports[$atts['source']]['callback']($atts['id'], $reportStart, $reportEnd, array('format' => 'html', 'include_header' => 1), true);
	if (empty($atts['plain'])) {
		wp_enqueue_script('datatables', plugins_url('js/datatables/datatables.min.js', __FILE__), array('jquery'), '1.10.16', true);
		echo("
			<script>
				jQuery(document).ready(function() {
					var table = jQuery('#pp_wc_report_$tableId 	 table');
					if (!table.children('thead').length) {
						var thead = jQuery('<thead>');
						thead.append(table.find('tr:first-child')).prependTo(table);
						console.log(thead);
					}
					table.DataTable({
						dom: '$dtDom',
						pageLength: $perPage,
						colReorder: true,
						fixedHeader: true,
						responsive: true,
						select: true
					});
				});
			</script>
		");
	}
	echo('</div>');
	
	$output = ob_get_contents();
	ob_end_clean();
	
	return $output;
	
}


function pp_wcfer_download_shortcode($atts) {
	if (empty($atts['source']) || empty($atts['id'])) {
		return 'Error: Missing report source and/or ID.';
	}
	
	$keys = get_option('pp_wcfer_download_keys', array());
	$currentT = round(time() / 3600);
	
	// Cleanup
	foreach ($keys as $t => $tKeys) {
		if ($t < $currentT - 1)
			unset($keys[$t]);
	}
	if (!isset($keys[$currentT]))
		$keys[$currentT] = array();
	
	$chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
	$maxChar = strlen($chars) - 1;
	
	$urlParams = $atts;
	unset($urlParams['label']);
	do {
		$urlParams['key'] = '';
		for ($i = 0; $i < 32; ++$i)
			$urlParams['key'] .= $chars[rand(0, $maxChar)];
	} while (isset($keys[$currentT][$urlParams['key']]));
	$keys[$currentT][$urlParams['key']] = $urlParams['source'].':'.$urlParams['id'];
	update_option('pp_wcfer_download_keys', $keys, false);
	
	$urlParams['pp_wcfer_download'] = 1;
	$url = $_SERVER['REQUEST_URI'].'?'.http_build_query($urlParams);
	
	return '<a href="'.htmlspecialchars($url).'" target="_blank" class="pp_wc_report_download_link">'.(empty($atts['label']) ? 'Download Report' : htmlspecialchars($atts['label'])).'</a>';
	
}

class PP_WCFER_Widget extends WP_Widget {

	public static $defaultOptions = array(
		'title' => 'WooCommerce Report',
		'source' => '',
		'days' => 7,
		'includetoday' => 0,
		'plain' => 0,
		'nosearch' => 1,
		'perpage' => 10,
		'dates_from_preset' => 1
	);

	public function __construct() {
		parent::__construct(false, 'WooCommerce Report', array('description' => 'Display a report from Frontend Reports for WooCommerce.'));
	}
	
	public function widget($args, $options) {
		if (empty($options)) {
			$options = PP_WCFER_Widget::$defaultOptions;
		} else {
			if (!isset($options['dates_from_preset'])) {
				$options['dates_from_preset'] = 0;
			}
			$options = array_merge(PP_WCFER_Widget::$defaultOptions, $options);
		}
		echo($args['before_widget']);
		if (!empty($options['title']))
			echo($args['before_title'].apply_filters('widget_title', htmlspecialchars($options['title'])).$args['after_title']);
		if (empty($options['source']) || empty($options[$options['source'].'_report'])) {
			echo('Error: No report has been selected.');
		} else {
			$options['id'] = $options[$options['source'].'_report'];
			if (!empty($options['dates_from_preset'])) {
				unset($options['days']);
			}
			echo(pp_wcfer_shortcode($options));
		}
		echo($args['after_widget']);
	}
	
	public function form($options) {
		echo('<div class="pp_wcfer_widget_form">');
		$reports = pp_wcfer_get_available_reports();
		
		if (empty($reports)) {
			echo('<p>You currently have no compatible reporting plugins activated. You will not be able to select any reports to send. <a href="admin.php?page=pp_wcfer">Click here for a list of compatible plugins.</a></p></div>');
			return;
		}
		
		if (empty($options)) {
			$options = PP_WCFER_Widget::$defaultOptions;
		} else {
			if (!isset($options['dates_from_preset'])) {
				$options['dates_from_preset'] = 0;
			}
			$options = array_merge(PP_WCFER_Widget::$defaultOptions, $options);
		}
		echo('
				<p>
					<label for="'.$this->get_field_id('title').'">Title:</label>
					<input type="text" id="'.$this->get_field_id('title').'" name="'.$this->get_field_name('title').'" style="width: 100%;" value="'.htmlspecialchars($options['title']).'" />
				</p>
				<p>
					<label for="'.$this->get_field_id('source').'">Report Source:</label>
					<select id="'.$this->get_field_id('source').'" name="'.$this->get_field_name('source').'" onchange="jQuery(this).closest(\'form\').find(\'.pp_wcfer_reports\').hide(); jQuery(this).closest(\'form\').find(\'select.\' + jQuery(this).val() + \'_reports\').show();">');
					foreach ($reports as $reportSourceId => $reportSourceData)
						echo('<option value="'.$reportSourceId.'"'.($options['source'] == $reportSourceId ? ' selected="selected"' : '').'>'.$reportSourceData['name'].'</option>');
		echo('
					</select>
				</p>
				<p>
					<label>Report Preset:</label>');
				foreach ($reports as $reportSourceId => $reportSourceData) {
					echo('<select name="'.$this->get_field_name($reportSourceId.'_report').'" class="pp_wcfer_reports '.$reportSourceId.'_reports" style="display: none;">');
					foreach ($reportSourceData['reports'] as $reportId => $reportName)
						echo('<option value="'.$reportId.'"'.(isset($options[$reportSourceId.'_report']) && $options[$reportSourceId.'_report'] == $reportId ? ' selected="selected"' : '').'>'.htmlspecialchars($reportName).'</option>');
					echo('</select>');
				}
		echo('
				</p>
				<p>
					<label>Report Date Range:</label>
					<label class="pp_wcfer_mb5"><input type="radio" name="'.$this->get_field_name('dates_from_preset').'" value="1"'.($options['dates_from_preset'] ? ' checked' : '').'> Use date range from preset</label><br>
					<label><input type="radio" name="'.$this->get_field_name('dates_from_preset').'" value="0"'.($options['dates_from_preset'] ? '' : ' checked').'> Previous</label>
					<label style="margin-right: 20px;"><input type="number" name="'.$this->get_field_name('days').'" value="'.$options['days'].'" min="1" step="1" style="width: 50px;" /> days</label>
					<label><input type="checkbox" name="'.$this->get_field_name('includetoday').'"'.(empty($options['includetoday']) ? '' : ' checked="checked"').' /> Include today</label>
				</p>
				<p>
					<label>Display Options:</label>
					<label class="pp_wcfer_mb5"><input type="checkbox" id="'.$this->get_field_id('plain').'" name="'.$this->get_field_name('plain').'"'.(empty($options['plain']) ? '' : ' checked="checked"').' onchange="jQuery(\'#'.$this->get_field_id('nosearch').', #'.$this->get_field_id('perpage').'\').prop(\'disabled\', jQuery(this).is(\':checked\'));" /> Plain mode (no pagination, search, and re-ordering)</label>
					<label class="pp_wcfer_mb5"><input type="checkbox" id="'.$this->get_field_id('nosearch').'" name="'.$this->get_field_name('nosearch').'"'.(empty($options['nosearch']) ? '' : ' checked="checked"').' /> Hide search box</label>
					<label style="display: block;">Show <input type="number" id="'.$this->get_field_id('perpage').'" name="'.$this->get_field_name('perpage').'" value="'.$options['perpage'].'" min="1" step="1" style="width: 50px;" /> rows per page</label>
				</p>
				<script>jQuery(\'#'.$this->get_field_id('source').', #'.$this->get_field_id('plain').'\').change();</script>
				');
		echo('</div>');
	}
	
	public function update($new, $old) {
		$options = array_intersect_key($new, PP_WCFER_Widget::$defaultOptions);
		if (isset($new[$options['source'].'_report']))
			$options[$options['source'].'_report'] = $new[$options['source'].'_report'];
		if (!is_numeric($options['days']))
			$options['days'] = PP_WCFER_Widget::$defaultOptions['days'];
		$options['includetoday'] = (empty($new['includetoday']) ? 0 : 1);
		$options['plain'] = (empty($new['plain']) ? 0 : 1);
		$options['nosearch'] = (empty($new['nosearch']) ? 0 : 1);
		$options['dates_from_preset'] = (empty($new['dates_from_preset']) ? 0 : 1);
		if (!is_numeric($options['perpage']))
			$options['perpage'] = PP_WCFER_Widget::$defaultOptions['perpage'];
		
		
		return $options;
	}
}


/** Licensing **/

function pp_wcfer_license_check($silent=true) {
	if( isset( $_POST['pp_wcfer_license_deactivate'] )) {
		pp_wcfer_deactivate_license();
	}

	if (get_option('pp_wcfer_license_status', 'invalid') == 'valid') {
		return true;
	} else {
		if( isset( $_POST['pp_wcfer_license_activate'] ) && !empty($_POST['pp_wcfer_license_key']) && ctype_alnum($_POST['pp_wcfer_license_key']) ) {
			update_option('pp_wcfer_license_key', trim($_POST['pp_wcfer_license_key']));
			pp_wcfer_activate_license();
			if (get_option('pp_wcfer_license_status', 'invalid') == 'valid')
				return true;
		}
		
		if (!$silent) {
			echo('
			<div style="background-color: #fff; border: 1px solid #ccc; padding: 20px; margin-bottom: 20px; display: inline-block;">
				<form action="" method="post">
			');
			wp_nonce_field( 'pp_wcfer_license_activate_nonce', 'pp_wcfer_license_activate_nonce' );
			echo('
					<label for="pp_wcfer_license_activate" style="display: block; margin-bottom: 10px;">Please enter the license key provided when you purchased the plugin:</label>
					<input type="text" id="pp_wcfer_license_key" name="pp_wcfer_license_key" />
					<button type="submit" name="pp_wcfer_license_activate" value="1" class="button-primary">Activate</button>
				</form>
			</div>
			');
		}
		return false;
	}
}
	
function pp_wcfer_activate_license() {

	// run a quick security check
	if( ! check_admin_referer( 'pp_wcfer_license_activate_nonce', 'pp_wcfer_license_activate_nonce' ) )
		return; // get out if we didn't click the Activate button

	// retrieve the license
	$license = trim( get_option( 'pp_wcfer_license_key' ) );

	// data to send in our API request
	$api_params = array(
		'edd_action'=> 'activate_license',
		'license' 	=> $license,
		'item_name' => urlencode( PP_WCFER_ITEM_NAME ), // the name of our product in EDD
		'url'       => home_url()
	);

	// Call the custom API.
	$response = wp_remote_post( PP_WCFER_STORE_URL, array( 'timeout' => 15, 'sslverify' => false, 'body' => $api_params ) );
	
	// make sure the response came back okay
	if ( is_wp_error( $response ) )
		return false;

	// decode the license data
	$license_data = json_decode( wp_remote_retrieve_body( $response ) );

	// $license_data->license will be either "valid" or "invalid"

	update_option( 'pp_wcfer_license_status', $license_data->license );

}

function pp_wcfer_deactivate_license() {

	// run a quick security check
	if( ! check_admin_referer( 'pp_wcfer_license_deactivate_nonce', 'pp_wcfer_license_deactivate_nonce' ) )
		return; // get out if we didn't click the dectivate button

	// retrieve the license from the database
	$license = trim( get_option( 'pp_wcfer_license_key' ) );

	// data to send in our API request
	$api_params = array(
		'edd_action'=> 'deactivate_license',
		'license' 	=> $license,
		'item_name' => urlencode( PP_WCFER_ITEM_NAME ), // the name of our product in EDD
		'url'       => home_url()
	);

	// Call the custom API.
	$response = wp_remote_post( PP_WCFER_STORE_URL, array( 'timeout' => 15, 'sslverify' => false, 'body' => $api_params ) );

	// make sure the response came back okay
	if ( is_wp_error( $response ) )
		return false;

	// decode the license data
	$license_data = json_decode( wp_remote_retrieve_body( $response ) );

	// $license_data->license will be either "deactivated" or "failed"
	if( $license_data->license == 'deactivated' )
		delete_option( 'pp_wcfer_license_status' );
}



// this is the URL our updater / license checker pings. This should be the URL of the site with EDD installed
define( 'PP_WCFER_STORE_URL', 'https://potentplugins.com' ); // you should use your own CONSTANT name, and be sure to replace it throughout this file

// the name of your product. This should match the download name in EDD exactly
define( 'PP_WCFER_ITEM_NAME', 'Frontend Reports for WooCommerce Plugin' ); // you should use your own CONSTANT name, and be sure to replace it throughout this file

if( !class_exists( 'PP_WCFER_EDD_SL_Plugin_Updater' ) ) {
	// load our custom updater
	include( dirname( __FILE__ ) . '/EDD_SL_Plugin_Updater.php' );
}
function pp_wcfer_register_option() {
	// creates our settings in the options table
	register_setting('pp_wcfer_license', 'pp_wcfer_license_key', 'pp_wcfer_sanitize_license' );
}
add_action('admin_init', 'pp_wcfer_register_option');

function pp_wcfer_plugin_updater() {

	// retrieve our license key from the DB
	$license_key = trim( get_option( 'pp_wcfer_license_key' ) );

	// setup the updater
	$edd_updater = new PP_WCFER_EDD_SL_Plugin_Updater( PP_WCFER_STORE_URL, __FILE__, array(
			'version' 	=> '1.0.3', 			// current version number
			'license' 	=> $license_key, 		// license key (used get_option above to retrieve from DB)
			'item_name' => PP_WCFER_ITEM_NAME, 	// name of this plugin
			'author' 	=> 'Potent Plugins'  // author of this plugin
		)
	);

}
add_action( 'admin_init', 'pp_wcfer_plugin_updater', 0 );

function pp_wcfer_sanitize_license( $new ) {
	$old = get_option( 'pp_wcfer_license_key' );
	if( $old && $old != $new ) {
		delete_option( 'pp_wcfer_license_status' ); // new license has been entered, so must reactivate
	}
	return $new;
}

?>