const UglifyJsPlugin = require( 'uglifyjs-webpack-plugin' );
const DependencyExtractionWebpackPlugin = require( '@wordpress/dependency-extraction-webpack-plugin' );
const webpack = require( 'webpack' );
const { CleanWebpackPlugin } = require( 'clean-webpack-plugin' );
const path = require('path');

module.exports = {
	mode: 'production',
	entry: {
		'js/admin/post-campaign.min': './js/admin/PostCampaign.jsx',
		'js/admin/post-campaign': './js/admin/PostCampaign.jsx',
	},
	context: path.resolve(__dirname, 'assets'),
	output: {
		filename: '[name].js',
		path: __dirname + '/dist/',
	},
	module: {
		rules: [
			{
				enforce: 'pre',
				test: /\.(js|jsx)$/,
				exclude: /node_modules/,
				loader: 'eslint-loader',
				options: {
					emitWarning: true,
				}
			},
			{
				test: /\.(js|jsx)$/,
				exclude: /node_modules/,
				use: {
					loader: 'babel-loader',
				},
			},
		],
		noParse: /\.asset\.json|\.asset\.php/,
	},
	optimization: {
		minimize: true,
		minimizer: [
			new UglifyJsPlugin( {
				include: /\.min\.js$/,
				sourceMap: true,
			} ),
		],
	},
	plugins: [
		//Dirty hack to remove asset.(php|json) generated by the DependencyExtractionWebpackPlugin
		new CleanWebpackPlugin( {
			verbose: true,
			protectWebpackAssets: false,
			cleanOnceBeforeBuildPatterns: [],
			cleanAfterEveryBuildPatterns: [
				'**/*.asset.json',
				'**/*.asset.php',
			],
		} ),
		new webpack.SourceMapDevToolPlugin( {
			filename: '[file].map',
			include: /\.min\.js$/,
		} ),
		new DependencyExtractionWebpackPlugin(),
	],
	watchOptions: {
		poll: true,
		ignored: /node_modules/,
	},
};
