<?php 
class WCMCA_AdminOrderDetailsPage
{
	public function __construct()
	{
		add_action( 'woocommerce_admin_order_data_after_order_details', array( &$this,'add_additional_addresses_loading_tools')); 
		add_action( 'woocommerce_admin_order_data_after_billing_address', array( &$this,'add_custom_billing_fields'), 10, 1 );
		add_action( 'woocommerce_process_shop_order_meta', array( &$this, 'on_save_order_details_admin_page' ), 5, 2 );//save order	
		
		add_action( 'woocommerce_after_order_itemmeta', array( &$this, 'display_product_shipping_address' ), 10, 3 );
		
		add_filter( 'woocommerce_admin_shipping_fields',  array( &$this,'add_extra_shipping_fields_to_order_details_fields' )); //admin order details page
		//add_action('woocommerce_order_details_after_customer_details', array( &$this,'add_shipping_fields' ));
	}
	public function add_extra_shipping_fields_to_order_details_fields($fields)
	{
		global $wcmca_address_model;
		$shipping_email = $wcmca_address_model->get_shipping_email_field_data();
		$phone_email = $wcmca_address_model->get_shipping_phone_field_data();
		if(!empty($shipping_email))
			$fields['email'] = array(
				'label' => __( 'Email', 'woocommerce-eu-vat-field' ),
				'show'  => true
			);
		
		if(!empty($phone_email))
			$fields['phone'] = array(
				'label' => __( 'Phone', 'woocommerce-eu-vat-field' ),
				'show'  => true
			);
		return $fields;
	}
	function display_product_shipping_address($item_id, $item, $_product )
	{
		global $wcmca_order_model, $wcmca_option_model;		
		$get_formatted_item_shipping_address = $wcmca_option_model->shipping_per_product() ? $wcmca_order_model->get_formatted_item_shipping_address($item) : "";
		
		if($get_formatted_item_shipping_address)
			echo $get_formatted_item_shipping_address;
	}
	public function add_custom_billing_fields($order)
	{
		global $wcmca_option_model, $wcev_order_model;
		if(isset($wcev_order_model) || !$wcmca_option_model->is_vat_identification_number_enabled())
			return;
		$billing_vat_number = get_post_meta(WCMCA_Order::get_id($order), 'billing_vat_number',true);
		$billing_vat_number = $billing_vat_number ? $billing_vat_number : "";
		?>
		<p class="form-row form-row-wide">
			<label class="wpuef_label"><?php _e( 'VAT Identification Number', 'woocommerce-multiple-customer-addresses' ); ?></label>
			<input class="input-text wpuef_input_text" type="text" placeholder="<?php _e( 'VAT Identification Number', 'woocommerce-multiple-customer-addresses' ); ?>" value="<?php echo $billing_vat_number; ?>" name="billing_vat_number" />
		</p>
		<?php
	}
	public function on_save_order_details_admin_page( $order_id, $order )
	{
		global $wcev_order_model;
		if(!isset($wcev_order_model) && isset($_POST['billing_vat_number']))
			update_post_meta($order_id,'billing_vat_number', $_POST['billing_vat_number']);
	}
	public function add_additional_addresses_loading_tools($order)
	{
		global $wcmca_html_helper;
		$wcmca_html_helper->render_admin_order_page_additional_addresses_loading_tools();
	}
}
?>