<?php

/**
 * Class rapid_stock_manager_notifications
 */
class rapid_stock_manager_notifications extends core_rapid_stock_manager
{
    private $notificationThreshold;
    private $notificationEmails;
    private $mailQueue;

    /** @var core_rapid_stock_manager */
    private $rapidStockManager;

    public function __construct($rapidStockManager)
    {
        add_action('woocommerce_reduce_order_stock', array($this, 'rsm_notifications_reduce_stock_hook'));
        $this->notificationThreshold = get_option('wc_settings_tab_rapid_sm_notification_threshold');
        $this->notificationEmails = get_option('wc_settings_tab_rapid_sm_notification_emails');
        $this->rapidStockManager = $rapidStockManager;
        $this->mailQueue = array();
    }

    /**
     * @param WC_Order $order
     */
    public function rsm_notifications_reduce_stock_hook($order)
    {
        /** @var WC_Order_Item_Product $item */
        foreach ($order->get_items() as $item) {
            $this->rsm_notifications_check_low_stock(array($item->get_product_id()), 'Main');
        }
    }


    /**
     * Check if product has low stock in compare with settings
     * @param array $productIds
     * @param string $warehouse
     */
    public function rsm_notifications_check_low_stock($productIds, $warehouse)
    {

        foreach ($productIds as $productId) {
            if ($warehouse == 'Main') {

                $product = wc_get_product($productId);

                if ($product->get_stock_quantity() <= $this->notificationThreshold) {
                    $this->mailQueue[] = array('product' => $productId, 'warehouse' => $warehouse);
                }

            } else {
                $warehouseValue = $this->rapidStockManager->warehouse->getWareHouseData($warehouse, $productId);

                if ($warehouseValue <= $this->notificationThreshold && $warehouseValue != "") {
                    $this->mailQueue[] = array('product' => $productId, 'warehouse' => $warehouse);
                }
            }

        }


        if (!empty($this->mailQueue)) {
            $this->rsm_notifications_send_email($this->mailQueue);
        }
    }

    /**
     * Send emails from queue
     * @param array $queue
     */
    public function rsm_notifications_send_email(array $queue)
    {
        $isSmtp = get_option('wc_settings_tab_rapid_sm_smtp_enable') == 'yes' ? true : false;
        $emails = explode(',', preg_replace('/\s+/', '', $this->notificationEmails));

        if (count($queue) > 1) {
            $subject = 'Low stock for products';
        } else {
            $product = wc_get_product($queue[0]['product']);
            $subject = sprintf('Low stock for product %s SKU: %s', $product->get_name(), $product->get_sku());
        }

        $htmlBody = '';
        foreach ($queue as $queueProject) {

            $product = wc_get_product($queueProject['product']);
            $htmlBody .= $this->rsm_notifications_email_html($product, $queueProject['warehouse']);
        }

        if ($isSmtp) {
            add_action('phpmailer_init', array($this, 'rsm_notifications_smtp'));
        }
        add_filter('wp_mail_content_type', array($this, 'rsm_notifications_set_mail_content_type'));

        foreach ($emails as $email) {
            wp_mail($email, $subject, $htmlBody);
        }

        remove_filter('wp_mail_content_type', array($this, 'rsm_notifications_set_mail_content_type'));
        if ($isSmtp) {
            remove_action('phpmailer_init', array($this, 'rsm_notifications_smtp'));
        }

    }

    /**
     * Render email HTML
     * @param WC_Product $product
     * @param $warehouse
     * @return false|string
     */
    private function rsm_notifications_email_html($product, $warehouse)
    {
        ob_start();
        ?>
        <p>
            Product <a href="<?php echo get_permalink($product->get_id()); ?>"><?php echo $product->get_name(); ?></a> SKU: <?php echo $product->get_sku(); ?> reached low stock threshold (<?php echo $this->notificationThreshold; ?>) in <?php echo $warehouse; ?> warehouse. Go to <a
                    href="<?php echo admin_url('admin.php?page=update_stock_rapid' . ($product->is_type('variation') ? '&rapid-selector-view=variation_product' : '&rapid-selector-view=simple_product') . ($warehouse != 'Main' ? '&warehouse=' . $warehouse : '')); ?>">Rapid stock Manager</a> or <a
                    href="<?php echo admin_url('post.php?post=' . $product->get_id() . '&action=edit'); ?>">click here</a> to edit the
            product.
        </p>
        <?php
        $output = ob_get_contents();
        ob_end_clean();
        return $output;
    }

    function rsm_notifications_set_mail_content_type()
    {
        return 'text/html';
    }

    function rsm_notifications_smtp($phpmailer)
    {
        $phpmailer->isSMTP();
        $phpmailer->Host = 'smtp.mailtrap.io';
        $phpmailer->SMTPAuth = true;
        $phpmailer->Port = 2525;
        $phpmailer->Username = 'd6f0a6eabb1052';
        $phpmailer->Password = 'ce0e8010bf05a1';
    }

}