<?php
/**
 * PRO Greetings - template - 1 - Form.
 *
 * @package Click_To_Chat_Pro
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$g1_pro_options = get_option( 'ht_ctc_greetings_pro_1' );
$greetings      = get_option( 'ht_ctc_greetings_options' );

$os = get_option( 'ht_ctc_othersettings' );


$is_number_field       = 'n';
$is_date_field         = 'n';
$is_select_placeholder = 'n';

$ht_ctc_greetings['main_content'] = do_shortcode( $ht_ctc_greetings['main_content'] );

$header_css      = 'display: flex; align-items: center; padding: 12px 19px 12px 19px;';
$main_css        = 'padding: 18px 19px 5px 19px;';
$message_box_css = '';
// sticky call to action -  position:sticky; bottom:-9px;
$send_css   = 'text-align:center; padding: 11px 19px 9px 19px;';
$bottom_css = 'padding: 2px 19px 2px 19px; text-align:center; font-size:12px; background-color:#ffffff;';

// css
$header_bg_color = ( isset( $g1_pro_options['header_bg_color'] ) ) ? esc_attr( $g1_pro_options['header_bg_color'] ) : '';
if ( '' === $header_bg_color ) {
	$header_bg_color = '#ffffff';
}
$main_bg_color = ( isset( $g1_pro_options['main_bg_color'] ) ) ? esc_attr( $g1_pro_options['main_bg_color'] ) : '';
if ( '' === $main_bg_color ) {
	$main_bg_color = '#ffffff';
}
$message_box_bg_color = ( isset( $g1_pro_options['message_box_bg_color'] ) ) ? esc_attr( $g1_pro_options['message_box_bg_color'] ) : '';

$header_css .= "background-color:$header_bg_color;";

if ( '' !== $main_bg_color ) {
	$main_css .= "background-color:$main_bg_color;";
}

if ( '' !== $message_box_bg_color ) {
	$message_box_css .= "padding:6px 8px;border-radius:5px;margin-bottom:5px;background-color:$message_box_bg_color;";
} else {
	$message_box_css .= 'margin-bottom:5px;';
}

$rtl_page = '';
if ( function_exists( 'is_rtl' ) && is_rtl() ) {
	$rtl_page = 'yes';
}

$g_header_image_css = 'border-radius:50%;height:50px; width:50px;';
if ( 'yes' === $rtl_page ) {
	$g_header_image_css .= 'margin-left:9px;';
} else {
	$g_header_image_css .= 'margin-right:9px;';
}

$cta_style = ( isset( $g1_pro_options['cta_style'] ) ) ? esc_attr( $g1_pro_options['cta_style'] ) : '7_1';

$g_cta_path = plugin_dir_path( HT_CTC_PLUGIN_FILE ) . 'new/inc/greetings/greetings_styles/g-cta-' . $cta_style . '.php';
// $g_cta_path = plugin_dir_path( HT_CTC_PRO_PLUGIN_FILE ) . 'public/greetings/greetings_styles/g-cta-' . $cta_style. '.php';

$fields  = ( isset( $g1_pro_options['fields'] ) ) ? array_map( 'esc_attr', $g1_pro_options['fields'] ) : '';
$key_gen = 1;

// fileds css..
$fileds_pr_css   = 'margin-bottom:8px; display:flex; flex-wrap: wrap; flex-direction: column;';
$filed_label_css = 'margin:0px; padding:0px;';
$filed_input_css = 'border-radius:4px; background-color: #ffffff; width:100%; padding: 9px;';

// removed this.. if main plugin 3.28 or later added in main.css
// $filed_input_css .= "box-sizing:border-box;";

	// filed checkbox..
$filed_checbox_pr_css    = 'margin-bottom: 4px; display:flex; flex-direction:row; align-items:center;';
$filed_checbox_input_css = 'margin:0;';
$filed_checbox_label_css = 'margin: 0px; padding: 0 4px;';

$filed_hidden_pr_css = 'display:none;';

// intl number field css..
$filed_input_css_intl = 'border-radius:4px; background-color: #ffffff; width:100%; box-sizing:border-box;';

$filed_input_css_intl .= 'padding: 9px;';
// $filed_input_css_intl .= "padding-top: 9px; padding-bottom: 9px;";


$g_header_image = ( isset( $greetings['g_header_image'] ) ) ? esc_attr( $greetings['g_header_image'] ) : '';

if ( '' !== $g_header_image ) {
	$header_css .= 'line-height:1.1;';
} else {
	$header_css .= 'line-height:1.3;';
}

?>
<div class="greetings-pro-1">
<?php
if ( '' !== $ht_ctc_greetings['header_content'] ) {
	?>
	<div class="ctc_g_heading" style="<?php echo esc_attr( $header_css ); ?>">
		<?php
		if ( ! empty( $g_header_image ) ) {
			?>
		<div class="greetings_header_image" style="<?php echo esc_attr( $g_header_image_css ); ?>">
			<?php
			try {
				$filename_without_extension = pathinfo( $g_header_image, PATHINFO_FILENAME );
			} catch ( Exception $e ) {
				$filename_without_extension = 'header-image'; // Fallback value
			}
			?>
			<img style="display:inline-block; border-radius:50%; height:50px; width:50px;" src="<?php echo esc_url( $g_header_image ); ?>" alt="<?php echo esc_attr( $filename_without_extension ); ?>">
			<?php
			if ( isset( $greetings['g_header_online_status'] ) ) {
				$g_header_online_status_color = ( isset( $greetings['g_header_online_status_color'] ) ) ? esc_attr( $greetings['g_header_online_status_color'] ) : '';
				if ( '' === $g_header_online_status_color ) {
					$g_header_online_status_color = '#06e376';
				}
				?>
				<span class="for_greetings_header_image_badge" style="display:none; border: 2px solid <?php echo esc_attr( $header_bg_color ); ?>; background-color: <?php echo esc_attr( $g_header_online_status_color ); ?>;"></span>
				<?php
			}
			?>
		</div>
			<?php
		}
		?>
		<div class="ctc_g_header_content">
			<?php echo wp_kses_post( wpautop( $ht_ctc_greetings['header_content'] ) ); ?>
		</div>
	</div>
	<?php
}
?>
	<div class="ctc_g_content" style="<?php echo esc_attr( $main_css ); ?>">
		<?php
		if ( '' !== $ht_ctc_greetings['main_content'] ) {
			?>
		<div class="ctc_g_message_box" style="<?php echo esc_attr( $message_box_css ); ?>"><?php echo wp_kses_post( wpautop( $ht_ctc_greetings['main_content'] ) ); ?></div>
			<?php
		}
		?>
		<div class="ctc_g_form">
			<form id="ctc_pro_greetings_form" class="ctc_pro_greetings_form" name="ctc_pro_greetings_form">
				<div class="ctc_g_form_keys" style="display: none;">
					<?php wp_nonce_field( 'ht_ctc_pro_greetings_nonce', 'ht_ctc_pro_greetings_nonce' ); ?>
				</div>
				<?php
				if ( is_array( $fields ) && isset( $fields[0] ) ) {
					foreach ( $fields as $field ) {
						// if date field is added. it contains date, time, timezone input filed add with same key_gen i.e. name with suffix or _time, _timezone.
						$name             = "field_$key_gen";
						$id_gen           = "ht_ctc_g_form_$key_gen";
						$field_options    = ( isset( $g1_pro_options[ $field ] ) ) ? array_map( 'esc_attr', $g1_pro_options[ $field ] ) : '';
						$field_type       = ( isset( $field_options['type'] ) ) ? $field_options['type'] : '';
						$required         = ( isset( $field_options['required'] ) ) ? ' required' : '';
						$add_to_prefilled = ( isset( $field_options['add_to_prefilled'] ) ) ? ' ctc_g_field_add_to_prefilled' : '';

						$hiddenvalue = ( isset( $field_options['hiddenvalue'] ) ) ? $field_options['hiddenvalue'] : '';

						$field_name = ( isset( $field_options['name'] ) ) ? $field_options['name'] : '';
						$field_name = apply_filters( 'wpml_translate_single_string', $field_name, 'Click to Chat for WhatsApp', "greetings_form_$field" . '_name' );

						$placeholder = ( isset( $field_options['placeholder'] ) ) ? $field_options['placeholder'] : '';
						$placeholder = apply_filters( 'wpml_translate_single_string', $placeholder, 'Click to Chat for WhatsApp', "greetings_form_$field" . '_placeholder' );

						$time_name = ( isset( $field_options['time_name'] ) ) ? $field_options['time_name'] : '';
						$time_name = apply_filters( 'wpml_translate_single_string', $time_name, 'Click to Chat for WhatsApp', "greetings_form_$field" . '_time_name' );

						if ( 'text' === $field_type ) {
							?>
							<div class="ctc_form_field <?php echo esc_attr( $id_gen ); ?>" style="<?php echo esc_attr( $fileds_pr_css ); ?>">
								<label style="<?php echo esc_attr( $filed_label_css ); ?>" for="<?php echo esc_attr( $id_gen ); ?>"><?php echo esc_html( $field_name ); ?></label>
								<input type="<?php echo esc_attr( $field_type ); ?>" style="<?php echo esc_attr( $filed_input_css ); ?>" class="ht_ctc_g_form_field <?php echo esc_attr( $add_to_prefilled ); ?>" id="<?php echo esc_attr( $id_gen ); ?>" name="<?php echo esc_attr( $name ); ?>" <?php echo esc_attr( $required ); ?> data-name="<?php echo esc_attr( $field_name ); ?>" style="width:100%;" placeholder="<?php echo esc_attr( $placeholder ); ?>">
							</div>
							<?php
						} elseif ( 'textarea' === $field_type ) {
							?>
							<div class="ctc_form_field <?php echo esc_attr( $id_gen ); ?>" style="<?php echo esc_attr( $fileds_pr_css ); ?>">
								<label style="<?php echo esc_attr( $filed_label_css ); ?>" for="<?php echo esc_attr( $id_gen ); ?>"><?php echo esc_html( $field_name ); ?></label>
								<textarea name="<?php echo esc_attr( $name ); ?>" style="<?php echo esc_attr( $filed_input_css ); ?>" class="ht_ctc_g_form_field <?php echo esc_attr( $add_to_prefilled ); ?>" id="<?php echo esc_attr( $id_gen ); ?>" <?php echo esc_attr( $required ); ?> data-name="<?php echo esc_attr( $field_name ); ?>" placeholder="<?php echo esc_attr( $placeholder ); ?>" style="height: 69px; width:100%;"></textarea>
							</div>
							<?php
						} elseif ( 'checkbox' === $field_type ) {
							$checkbox_label_field_name     = preg_replace( '/\[(.*?)\]\s*\(((?:http:\/\/|https:\/\/)(?:.+))\)/', '<a target="_blank" href="$2">$1</a>', $field_name );
							$checkbox_data_name_field_name = preg_replace( '/\[(.*?)\]\s*\(((?:http:\/\/|https:\/\/)(?:.+))\)/', '$1', $field_name );
							?>
							<div class="ctc_form_field <?php echo esc_attr( $id_gen ); ?>" style="<?php echo esc_attr( $filed_checbox_pr_css ); ?>">
								<input type="hidden" class="ht_ctc_g_form_field ctc_g_hidden_for_checkbox" value="-" data-name="<?php echo esc_attr( $checkbox_data_name_field_name ); ?>" name="<?php echo esc_attr( $name ); ?>">
								<input type="<?php echo esc_attr( $field_type ); ?>" style="<?php echo esc_attr( $filed_checbox_input_css ); ?>" class="ht_ctc_g_form_field ctc_g_its_checkbox <?php echo esc_attr( $add_to_prefilled ); ?>" id="<?php echo esc_attr( $id_gen ); ?>" <?php echo esc_attr( $required ); ?> data-name="<?php echo esc_attr( $checkbox_data_name_field_name ); ?>" name="<?php echo esc_attr( $name ); ?>">
								<label style="<?php echo esc_attr( $filed_checbox_label_css ); ?>" for="<?php echo esc_attr( $id_gen ); ?>"><?php echo wp_kses_post( $checkbox_label_field_name ); ?></label>
							</div>
							<?php
						} elseif ( 'hidden' === $field_type ) {
							?>
							<div class="ctc_form_field <?php echo esc_attr( $id_gen ); ?>" style="<?php echo esc_attr( $filed_hidden_pr_css ); ?>">
								<input type="hidden" class="ht_ctc_g_form_field_hidden ht_ctc_g_form_field <?php echo esc_attr( $add_to_prefilled ); ?>" id="<?php echo esc_attr( $id_gen ); ?>" name="<?php echo esc_attr( $name ); ?>" data-name="<?php echo esc_attr( $field_name ); ?>" data-orginal="<?php echo esc_attr( $hiddenvalue ); ?>" value="<?php echo esc_attr( $hiddenvalue ); ?>">
							</div>
							<?php
						} elseif ( 'select' === $field_type ) {
							// Note: if not empty then only display select field.

							$selectvalues = ( isset( $field_options['selectvalues'] ) ) ? $field_options['selectvalues'] : '';
							$selectvalues = apply_filters( 'wpml_translate_single_string', $selectvalues, 'Click to Chat for WhatsApp', "greetings_form_$field" . '_selectvalues' );


							if ( is_string( $selectvalues ) && ! empty( $selectvalues ) ) {

								// create array from string with comma separated values and new line.
								// (comma, new line both added, it can consider as multiple fileds.if not empyty is called at select field. to avoid empty select field.)
								$selectvalues = preg_split( "/\r\n|\n|\r|,/", $selectvalues );
								// $selectvalues = preg_split( "/\n|,/", $selectvalues );
								?>

								<div class="ctc_form_field <?php echo esc_attr( $id_gen ); ?>" style="<?php echo esc_attr( $fileds_pr_css ); ?>">
									<label style="<?php echo esc_attr( $filed_label_css ); ?>" for="<?php echo esc_attr( $id_gen ); ?>"><?php echo esc_html( $field_name ); ?></label>
								<select name="<?php echo esc_attr( $name ); ?>" style="<?php echo esc_attr( $filed_input_css ); ?>" class="ht_ctc_g_form_field <?php echo esc_attr( $add_to_prefilled ); ?>" id="<?php echo esc_attr( $id_gen ); ?>" <?php echo esc_attr( $required ); ?> data-name="<?php echo esc_attr( $field_name ); ?>" style="width:100%;">
										<?php
										// if placeholder not empty..
										if ( '' !== $placeholder ) {
											$is_select_placeholder = 'y';
											?>
											<option value="" style="color:gray"><?php echo esc_html( $placeholder ); ?></option>
											<?php
										}
										if ( is_array( $selectvalues ) && isset( $selectvalues[0] ) ) {
											foreach ( $selectvalues as $select_value ) {
												$select_value = trim( $select_value );
												if ( '' !== $select_value ) {
													?>
													<option value="<?php echo esc_attr( $select_value ); ?>"><?php echo esc_html( $select_value ); ?></option>
													<?php
												}
											}
										}
										?>
									</select>
								</div>
								<?php
							}
						} elseif ( 'number' === $field_type ) {
							/**
							 * Intl number field
							 *
							 * Note: field value: full number with country code. only getting if number is valid like.. if only a few digits is added its not getting country code.
							 *
							 * if is_number_field is y. then add styles related to intl number field. styles added after this loop..
							 *
							 * add ht_ctc_g_form_field class name to the hidden field created by intltel. and similar ctc_g_field_add_to_prefilled if required.
							 */
							$is_number_field = 'y';
							?>
							<div class="ctc_form_field <?php echo esc_attr( $id_gen ); ?> ctc_form_intl_input" style="<?php echo esc_attr( $fileds_pr_css ); ?>" >
								<label style="<?php echo esc_attr( $filed_label_css ); ?>" for="<?php echo esc_attr( $id_gen ); ?>"><?php echo esc_html( $field_name ); ?></label>
								<input type="text" class="ctc_intl_number ht_ctc_default ctc_number_padding <?php echo esc_attr( $add_to_prefilled ); ?>" style="<?php echo esc_attr( $filed_input_css_intl ); ?>" id="<?php echo esc_attr( $id_gen ); ?>" name="<?php echo esc_attr( $name ); ?>" <?php echo esc_attr( $required ); ?> data-name="<?php echo esc_attr( $field_name ); ?>" style="width:100%;" placeholder="<?php echo esc_attr( $placeholder ); ?>">
							</div>
							<?php
						} elseif ( 'date' === $field_type ) {
							$is_date_field = 'y';

							// Get date mode from settings
							$form_date = ( isset( $g1_pro_options['form_date'] ) ) ? $g1_pro_options['form_date'] : '';
							$date_mode = ( isset( $form_date['date_mode'] ) ) ? esc_attr( $form_date['date_mode'] ) : 'scheduler';

							// Debug: uncomment to see current date mode
							// echo '<!-- DEBUG: Date mode = ' . $date_mode . ' -->';

							?>
							<div class="ctc_form_field <?php echo esc_attr( $id_gen ); ?> ctc_fd_form_date" style="<?php echo esc_attr( $fileds_pr_css ); ?>" data-date-mode="<?php echo esc_attr( $date_mode ); ?>">

								<label style="<?php echo esc_attr( $filed_label_css ); ?>" for="<?php echo esc_attr( $id_gen ); ?>"><?php echo esc_html( $field_name ); ?></label>

								<?php if ( 'date_only' === $date_mode ) { ?>
									<!-- Date Only Mode -->
									<div class="ctc_fd_date_only_container">
										<input type="date" class="ht_ctc_g_form_field <?php echo esc_attr( $add_to_prefilled ); ?> ctc_fd_date_only_input" id="<?php echo esc_attr( $id_gen ); ?>" name="<?php echo esc_attr( $name ); ?>" data-name="<?php echo esc_attr( $field_name ); ?>" <?php echo esc_attr( $required ); ?> style="<?php echo esc_attr( $filed_input_css ); ?>">
									</div>
								<?php } else { ?>
									<!-- Scheduler Mode -->
									<div class="ctc_fd_date_fields">
										<div class="ctc_fd_scheduler_container">
											<div style="<?php echo esc_attr( $fileds_pr_css ); ?>">
												<input type="text" class="ht_ctc_g_form_field <?php echo esc_attr( $add_to_prefilled ); ?> ctc_fd_date_input" id="<?php echo esc_attr( $id_gen ); ?>" name="<?php echo esc_attr( $name ); ?>" data-name="<?php echo esc_attr( $field_name ); ?>" placeholder="<?php echo esc_attr( $placeholder ); ?>" <?php echo esc_attr( $required ); ?> style="<?php echo esc_attr( $filed_input_css ); ?>" readonly>
											</div>
											<div id="ctc_fd_time_slot_group" style="<?php echo esc_attr( $fileds_pr_css ); ?> display:none;">
												<label style="<?php echo esc_attr( $filed_label_css ); ?>" for="<?php echo esc_attr( $id_gen ); ?>_time"><?php echo esc_html( $time_name ); ?></label>
												<input type="text" class="ht_ctc_g_form_field <?php echo esc_attr( $add_to_prefilled ); ?> ctc_fd_time_input" id="<?php echo esc_attr( $id_gen ); ?>_time" name="<?php echo esc_attr( $name ); ?>_time" data-name="<?php echo esc_attr( $time_name ); ?>" readonly style="<?php echo esc_attr( $filed_input_css ); ?>">
												<input type="hidden" class="ht_ctc_g_form_field <?php echo esc_attr( $add_to_prefilled ); ?> ctc_user_tz" id="<?php echo esc_attr( $id_gen ); ?>_tz" name="<?php echo esc_attr( $name ); ?>_tz" data-name="User TimeZone">
											</div>
										</div>

										<div class="ht_ctc_defaults">
											<!-- Overlay for modal background -->
											<div class="ctc_cal_modal_overlay hidden" id="ctc_cal_modal_overlay"></div>

											<!-- Calendar modal popup -->
											<div class="ctc_cal_modal hidden" id="ctc_cal_modal">
												<div class="ctc_cal_header">
													<span id="ctc_cal_prev_month" class="ctc_cal_nav_arrow">&lt;</span>
													<h3 id="ctc_cal_month_year" class="ctc_cal_month_title"></h3>
													<span id="ctc_cal_next_month" class="ctc_cal_nav_arrow">&gt;</span>
												</div>

												<div class="ctc_cal_scroll_content">
													<div class="ctc_cal_grid" id="ctc_cal_grid"></div>

													<div class="ctc_fd_time_slot_group" id="ctc_fd_time_slot_group_parent">
														<div id="ctc_fd_time_slot_group_modal" style="<?php echo esc_attr( $fileds_pr_css ); ?>">
															<div id="ctc_fd_time_select" disabled class="ht_ctc_g_form_field" style="<?php echo esc_attr( $filed_input_css ); ?>">
																<!-- Dynamic time slot buttons -->
															</div>
														</div>
													</div>
												</div>

												<div class="ctc_cal_footer">
													<span id="ctc_cal_clear_button" class="ctc_cal_clear_btn">Clear</span>
													<span id="ctc_cal_ok_button" class="ctc_cal_close_btn">Done</span>
												</div>
											</div>
										</div>
									</div>
								<?php } ?>

							</div>

							<?php
						} else {
							?>
							<div class="ctc_form_field <?php echo esc_attr( $id_gen ); ?>" style="<?php echo esc_attr( $fileds_pr_css ); ?>">
								<label style="<?php echo esc_attr( $filed_label_css ); ?>" for="<?php echo esc_attr( $id_gen ); ?>"><?php echo esc_html( $field_name ); ?></label>
								<input type="<?php echo esc_attr( $field_type ); ?>" style="<?php echo esc_attr( $filed_input_css ); ?>" class="ht_ctc_g_form_field <?php echo esc_attr( $add_to_prefilled ); ?>" id="<?php echo esc_attr( $id_gen ); ?>" name="<?php echo esc_attr( $name ); ?>" <?php echo esc_attr( $required ); ?> data-name="<?php echo esc_attr( $field_name ); ?>" style="width:100%;" placeholder="<?php echo esc_attr( $placeholder ); ?>">
							</div>
							<?php
						}
						++$key_gen;
					}

					// is_number_field is y.
					if ( 'y' === $is_number_field ) {

						$z_index = ( isset( $os['zindex'] ) ) ? esc_attr( $os['zindex'] ) : '999999995';
						$z_index = intval( $z_index ) + 1;

						?>
						<style id="greetings_form_number">
							.iti {
								z-index: <?php echo esc_attr( $z_index ); ?>;
							}
							.ctc_number_padding,
							.iti__search-input {
								padding: 9px;
							}
							[dir="rtl"] .iti__dropdown-content {
								left: 0;
								/* right: auto !important; */
							}
						</style>
						<?php
					}

					// is_select_placeholder is y.
					if ( 'y' === $is_select_placeholder ) {
						// add styles, scripts for select field placeholder.
						?>
						<style>
							.ctc_form_select_one,
							.ctc_form_select_default {
								color: gray;
							}
						</style>

						<script>
							if (document.querySelector('.ctc_form_field select')) {
								document.querySelectorAll('.ctc_form_field select').forEach( function (select) {
									if (select.value === "") {
										select.classList.add('ctc_form_select_one');
									}
									select.addEventListener('click', function () {
										select.classList.remove('ctc_form_select_one');
									});
									select.addEventListener('change', function () {
										if (select.value === "") {
											select.classList.add('ctc_form_select_default');
										} else {
											select.classList.remove('ctc_form_select_default');
										}
									});
								});
							}
						</script>
						<?php
					}


					// todo: move this to date.css and only enqueue if date field - 'schedular'. is added.

					// is_date_field is y.
					if ( 'y' === $is_date_field ) {
						?>
						
					<style>
						/* ==== Modal Overlay ==== */
						.ctc_cal_modal_overlay {
							display: none;
							position: fixed;
							inset: 0;
							background: rgba(0, 0, 0, 0.6);
							z-index: 999999997;
						}

						/* ==== Calendar Modal ==== */
						.ctc_cal_modal {
							display: none;
							position: fixed;
							top: 50%;
							left: 50%;
							transform: translate(-50%, -50%);
							background: #fff;
							padding: 20px;
							border-radius: 16px;
							width: 90%;
							max-width: 400px;
							max-height: 80%;
							overflow-y: auto;
							z-index: 999999998;
							box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
							font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
						}

						/* ==== Calendar Header ==== */
						.ctc_cal_header {
							display: flex;
							justify-content: space-between;
							align-items: center;
							margin-bottom: 1rem;
							color: #333;
							font-size: 1.1rem;
							font-weight: 600;
							border-bottom: 1px solid #eee;
							padding-bottom: 10px;
						}

						.ctc_cal_header span {
							background: #f0f0f0;
							font-size: 1.25rem;
							padding: 6px 12px;
							border-radius: 8px;
							cursor: pointer;
							transition: background 0.3s ease;
						}
						.ctc_cal_header span:hover {
							background: #007bff;
							color: #fff;
						}

						/* ==== Calendar Grid ==== */
						.ctc_cal_grid {
							display: grid;
							grid-template-columns: repeat(7, 1fr);
							gap: 6px;
						}

						.ctc_cal_day_header {
							font-weight: bold;
							color: #666;
							font-size: 0.9rem;
							text-align: center;
							padding: 6px;
						}

						.ctc_cal_scroll_content {
							max-height: 400px; /* or whatever value fits your design */
							overflow-y: auto;
							padding-right: 5px;
							position: relative; /* needed for offsetTop calculations */
						}

						.ctc_cal_scroll_content::-webkit-scrollbar {
						width: 8px;               /* vertical scrollbar width */
						}

						.ctc_cal_scroll_content::-webkit-scrollbar-track {
						background: #f0f0f0;      /* light grey background */
						border-radius: 10px;
						}

						.ctc_cal_scroll_content::-webkit-scrollbar-thumb {
						background-color: #888;   /* dark thumb */
						border-radius: 10px;
						border: 2px solid #f0f0f0;
						}

						.ctc_cal_scroll_content::-webkit-scrollbar-thumb:hover {
						background-color: #555;
						}

						/* ==== Day Cells ==== */
						.ctc_cal_day {
							font-size: 0.95rem;
							text-align: center;
							padding: 10px;
							border-radius: 10px;
							cursor: pointer;
							user-select: none;
							transition: background 0.3s ease, color 0.3s ease;
						}
						.ctc_cal_day:hover:not(.disabled) {
							background: #007bff;
							color: #fff;
						}
						.ctc_cal_day.selected {
							background: #0056b3;
							color: #fff;
							font-weight: bold;
						}
						.ctc_cal_day.disabled {
							background: #f5f5f5;
							color: #ccc;
							cursor: not-allowed;
						}
						.ctc_cal_day.past {
							color: #aaa;
						}

						/* ==== Time Slot Group ==== */
						.ctc_fd_time_slot_group {
							margin-top: 1rem;
							padding: 12px;
							border-top: 1px solid #ddd;
							background-color: #f9f9f9;
							border-radius: 10px;
							text-align: center;
							/* max-height: 100px; */
							/* overflow-y: auto; */
						}

						/* Time Select */
						.ctc_fd_time_slot_group select {
							width: 100%;
							padding: 12px;
							font-size: 1rem;
							border: 1px solid #ccc;
							border-radius: 8px;
							background: #fff;
							outline: none;
							transition: border-color 0.3s ease;
						}
						.ctc_fd_time_slot_group select:focus {
							border-color: #007bff;
						}

						/* ==== Time Grid Layout ==== */
						#ctc_fd_time_select {
							display: grid;
							grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
							gap: 10px;
							margin-top: 10px;
						}

						/* Individual Time Slot */
						.ctc_fd_time_slot_box {
							padding: 10px;
							background-color: #fff;
							border: 1px solid #ccc;
							border-radius: 8px;
							text-align: center;
							font-size: 0.95rem;
							cursor: pointer;
							transition: background-color 0.2s, border-color 0.2s;
						}
						.ctc_fd_time_slot_box:hover {
							background-color: #eef6ff;
							border-color: #3399ff;
						}
						.ctc_fd_time_slot_box.selected {
							background-color: #3399ff;
							color: #fff;
							font-weight: bold;
							border-color: #2b7bd9;
						}

						/* ==== Footer Buttons ==== */
						.ctc_cal_footer {
							margin-top: 10px;
							display: flex;
							justify-content: space-between;
							align-items: center;
						}

						#ctc_cal_clear_button,
						#ctc_cal_ok_button {
							padding: 10px 20px;
							font-size: 1rem;
							text-align: center;
							border: none;
							border-radius: 8px;
							cursor: pointer;
							color: #fff;
							transition: background 0.3s ease;
							margin: 0 5px;
						}
						#ctc_cal_clear_button {
							background: #dc3545;
						}
						#ctc_cal_clear_button:hover {
							background: #c82333;
						}
						#ctc_cal_ok_button {
							background: #1f3bb3;
						}
						#ctc_cal_ok_button:hover {
							background: #162d9e;
						}

						/* ==== Media Queries ==== */
						@media (max-width: 600px) {
							.ctc_cal_modal {
								max-width: 95%;
								padding: 16px;
							}

							.ctc_cal_header {
								font-size: 1rem;
							}

							.ctc_cal_day {
								padding: 10px;
							}

							.ctc_fd_time_slot_group select {
								font-size: 0.95rem;
							}

							#ctc_fd_time_select {
								grid-template-columns: repeat(auto-fill, minmax(80px, 1fr));
							}

							#ctc_cal_clear_button,
							#ctc_cal_ok_button {
								font-size: 0.9rem;
								padding: 8px 16px;
								text-align: center;
							}
						}

					</style>

						<?php
					}
				}
				// opt-in field..
				$opt_in = 'Privacy Policy';
				if ( isset( $ht_ctc_greetings ) && isset( $ht_ctc_greetings['is_opt_in'] ) && '' !== $ht_ctc_greetings['is_opt_in'] && isset( $ht_ctc_greetings['opt_in'] ) ) {
					$opt_in = $ht_ctc_greetings['opt_in'];
					?>
					<div class="ctc_form_field ctc_opt_g_form" style="<?php echo esc_attr( $filed_checbox_pr_css ); ?>">
						<input type="checkbox" style="<?php echo esc_attr( $filed_checbox_input_css ); ?>" class="ht_ctc_g_form_field ctc_g_its_checkbox" id="ctc_opt_g_form" data-name="ctc_opt_g_form" name="">
						<label style="<?php echo esc_attr( $filed_checbox_label_css ); ?>" for="ctc_opt_g_form"><?php echo wp_kses_post( $opt_in ); ?></label>
					</div>
					<?php
				}
				?>
				

				<div class="ctc_g_sentbutton" style="<?php echo esc_attr( $send_css ); ?>">
					<div class="ht_ctc_chat_greetings_for_forum_link ctc-analytics">
					<?php
					if ( is_file( $g_cta_path ) ) {
						include $g_cta_path;
					}
					?>
					</div>
					<input hidden class="ht_ctc_chat_greetings_forum_link" type="submit" style="display:none;">
				</div>
			</form> 
		</div>
	</div>
	<?php
	if ( '' !== $ht_ctc_greetings['bottom_content'] ) {
		?>
	<div class="ctc_g_bottom" style="<?php echo esc_attr( $bottom_css ); ?>">
		<?php echo wp_kses_post( wpautop( $ht_ctc_greetings['bottom_content'] ) ); ?>
	</div>
		<?php
	}
	?>
	
</div>
