// Click to Chat - PRO
(function proInit($) {
	
	console.log('pro.dev.js loaded');

	/**
     * todo:
     *  - jquery..
     *  - class names, code optimization..
     */

	// DOM Ready Bootstrapper
	if ( document.readyState === 'loading' ) {
		console.log( 'DOM is still loading, waiting for DOMContentLoaded' );
		document.addEventListener( 'DOMContentLoaded', initClickToChatPro );
	} else {
		console.log( 'DOM is already loaded, calling initClickToChatPro directly' );
		initClickToChatPro();
	}

	// ready
	function initClickToChatPro () {
		console.log( 'Click to Chat PRO initialized' );

		// Selects the chat container element
		// This is used to attach event listeners and manipulate the chat UI
		const ht_ctc_chat = document.querySelector( '.ht-ctc-chat' );

		const url = window.location.href;
		const post_title = document.title || '';

		let ctc = {};
		let ctc_values = {};
		let is_chat_display = ''; // yes to check for next step. if no then dont display chat.
		let for_get_r_sqx = 0;
		let ht_ctc_storage = {};
		let online_content = '';

		var multi = '';

		// maybe later change things..  localization.. etc..
		var day_1 = 'Monday';
		var day_2 = 'Tuesday';
		var day_3 = 'Wednesday';
		var day_4 = 'Thursday';
		var day_5 = 'Friday';
		var day_6 = 'Saturday';
		var day_7 = 'Sunday';

		function getStorageData () {
			console.log( 'pro.js - getStorageData' );
			console.log( ht_ctc_storage );
			if ( localStorage.getItem( 'ht_ctc_storage' ) ) {
				ht_ctc_storage = localStorage.getItem( 'ht_ctc_storage' );
				ht_ctc_storage = JSON.parse( ht_ctc_storage );
				console.log( ht_ctc_storage );
			}
		}
		getStorageData();

		// get items from ht_ctc_storage
		function ctc_getItem ( item ) {
			console.log( 'ctc_getItem' );
			return ( ht_ctc_storage[ item ] ) ? ht_ctc_storage[ item ] : false;
		}

		// set items to ht_ctc_storage storage
		function ctc_setItem ( name, value ) {
			console.log( 'ctc_setItem: name: ' + name + ' value: ' + value );
			console.log( ht_ctc_storage );

			// required if multiple sources/plugins are setting values..
			getStorageData();
			console.log( ht_ctc_storage );
			ht_ctc_storage[ name ] = value;
			console.log( ht_ctc_storage );
			var newValues = JSON.stringify( ht_ctc_storage );
			localStorage.setItem( 'ht_ctc_storage', newValues );
		}

		variable_ctc();

		variable_ctc_values();

		var wptime = time_on_wordpress();

		document.dispatchEvent( new CustomEvent( 'ht_ctc_pro_init', { detail: { ht_ctc_storage, ctc_setItem, ctc_getItem } } ) );

		/**
         * Get ht_ctc_chat_var values and store in `ctc` using pure JavaScript
         */
		function variable_ctc () {
			// Check if global variable exists
			if ( typeof ht_ctc_chat_var !== 'undefined' ) {
				ctc = ht_ctc_chat_var;
			} else {
				console.log( 'ht_ctc_chat_var not defined' );

				try {
					// Find the element with class 'ht_ctc_chat_data'
					var el = document.querySelector( '.ht_ctc_chat_data' );
					if ( el ) {
						// Read the data-settings attribute
						var settings = el.getAttribute( 'data-settings' );
						// Validate JSON before parsing
						// if ( settings && typeof settings === 'string' ) {
							ctc = JSON.parse( settings ); // Parse JSON string to object
						// } else {
						// 	ctc = {};
						// }
					} else {
						ctc = {}; // If element not found
					}
				} catch ( error ) {
					ctc = {}; // If JSON parse or any error occurs
				}

				// Optional: cache it globally if needed
				// window.ht_ctc_chat_var = ctc;
			}
		}

		/**
         * get ht_ctc_variables values
         */
		function variable_ctc_values () {
			console.log( 'variable_ctc_values' );

			if ( typeof ht_ctc_variables !== 'undefined' ) {
				ctc_values = ht_ctc_variables;
			} else {
				console.log( 'ht_ctc_variables not defined' );
				ctc_values = {};

				// main plugin have fallback values.. so might be better to call after.. instead of adding fallback values again here.. one more attempt after 2 seconds..
				setTimeout( () => {
					ctc_values = ( typeof ht_ctc_variables !== 'undefined' ) ? ht_ctc_variables : {};
				}, 2000 );
			}
			console.log( ctc_values );
		}

		/**
         * multi agents..
         * based on time settings
         * next working hour
         *
         */
		function multi_agent () {
			console.log( 'multi_agent()' );
			var agents = document.querySelectorAll( '.ht_ctc_multi_agent' );
			console.log( agents );
			console.log( typeof agents );

			var multi_main = get_var( 'ht_ctc_multi_agent_main' );
			console.log( multi_main );

			var is_time_set = 'yes';

			// CHANGED: .each to forEach and jQuery element to native element
			agents.forEach( function handleAgentEach ( element, i ) {
				console.log( 'i: ' + i );
				console.log( element );

				// todo: if data-key is not set then skip this agent or so..
				var key = element.getAttribute( 'data-key' );
				console.log( key );

				var multi = get_var( key );
				console.log( multi );

				var timeObj = time_on_wordpress();

				// console.log(timeObj);
				var today = timeObj.getDay();
				if ( 0 === today ) {
					today = 7;
				}
				console.log( today );

				// week loop
				var week = [];
				for ( var index = today; index <= 7; index++ ) {
					week.push( index );
				}
				console.log(week);

				if ( 7 !== week.length ) {
					var add_next_week_days = 7 - week.length;
					for ( var nextIndex = 1; nextIndex <= add_next_week_days; nextIndex++ ) {
						week.push( nextIndex );
					}
				}
				console.log(week);

				var is_online = 'yes';

				if ( multi.timings && 'always' === multi.timings ) {
					is_online = 'yes';
					console.log( 'always' );
				} else if ( multi.timings && 'set' === multi.timings ) {
					console.log( 'set' );

					if ( multi.time_sets ) {
						is_online = 'no';
						var time_sets = multi.time_sets;
						console.log( time_sets );

						var current_minute = get_current_minute();
						console.log('current_minute: ' + current_minute );
						var stop_loop = 1;

						time_sets.forEach( function handleTimeSet ( set ) {
							if ( ( set.stm <= current_minute ) && ( current_minute <= set.etm ) && 1 === stop_loop ) {
								// once in the loop is set to online - no need to check other sets
								is_online = 'yes';

								console.log( set.stm );
								console.log( current_minute );
								console.log( set.etm );
								console.log( is_online );

								stop_loop++;
							}
						} );

					} else {
						// offline
						console.log( 'time set not added' );
						is_online = 'no';
						is_time_set = 'no';
					}

				}

				// agent online / offline..
				if ( 'no' === is_online ) {
					console.log( 'is_online: no (offline)' );
					if ( multi_main.agent_offline ) {
						if ( 'chat' === multi_main.agent_offline ) {
							console.log( 'offline - chat' );

							// add as offline and add next available time
							offline( 'chat' );
						} else if ( 'nochat' === multi_main.agent_offline ) {
							console.log( 'offline - nochat' );

							// disable agent. add offline (display agent, next available time)
							offline( 'nochat' );
						} else {
							// hide
							console.log( 'offline - hide' );
							element.remove();
						}
					}
				} else {
					console.log( 'is_online: yes' );
				}

				/**
                 * add 'next available time' to ctc_g_tags and display flex
                 * change opacity img 0.7 text 0.8
                 *
                 * @param {chat or no chat} is_chat
                 */
				function offline ( is_chat ) {
					console.log( element );
					console.log( is_chat );
					console.log( 'function offline' );

					element.style.order = '1';

					// event.find('.ctc_g_agent_image img').css({
					//     'opacity': '0.5',
					//     // 'border': '1px solid #dddddd'
					// });
					// event.find('.ctc_g_agent_content').css({
					//     'opacity': '0.5'
					// });

					var gMultiBox = element.querySelector( '.g_multi_box' );
					if ( gMultiBox ) { gMultiBox.style.opacity = '0.5'; }

					var agentTags = element.querySelector( '.ctc_g_agent_tags' );
					if ( agentTags ) { agentTags.style.color = 'unset'; }

					if ( 'nochat' === is_chat ) {
						element.style.pointerEvents = 'none';
					}

					var next_hour = nextWorkingHour();
					console.log( '--------------' );
					console.log( next_hour );
					console.log( '--------------' );

					if ( 'no' !== is_time_set ) {
						console.log( 'append next time' );
						var nextTimeElem = element.querySelector( '.ctc_g_agent_tags .ctc_agent_next_time' );
						if ( nextTimeElem ) {
							nextTimeElem.insertAdjacentHTML( 'beforeend', next_hour );
							nextTimeElem.style.display = 'flex';
						}
					}

				}

				function nextWorkingHour () {

					var next_online_time = '';

					if ( multi.time_sets ) {
						console.log( multi );
						var current_minute = get_current_minute();
						var timeRanges = multi.time_sets;
						console.log( current_minute );
						console.log( timeRanges );
						console.log( typeof timeRanges );

						var next_online = '';
						var stop_loop = 1;

						timeRanges.forEach( function handleTimeRange ( entry ) {
							console.log( entry );
							console.log( entry.stm );
							console.log( entry.etm );

							// current_minute = 10070;
							if ( current_minute <= entry.stm && 1 === stop_loop ) {
								next_online = entry.stm;
								console.log( next_online );
								stop_loop++;
							}
						} );

						if ( '' === next_online ) {
							console.log( 'next online is in next week' );
							var current_week_minutes_left = 10080 - current_minute;
							console.log( current_week_minutes_left );
							var next_week_start_minute = timeRanges[ 0 ].stm;
							console.log( next_week_start_minute );
							var time_between = current_week_minutes_left + next_week_start_minute;
							console.log( time_between );
						} else {
							console.log( next_online );
							console.log( current_minute );
							var time_between = next_online - current_minute;
							console.log( time_between );
						}

						next_online_time = time_between;

						console.log( next_online_time );

						// if less than 60 then add in minutes..
						if ( next_online_time < 60 ) {
							console.log( 'minutes: ' + next_online_time );
							next_online_time = Math.round( next_online_time );
							console.log( 'minutes: ' + next_online_time );
							var suffix = ( next_online_time < 2 ) ? multi_main.ctc_minute : multi_main.ctc_minutes;
							next_online_time = next_online_time + ' ' + suffix;
							console.log( next_online_time );
						} else {
							// convert in to hours - and add in hours/days
							next_online_time = next_online_time / 60;
							console.log( next_online_time );

							if ( 24 > next_online_time ) {
								// if less than 1 day then show in hours
								console.log( 'hours: ' + next_online_time );
								next_online_time = Math.round( next_online_time );
								console.log( 'hours: ' + next_online_time );
								var suffix = ( next_online_time < 2 ) ? multi_main.ctc_hour : multi_main.ctc_hours;
								next_online_time = next_online_time + ' ' + suffix;
								console.log( next_online_time );
							} else {
								// if more than 1 day then show in days
								console.log( 'days: ' + next_online_time );
								next_online_time = next_online_time / 24;
								console.log( 'days: ' + next_online_time );
								next_online_time = Math.round( next_online_time );
								var suffix = ( next_online_time < 2 ) ? multi_main.ctc_day : multi_main.ctc_days;
								next_online_time = next_online_time + ' ' + suffix;
								console.log( 'days: ' + next_online_time );
							}

						}

					} else {
						console.log( 'no time set' );
					}

					return next_online_time;

				}

			} );

		}

		// todo:l load on condition.. like..
		multi_agent();

		/**
         * variables..
         * ht_ctc_multi_agent_main,
         * like.. ht_ctc_multi_agent_1, ht_ctc_multi_agent_2, ht_ctc_multi_agent_3, ..
         * todo:l move to multi_agent function
         * Retrieves a global variable or its fallback from a data attribute on a DOM element.
         *
         * @param {string} key - The base key name used to access a global variable or find a fallback element.
         * @returns {any} The resolved variable (from `window[key]` or parsed from `data-settings`), or empty string/object as fallback.
         */
		function get_var ( key ) {
			// Log the start of the function with the given key
			console.log( 'fn: get_var: ' + key );

			// Default return value
			var value = '';

			// Construct the fallback DOM class name (e.g., if key = "chat", class becomes "chat_data")
			var data_key = key + '_data';

			// Try to find the corresponding element with class like `.chat_data`
			var dataElem = document.querySelector( '.' + data_key );

			// Check if the variable exists on the global `window` object
			if ( typeof window[ key ] !== 'undefined' ) {
				// If it exists, assign it to v
				value = window[ key ];

				// Log the retrieved value
				console.log( value );
			} else {
				// If not available on `window`, try to get it from the DOM
				try {
					if ( dataElem ) {
						// Get the value of the `data-settings` attribute from the element
						var settings = dataElem.getAttribute( 'data-settings' );

						// Parse the JSON string to a JS object
						value = JSON.parse( settings );

						// Log the parsed object
						console.log( value );
					}
				} catch ( error ) {
					// If anything goes wrong (e.g., invalid JSON), fallback to an empty object
					value = {};
				}
			}

			// Cleanup: remove the element from the DOM to avoid memory leaks or reprocessing
			if ( dataElem ) {
				dataElem.remove();
			}

			// Return the resolved value
			return value;
		}

		// webhook .... global web hook values, global hook url
		var g_hook_v = ( ctc.hook_v ) ? ctc.hook_v : '';
		var g_hook_url = ( ctc.hook_url ) ? ctc.hook_url : '';

		// ht_ctc_settings
		// document.addEventListener('ht_ctc_event_settings', function (event) {
		//     const ctc = event.detail.ctc;

		//     console.log(event.detail.data);      // Logs: { hello: 'world' }
		//     ctc['hi'] = 10;
		//     ctc.test = "helloworld";
		// });

		/**
         * Handles the `ht_ctc_event_number` custom event.
         *
         * Selects a contact number (`ctc.number`) from `ctc.r_nums` using either:
         * - **Sequential mode**: Uses `ctc.r_sqx` as an index, updates it with `update_r_sqx()`, resets to 0 if it exceeds the array length.
         * - **Random mode**: Picks a number randomly if `ctc.r_sqx` is empty or not set.
         *
         * Wrapped in a try-catch for safe error handling.
         *
         * @param {CustomEvent} e - Event containing `ctc` in `e.detail`.
         *
         * @expects `ctc.r_nums` (Array) – List of contact numbers.
         * @optional `ctc.r_sqx` (Number|String) – Sequential index.
         * @modifies `ctc.number`, `ctc.r_sqx`
         */
		document.addEventListener( 'ht_ctc_event_number', function handleEventNumber ( event ) {
			try {
				console.log( 'ht_ctc_event_number' );

				ctc = event.detail.ctc;

				if ( ctc.r_nums && ctc.r_nums[ 0 ] ) {
					console.log( '[ht_ctc_event_number] r_nums:', ctc.r_nums );
					console.log( 'ctc.r_sqx:', ctc.r_sqx );

					// if ctc.r_sqx is not set then it is pure random mode. if set then sequential mode.

					// ctc.r_sqx can be 0. so instead of if ctc.r_sqx check with typeof ctc.r_sqx !== undefined
					if ( 'undefined' !== typeof ctc.r_sqx && '' !== ctc.r_sqx && ! isNaN( ctc.r_sqx ) ) {
						console.log( '[ht_ctc_event_number] Sequential logic' );

						var r_length = ctc.r_nums.length;
						console.log( '[ht_ctc_event_number] r_length:', r_length );

						var r_sqx = ctc.r_sqx;
						console.log( '[ht_ctc_event_number] r_sqx:', r_sqx );

						if ( r_sqx >= r_length ) {
							console.log( '[ht_ctc_event_number] r_sqx exceeded r_length, resetting to 0' );
							r_sqx = 0;
						}

						var selected_num = ctc.r_nums[ r_sqx ];
						console.log( '[ht_ctc_event_number] r_num picked:', selected_num );

						ctc.number = selected_num;

						if ( r_sqx >= r_length ) {
							console.log( 'r_sqx exceeded r_length, resetting to 0' );
							r_sqx = 0;
						}

						ctc.r_sqx = r_sqx;

						r_sqx++; // Increment for next time

						update_r_sqx( r_sqx ); // Send to DB
						console.log( '[ht_ctc_event_number] r_sqx incremented & updated to DB:', r_sqx );
					} else {
						// Pure random logic
						var r_nums = ctc.r_nums;
						console.log( '[ht_ctc_event_number] Pure random mode' );

						var randomIndex = Math.floor( Math.random() * r_nums.length );
						ctc.number = r_nums[ randomIndex ];
						console.log( '[ht_ctc_event_number] Randomly picked r_num:', ctc.number );
					}
				}
			} catch ( err ) {
				console.error( 'Error in ht_ctc_event_number handler:', err );
			}
		} );

		/**
          * Sends the provided `r_sqx` value to the server via AJAX to update in the database.
          *
          * - Includes a nonce (`ctc.nonce`) for security verification.
          * - Logs the result and handles errors gracefully using try-catch.
          * - Updates the local `ctc.r_sqx` value on successful response.
          *
          * @param {number} r_sqx - The sequential index value to be stored in the database.
          */
		function update_r_sqx ( r_sqx ) {
			console.log( 'update_r_sqx()' );

			try {
				console.log( 'Sending update_r_sqx:', r_sqx );

				// Check if ctc.r_sqx is defined and is a number (even 0 is valid)
				if ( 'undefined' !== typeof ctc.r_sqx && ! isNaN( ctc.r_sqx ) ) {

					// Send a POST request using Fetch API
					fetch( ctc.ajaxurl, {
						method: 'POST',

						// Set content type like jQuery does for form data
						headers: {
							'Content-Type': 'application/x-www-form-urlencoded',
						},

						// Prepare the form data using URLSearchParams
						body: new URLSearchParams( {
							action: 'ctc_pro_update_r_sqx',  // WordPress AJAX action
							r_sqx: r_sqx,                     // The new value to update
							nonce: ctc.nonce,                  // Security nonce
						} ),
					} )
						.then( response => response.json() )  // Parse the JSON response
						.then( data => {
							try {
								if ( data.success ) {
									// If server returned success
									console.log( 'update_r_sqx success:', data.data );

									// Update the local ctc.r_sqx value
									ctc.r_sqx = Number( r_sqx );
								} else {
									// If server returned failure (but no crash)
									console.warn( 'update_r_sqx failed:', data.data );
								}
							} catch ( innerErr ) {
								// Catch any error during success handler
								console.error( 'update_r_sqx success handler error:', innerErr );
							}
						} )
						.catch( error => {
							// Catch any network or parsing error
							console.error( 'update_r_sqx AJAX error:', error );
						} );
				}
			} catch ( err ) {
				// Catch any unexpected error outside fetch
				console.error( 'update_r_sqx error:', err );
			}
		}

		/**
         * Retrieves the `r_sqx` value from the server via AJAX (useful for initial page load).
         *
         * - Ensures only one fetch request runs using `for_get_r_sqx`.
         * - Handles valid and failed responses, updating the `ctc.r_sqx` value accordingly.
         * - Uses a nonce for secure communication with the backend.
         */
		function get_r_sqx () {
			try {
				// If ctc.r_sqx is falsy (undefined, null, empty string, or 0), exit early
				if ( ! ctc.r_sqx ) {
					return;
				}

				// Prevent multiple calls: allow only first execution
				if ( 0 !== for_get_r_sqx ) {
					console.log( 'get_r_sqx called:', for_get_r_sqx );
					return;
				}

				// Mark that function has run once
				for_get_r_sqx++;

				// Send POST request using Fetch API
				fetch( ctc.ajaxurl, {
					method: 'POST',

					// Set form data headers
					headers: {
						'Content-Type': 'application/x-www-form-urlencoded',
					},

					// Send required parameters to the server
					body: new URLSearchParams( {
						action: 'ctc_pro_get_r_sqx',  // WordPress AJAX action
						nonce: ctc.nonce,              // Security nonce
					} ),
				} )
					.then( response => response.json() )  // Parse response as JSON
					.then( data => {
						try {
							if ( data.success ) {
								// Server returned success — update ctc.r_sqx
								console.log( 'Fetched r_sqx value:', data.data );
								ctc.r_sqx = data.data;
							} else {
								// Server responded but failed
								console.warn( 'get_r_sqx failed:', data.data );
								ctc.r_sqx = '';
							}
						} catch ( innerErr ) {
							// Error while processing response
							console.error( 'get_r_sqx success handler error:', innerErr );
							ctc.r_sqx = '';
						}
					} )
					.catch( error => {
						// Network or fetch error
						console.error( 'get_r_sqx AJAX error:', error );
						ctc.r_sqx = '';
					} );

			} catch ( err ) {
				// Catch any general JS errors
				console.error( 'get_r_sqx error:', err );
				ctc.r_sqx = '';
			}
		}

		/**
         * Initial call to fetch `r_sqx` from the server on page load.
         * Should be placed after the `get_r_sqx()` function definition.
         */
		get_r_sqx();

		// Attach click handler using event delegation
		if ( ht_ctc_chat ) {
			ht_ctc_chat.addEventListener( 'click', function handleChatClick ( event ) {
				// call to action button.
				const triggerBtn = event.target.closest( '.ht_ctc_chat_greetings_for_forum_link' );

				// Proceed only if the specific trigger button was clicked
				if ( triggerBtn ) {
					console.log( 'ht_ctc_chat_greetings_for_forum_link' );

					// Simulate a click on the actual functional link - the hidden send button
					const actualLink = document.querySelector( '.ht_ctc_chat_greetings_forum_link' );
					if ( actualLink ) {
						// this call the event listener ht_ctc_chat.addEventListener('submit', function (e) {
						actualLink.click();
					}

					// Validate the greetings form
					const form = document.getElementById( 'ctc_pro_greetings_form' );
					if ( form && ! form.checkValidity() ) {
						console.log( 'invalid form..' );

						const checkboxes = form.querySelectorAll( '[type="checkbox"][required]:not(:checked)' );

						checkboxes.forEach( function handleCheckboxEach ( checkbox ) {
							const parentDiv = checkbox.closest( 'div' );
							if ( parentDiv ) {
								// Basic fade-out and fade-in effect using CSS
								parentDiv.style.transition = 'opacity 0.2s';
								parentDiv.style.opacity = '0';

								setTimeout( function handleCheckboxFadeIn () {
									parentDiv.style.opacity = '1';
								}, 100 ); // Short delay
							}
						} );
					}
				}
			} );
		}

		// form - opt-in..
		// optin - checkbox on change
		const optinCheckbox = document.querySelector( '#ctc_opt_g_form' );

		if ( optinCheckbox ) {
			const optinWrapper = document.querySelector( '.ctc_opt_g_form' );

			if ( ctc_getItem( 'g_optin' ) ) {
				optinCheckbox.checked = true;
				if ( optinWrapper ) { optinWrapper.style.display = 'none'; }
			} else {
				optinCheckbox.required = true;
			}

			optinCheckbox.addEventListener( 'change', function handleOptinChange ( event ) {
				if ( event.target.checked ) {
					if ( optinWrapper ) {
						$( optinWrapper )
							.hide( 500 ); // using jQuery animation as per your preference
					}
					ctc_setItem( 'g_optin', 'y' );
				}
			} );
		}

		// if exists.. ht_ctc_g_form_field_hidden then for each.. get the value and replace with apply_variables function and replace the value
		if ( document.querySelector( '.ht_ctc_g_form_field_hidden' ) ) {
			console.log( 'ht_ctc_g_form_field_hidden' );

			var hiddenFields = document.querySelectorAll( '.ht_ctc_g_form_field_hidden' );
			hiddenFields.forEach( function handleHiddenFieldEach ( obj, i ) {
				console.log( i );
				console.log( obj );
				var value = obj.value;
				console.log( value );
				value = apply_variables( value );
				console.log( value );
				obj.value = value;
			} );
		}

		// todo: check - time zone can add here..

		// ht_ctc_chat_greetings_box_link_multi
		// multi agent - greetings link click..
		if ( ht_ctc_chat ) {
			ht_ctc_chat.addEventListener( 'click', function handleMultiAgentClick ( element ) {
				const trigger = element.target.closest( '.ht_ctc_chat_greetings_box_link_multi' );
				if ( ! trigger ) { return; }

				console.log( 'ht_ctc_chat_greetings_box_link_multi' );
				element.preventDefault();

				const optinCheckbox = document.querySelector( '#ctc_opt_multi' );

				if ( optinCheckbox ) {
					if ( optinCheckbox.checked || ctc_getItem( 'g_optin' ) ) {
						console.log( 'checked.........' );
						display_multi_agents();
					} else {
						$( '.ctc_opt_in' )
							.show( 400 )
							.fadeOut( '1' )
							.fadeIn( '1' ); // keep animation
					}

					// Avoid duplicate event binding
					if ( ! optinCheckbox.dataset.listenerAttached ) {
						optinCheckbox.addEventListener( 'change', function handleMultiOptinChange () {
							console.log( 'ctc_opt_multi changed..' );
							if ( this.checked ) {
								$( '.ctc_opt_in' )
									.hide( 100 ); // keep animation
								ctc_setItem( 'g_optin', 'y' );
								setTimeout( function handleDisplayMultiAgentsDelay () {
									display_multi_agents();
								}, 500 );
							}
						} );
						optinCheckbox.dataset.listenerAttached = 'true';
					}
				} else {
					display_multi_agents();
				}

				function display_multi_agents () {
					console.log( 'display_multi_agents' );

					const agentContent = document.querySelector( '.ctc_g_content' );
					const agentStyle = agentContent?.getAttribute( 'data-agentstyle' );
					console.log( agentStyle );

					if ( agentContent ) {
						if ( agentStyle === 'card-1' ) {
							agentContent.style.padding = '4px 0px';
							agentContent.style.backgroundColor = '#f8f8f8';
						} else if ( agentStyle === '7_1' ) {
							agentContent.style.padding = '4px 0px 8px 0px';
						}
					}

					const sentButton = document.querySelector( '.ctc_g_sentbutton' );
					if ( sentButton ) { sentButton.style.display = 'none'; }

					const msgBox = document.querySelector( '.ctc_g_message_box' );
					const msgContainer = document.querySelector( '.ctc_g_heading_for_main_content' );

					if ( msgBox ) {
						if ( agentStyle === 'card-1' ) {
							msgBox.classList.remove( 'ctc_g_message_box' );
							msgBox.style.backgroundColor = '';
							msgBox.style.textAlign = 'inherit';
							msgBox.style.padding = '4px 0px';

							if ( msgContainer ) {
								msgContainer.appendChild( msgBox );
							}
						} else if ( agentStyle === '7_1' ) {
							msgBox.style.backgroundColor = '';
							msgBox.style.textAlign = 'center';
							msgBox.style.padding = '4px 0px';
						}
					}

					// ('.ctc_g_agents').show(500);
					$( '.ctc_g_agents' )
						.slideToggle( 'slow', function handleSlideToggleComplete () {
							console.log( 'slideup done' );
						} );
				}

			} );
		}

		// Multi opt-in initial agents
		function multi_optin_inital_agents () {
			const chatButton = document.querySelector( '.add_ctc_chat' );
			const optinCheckbox = document.querySelector( '#ctc_opt_multi' );

			// If no .add_ctc_chat button found, do nothing
			if ( ! chatButton ) { return; }

			// 1. Already opted in → change class immediately
			if ( ( optinCheckbox && optinCheckbox.checked ) || ctc_getItem( 'g_optin' ) ) {
				console.log( 'already optin - changing class name...' );
				chatButton.classList.add( 'ctc_chat' );
				chatButton.classList.remove( 'add_ctc_chat' );
			}

			// 2. On click of the add_ctc_chat → show opt-in message
			if ( ht_ctc_chat ) {
				ht_ctc_chat.addEventListener( 'click', function handleAddCtcChatClick ( event ) {
					const target = event.target.closest( '.add_ctc_chat' );
					if ( target ) {
						$( '.ctc_opt_in' )
							.show( 400 )
							.fadeOut( '1' )
							.fadeIn( '1' ); // keep animation
					}
				} );
			}

			// 3. On opt-in checkbox change → save & convert class
			if ( optinCheckbox && ! optinCheckbox.dataset.listenerAttached ) {
				optinCheckbox.addEventListener( 'change', function handleMultiOptinInitialChange () {
					console.log( 'ctc_opt_multi changed..' );

					if ( this.checked ) {
						$( '.ctc_opt_in' )
							.hide( 100 ); // keep animation
						ctc_setItem( 'g_optin', 'y' );

						// Change all .add_ctc_chat to .ctc_chat
						document.querySelectorAll( '.add_ctc_chat' )
							.forEach( function handleAddCtcChatEach ( el ) {
								el.classList.add( 'ctc_chat' );
								el.classList.remove( 'add_ctc_chat' );
							} );
					}
				} );
				optinCheckbox.dataset.listenerAttached = 'true';
			}
		}
		multi_optin_inital_agents();

		/**
         * Greetings from. on sent..
         */
		function greetings_form () {

			/**
             * form sent..
             *
             * @var in_one_second: 2500ms - to avoid duplicate form send in one second
             */
			var form_send_count = 1;
			var in_one_second = 'no';

			// form: greetings form submit
			if ( ht_ctc_chat ) {
				// trigger based from - actualLink.click();
				ht_ctc_chat.addEventListener( 'submit', function handleFormSubmit ( event ) {
					const form = event.target.closest('.ctc_pro_greetings_form');
					console.log('greetings form send...........');
					console.log(form);
					
					// event log
					console.log('event:');
					console.log(event);

					if ( ! form ) { return; }

					console.log( 'form send pro...........' );
					console.log( 'form send count: ' + form_send_count );
					console.log( 'in_one_second: ' + in_one_second );

					event.preventDefault();

					if ( in_one_second === 'yes' ) {
						console.log( 'Duplicate form detected. (in_one_second) return...' );
						return;
					}

					throttleFormSend();

					// Handle checkboxes: disable hidden fields next to checked ones
					handleCheckboxes();

					// Gather form data (as key-value array like jQuery's .serializeArray())
					console.log( 'gathering form data...' );
					const formData = [];
					form.querySelectorAll( '.ht_ctc_g_form_field' )
						.forEach( function handleFormFieldEach ( el ) {
							if (!el.name) { return; }
							if (el.classList.contains('ctc_g_hidden_for_checkbox')) { return; }
							if ( ( el.type === 'checkbox' || el.type === 'radio' ) && ! el.checked ) { return; }
							formData.push( { name: el.name, value: el.value } );
						} );

					console.log( 'formData:', formData );

					const existing_pre_filled = ctc.pre_filled;
					console.log( 'existing_pre_filled: ' + existing_pre_filled );

					// Form data attach to ctc.pre_filled
					const form_prefilled = form_data_attach_to_pre_filled();
					console.log( 'form_prefilled: ' + form_prefilled );

					// add to prefix_pre_filled.. for form with multi agent
					ctc.prefix_pre_filled = form_prefilled;

					// if .greetings-pro-3 and .greetings-pro-2 exist then display .greetings-pro-2 else ..
					const greetingsPro1 = document.querySelector( '.greetings-pro-1' );
					const greetingsPro2 = document.querySelector( '.greetings-pro-2' );
					const greetingsPro3 = document.querySelector( '.greetings-pro-3' );
					if ( greetingsPro2 && greetingsPro3 ) {
						console.log( 'display multi agent' );
						greetingsPro2.style.display = 'block';
						greetingsPro1.style.display = 'none';
					} else {
						console.log( 'form general flow' );

						// Add class to trigger simulated click (as done in original)
						// ht_ctc_chat_greetings_forum_link is the hidden input field type submit
						document.querySelectorAll( '.ht_ctc_chat_greetings_forum_link' )
							.forEach( el => {
								el.classList.add( 'ht_ctc_chat_greetings_box_link' );
							} );

						// Trigger the click after short delay
						setTimeout( function handleTriggerClickDelay () {
							document.querySelectorAll( '.ht_ctc_chat_greetings_box_link' )
								.forEach( function handleGreetingsBoxLinkEach ( el ) {
									el.click();
								} );
						}, 20 );

						// Clean up and reset pre-filled value
						setTimeout( function handleCleanupDelay () {
							document.querySelectorAll( '.ht_ctc_chat_greetings_forum_link' )
								.forEach( function handleGreetingsForumLinkEach ( el ) {
									el.classList.remove( 'ht_ctc_chat_greetings_box_link' );
								} );

							console.log( ctc.pre_filled );
							ctc.pre_filled = existing_pre_filled;
							console.log( ctc.pre_filled );
						}, 500 );
					}

					// Send form data to backend(email) or webhook
					sendFormData( formData );

					// Re-enable hidden fields
					reenableHiddenfields();

					// Increase submit counter
					form_send_count++;
				} );
			}

			// throttle form send
			function throttleFormSend () {

				console.log( 'throttleFormSend()' );

				// form started. change to yes. and after 1 second change to no
				in_one_second = 'yes';

				setTimeout( () => {
					in_one_second = 'no';
				}, 2500 );

			}
			function handleCheckboxes () {
				try {
					const checkboxes = document.querySelectorAll('.ctc_g_its_checkbox');
					console.log('handleCheckboxes - found checkboxes:', checkboxes);
					checkboxes.forEach( function handleCheckboxValidation ( checkbox ) {
						if ( checkbox.checked ) {
							const siblings = checkbox.parentElement?.children;
							if ( siblings ) {
								Array.from( siblings )
									.forEach( function handleSiblingEach ( sibling ) {
										if (
											sibling !== checkbox &&
                                        sibling.tagName === 'INPUT' &&
                                        sibling.type === 'hidden'
										) {
											sibling.disabled = true;
											console.log( 'Disabled hidden input:', sibling );
										}
									} );
							}
						}
					} );
				} catch ( error ) {
					console.error( 'handleCheckboxes error:', error );
				}
			}

			// function handleCheckboxes() {
            //     try {
            //         $('.ctc_g_its_checkbox').each(function () {
            //             if ($(this).is(":checked")) {
            //                 $(this).siblings(['type="hidden"']).prop('disabled', true);
            //                 console.log($(this).siblings(['type="hidden"']));
            //             }
            //         });
            //     } catch (e) { }
            // }

			function reenableHiddenfields () {
				// handle checkboxes in form - part-2
				try {
					var hiddenFields = document.querySelectorAll( '.ctc_g_hidden_for_checkbox' );
					hiddenFields.forEach( function handleHiddenFieldReenable ( field ) {
						field.disabled = false;
					} );
				} catch ( error ) { }
			}

			// function reenableHiddenfields() {
            //     // handle checkboxs in form - part-2
            //     try {
            //         $('.ctc_g_hidden_for_checkbox').each(function () {
            //             $(this).prop('disabled', false);
            //         });
            //     } catch (e) { }
            // }

			/**
			 * Send form data to backend (email) or webhook
			 * 
			 * @param {Array} formData - Array of form field objects with name and value
			 */
			function sendFormData ( formData ) {
				console.log( 'sendFormData() - start' );
				console.log( 'formData to send:', formData );
				console.log( 'ctc.ajaxurl:', ctc.ajaxurl );
				console.log( 'ctc.g1_form_email:', ctc.g1_form_email );
				console.log( 'ctc.g1_form_webhook:', ctc.g1_form_webhook );

				// if email address is added..
				if ( ctc.ajaxurl && ctc.g1_form_email ) {
					console.log('sending to email...');
					console.log(formData);
					form_send_email( formData );
				}

				// webhook ....
				if ( ctc.g1_form_webhook ) {
					console.log( 'sending to webhook...' );
					form_webhooks( formData );
				}
			}

			/**
			 * Form data attach to ctc.pre_filled
			 * Collects form fields marked with .ctc_g_field_add_to_prefilled class
			 * and adds them to the prefilled WhatsApp message
			 * 
			 * @returns {string} The updated prefilled message with form data
			 */
			function form_data_attach_to_pre_filled () {
				console.log( 'form_data_attach_to_pre_filled - start' );

				// If no matching form field, exit early
				if ( ! document.querySelector( '.ctc_g_field_add_to_prefilled' ) ) {
					console.log( 'no form field to add to pre-filled' );
					return '';
				}

				let temp_pre_filled = ctc.pre_filled;
				console.log( 'temp_pre_filled: ' );
				console.log( temp_pre_filled );

				// Collect form data from elements inside .ctc_pro_greetings_form
				const form = document.querySelector( '.ctc_pro_greetings_form' );
				const fields = form ? form.querySelectorAll('.ctc_g_field_add_to_prefilled') : [];
				console.log('fields to add to pre-filled: ');
				console.log(fields);

				const prefilled_form = new FormData();
				console.log('Adding fields to prefilled_form:');
				console.log( prefilled_form );

				// issue: here for checkboxes/radios only checked value should be added. but all values are added as 'on' even unchecked.
				fields.forEach(function handlePrefilledFieldEach(field) {
					
					// added solution for checkbox/radio to only add if checked
					if ((field.type === 'checkbox' || field.type === 'radio') && !field.checked) {
						return;
					}

					if ( field.name ) {
						prefilled_form.append( field.name, field.value );
					}
				} );

				console.log( [ ...prefilled_form.entries() ] );

				let pre_fields = '\n';
				for ( const [ name, value ] of prefilled_form.entries() ) {
					const selector = `.ctc_pro_greetings_form [name='${name}']`;
					const element = document.querySelector( selector );
					let data_name = name;

					if ( element && element.hasAttribute( 'data-name' ) ) {
						data_name = element.getAttribute( 'data-name' );
					}

					// Skip empty values
					if ( value !== '' ) {
						pre_fields += `${data_name}: ${value}\n`;
					}
				}

				console.log( pre_fields );

				temp_pre_filled += pre_fields;

				// temp_pre_filled += encodeURIComponent(pre_fields)

				ctc.pre_filled = temp_pre_filled;
				console.log( ctc.pre_filled );

				return temp_pre_filled;
			}

			// form: send_email
			// todo: compatbility browser..
			function form_send_email ( formData ) {
				console.log( 'form_send_email()' );
				console.log( formData );

				// Get the nonce value (no jQuery)
				const nonce = document.querySelector( '.ctc_g_form_keys #ht_ctc_pro_greetings_nonce' )?.value || '';
				console.log( nonce );

				// Build x-www-form-urlencoded payload like jQuery does:
				// form_data[0][name]=...&form_data[0][value]=...&form_data[1][name]=...
				const params = new URLSearchParams();
				params.append( 'action', 'ctc_pro_greetings_form' );
				params.append( 'nonce', nonce );

				formData.forEach( function handleFormDataEach ( item, i ) {
					params.append( `form_data[${i}][name]`, item?.name ?? '' );
					params.append( `form_data[${i}][value]`, item?.value ?? '' );
				} );

				fetch( ctc.ajaxurl, {
					method: 'POST',
					headers: {
						'Content-Type': 'application/x-www-form-urlencoded', // let WP parse like admin-ajax expects
					},
					body: params.toString(),
				} )
					.then( async function handleFormEmailResponse ( res ) {
						const text = await res.text();         // endpoint might return JSON or plain text
						try { return JSON.parse( text ); } catch { return text; }
					} )
					.then( function handleFormEmailSuccess ( response ) {
						console.log( 'form email: success' );
						console.log( response );
					} )
					.catch( function handleFormEmailError ( error ) {
						console.log( 'error' );
						console.error( error );
					} );
			}

			// form: webhooks
			function form_webhooks ( formData ) {
				console.log( 'form_webhooks' );

				var h_url = ctc.g1_form_webhook;
				console.log( 'formData: ' );
				console.log( formData );

				var v_json = {};

				// Form fields (e.g., field-1, field-2, etc.)
				for ( var value of formData.values() ) {
					console.log( value );
					var name = value.name;
					var val = value.value;
					v_json[ name ] = val;
				}

				console.log( 'v_json: ' );
				console.log( v_json );

				console.log( url );
				var decoded_url = ctc_decodeURI( url );
				console.log( decoded_url );

				v_json.ctc_page_url = decoded_url;

				var timeString = time_on_wordpress();
				v_json.ctc_wp_date = timeString.toDateString();
				v_json.ctc_wp_time = timeString.getHours() + ':' + timeString.getMinutes() + ':' + timeString.getSeconds();

				v_json.ctc_page_title = post_title;

				console.log( v_json );
				console.log( typeof v_json );

				var data;
				if ( 'json' === ctc.webhook_format ) {
					console.log( 'form: json' );
					data = v_json;
				} else {
					console.log( 'form: string' );
					data = JSON.stringify( v_json );
				}

				console.log( data );
				console.log( typeof data );
				console.log( h_url );

				fetch( h_url, {
					method: 'POST',
					headers: {
						'Content-Type': ( 'json' === ctc.webhook_format ) ? 'application/json' : 'text/plain',
					},
					body: ( 'json' === ctc.webhook_format ) ? JSON.stringify( data ) : data,
				} )
					.then( function handleWebhookResponse ( response ) {
						console.log( 'form webhook: success' );
						return response.text(); // in case the webhook returns plain text
					} )
					.then( function handleWebhookText ( responseText ) {
						console.log( responseText );
					} )
					.catch( function handleWebhookError ( error ) {
						console.log( 'form webhook error:', error );
					} );
			}

		}
		greetings_form();

		/**
         * ht_ctc_event_hook
         *
         * @var t call time_on_wordpress() to get latest value;
         */
		document.addEventListener( 'ht_ctc_event_hook', function handleEventHook ( event ) {

			console.log( event );

			ctc = event.detail.ctc;
			var number = ( ctc.chat_number && '' !== ctc.chat_number ) ? ctc.chat_number : event.detail.number;

			console.log( ctc );
			console.log( number );

			var timeObj = time_on_wordpress();
			console.log( timeObj );

			// time = day + ' ' + hour + ' ' + minute;
			var time_var = timeObj.toDateString() + ', ' + timeObj.getHours() + ':' + timeObj.getMinutes() + ':' + timeObj.getSeconds();
			console.log( time_var );

			if ( ctc.hook_url ) {

				// var h_url = g_hook_url;
				var h_url = ( ctc.hook_url ) ? ctc.hook_url : '';

				console.log( url );
				var decoded_url = ctc_decodeURI( url );
				console.log( decoded_url );
				h_url = h_url.replace( /\{url}/gi, decoded_url );
				h_url = h_url.replace( /\{time}/gi, time_var );

				h_url = apply_variables( h_url );

				// h_url = h_url.replace(/\{number}/gi, number);
				// h_url = h_url.replace(/\{title}/gi, post_title);

				console.log( h_url );

				// hook values
				if ( ctc.hook_v ) {

					/**
                     * always have to get initial values. if not with out refresh the page is mulitple clicks happened, foreach may not works
                     */
					var hook_values = g_hook_v;

					console.log( hook_values );
					console.log( typeof hook_values );

					var pair_values = {};
					var i = 1;

					hook_values.forEach( function handleHookValue ( hookValue ) {
						console.log( i );
						console.log( hookValue );

						hookValue = hookValue.replace( /\{url}/gi, decoded_url );
						hookValue = hookValue.replace( /\{time}/gi, time_var );

						hookValue = apply_variables( hookValue );

						// hookValue = hookValue.replace(/\{number}/gi, number);
						// hookValue = hookValue.replace(/\{title}/gi, post_title);

						console.log( hookValue );
						pair_values[ 'value' + i ] = hookValue;
						i++;
					} );

					console.log( typeof pair_values );
					console.log( pair_values );

					ctc.hook_url = h_url;
					ctc.hook_v = pair_values;
				}

			}

		} );

		// calls only if ctc.display_user_base is logged_in or logged_out
		function display_user_base ( event ) {
			is_chat_display = 'no';

			ctc = event.detail.ctc;

			var display_user_base = ( ctc.display_user_base ) ? ctc.display_user_base : '';
			console.log( display_user_base );

			var user_login_status = 'logged_out';
			if ( document.querySelector( 'body' ).classList.contains( 'logged-in' ) ) {
				user_login_status = 'logged_in';
			}

			if ( 'logged_in' === display_user_base ) {
				if ( 'logged_in' === user_login_status ) {
					is_chat_display = 'yes';
				} else {
					if ( ctc.ajaxurl ) {

						// todo: migh tbe some issue..  while changing to new logic..  - the commented logic might works fine..

						fetch( ctc.ajaxurl, {
							method: 'POST',
							headers: {
								'Content-Type': 'application/x-www-form-urlencoded',
							},
							body: new URLSearchParams( {
								action: 'ctc_pro_is_user_logged_in',
								nonce: ctc.nonce || ''
							} )
						} )
							.then( response => response.json() )
							.then( response => {
								if ( response.success && response.data === 'yes' ) {
									is_chat_display = 'yes';
								}
							} )
							.catch( error => console.log( 'AJAX error:', error ) );

						// fetch(ctc.ajaxurl + '?action=ctc_pro_is_user_logged_in')
						//     .then(async r => {
						//         const text = await r.text();
						//         try {
						//             const j = JSON.parse(text);
						//             return j && j.data;
						//         } catch {
						//             return text; // plain "yes" / "no"
						//         }
						//     })
						//     .then(val => { if (val === 'yes') is_chat_display = 'yes'; })
						//     .catch(err => console.log('AJAX error:', err));

					}
				}
			} else if ( 'logged_out' === display_user_base && 'logged_out' === user_login_status ) {
				is_chat_display = 'yes';
			}

			return is_chat_display;
		}

		/**
		 * 
		 * @param {*} event 
		 */
		function business_hour ( event ) {

			console.log( 'business_hour' );

			ctc = event.detail.ctc;
			var display_chat = event.detail.display_chat;
			var e_chat = event.detail.ht_ctc_chat;

			console.log( wptime );

			var b_h = '';
			var bh = ctc.bh;
			var day = wptime.getDay();
			var c_h = wptime.getHours();
			var c_m = wptime.getMinutes();
			console.log( day );
			console.log( c_h );
			console.log( c_m );

			// business hours
			if ( 'always' === bh ) {
				// always online
				console.log( 'business hours: always' );
				b_h = 'yes';
			} else if ( 'timebase' === bh ) {
				console.log( 'business hours: timebase' );
				
				var today = wptime.getDay();
				console.log('today: ' + today);
				console.log(typeof today);

				b_h = 'yes';

				if (ctc.bh_time_sets) {
					// new way from v2.14
					console.log('ctc.bh_time_sets: ');
					console.log(ctc.bh_time_sets);
					b_h = 'no';

					var bh_time_sets = ctc.bh_time_sets;

					var current_minute = get_current_minute();
					var stop_loop = 1;

					bh_time_sets.forEach(set => {
						if ((set['stm'] <= current_minute) && (current_minute <= set['etm']) && 1 == stop_loop) {
							// once in the loop is set to online - no need to check other sets
							b_h = 'yes';

							console.log(set['stm']);
							console.log(current_minute);
							console.log(set['etm']);
							console.log(b_h);

							stop_loop++;
						}
					});
					
					
				} else {
					// backward compatibility - can remove later. i.e. bh is timebase but no bh_time_sets found
					console.log('backward compatibility. bh is timebase but no bh_time_sets found');

					if ( 0 === today ) {
						// sunday ( count, day starts with 0, sunday. in admin side settings sunday 7 )
						console.log( 'sunday' );
						today = 7;
					}

					var wpday = 'd' + today;
					console.log( wpday );

					if ( ctc[ wpday ] ) {
						// today is online
						console.log( 'today is online' );

						var st = wpday + '_st';
						var et = wpday + '_et';
						console.log( st );
						console.log( et );

						// if time set - if not set 24 hours online
						if ( ctc[ st ] && ctc[ et ] ) {
							// if start, end time is set
							console.log( 'start and end is set' );

							var st = ctc[ st ];
							var et = ctc[ et ];
							console.log( st );
							console.log( et );

							// hour
							var get_s_h_m = st.split( ':' );
							var get_e_h_m = et.split( ':' );

							var s_h = get_s_h_m[ 0 ];
							var s_m = get_s_h_m[ 1 ];

							var e_h = get_e_h_m[ 0 ];
							var e_m = get_e_h_m[1];

							// padStart to 2 digits (added in v2.14)
							s_h = s_h.padStart(2, "0");
							s_m = s_m.padStart(2, "0");
							e_h = e_h.padStart(2, "0");
							e_m = e_m.padStart(2, "0");
							c_h = String(c_h).padStart(2, "0");
							c_m = String(c_m).padStart(2, "0");

							// hour
							// if ( s_h <= c_h < e_h ) {
							if ( s_h <= c_h && c_h <= e_h ) {
								console.log( 'scheduled hour time' );
								b_h = 'yes';
								
								if ( s_h === c_h ) {
									console.log( 'same hour - start time or end time' );
									if ( s_m > c_m ) {
										// yes if s_m <= c_m (reverse play as early b_h yes is added)
										b_h = 'no';
									}
								} else if ( c_h === e_h ) {
									console.log( 'same hour - end time' );
									if ( c_m > e_m ) {
										b_h = 'no';
									}
								}
							} else {
								// not in business hour range
								console.log( 'not in business hours range' );
								b_h = 'no';
							}

						} else {
							// start time, end time not set so 24 hours online
							console.log( 'week day 24 hours online' );
							b_h = 'yes';
						}

					} else {
						// offline based on week day
						console.log( 'offline based on week day' );
						b_h = 'no';
					}

				}

			}

			// if its business hour
			if ( 'yes' === b_h ) {
				// its online now
				console.log( 'online' );
				time_scroll();
				woo_display_bh();
				online_content_pro();
			} else if ( 'no' === b_h ) {
				// its offline now
				console.log( 'offline' );
				offline();
				offline_content_pro();
			}

			function online_content_pro () {
				console.log('online_content_pro');
				console.log( typeof online_content );
				console.log( online_content );

				if ( typeof online_content !== 'undefined' ) {
					online_content();
				}
			}

			function offline_content_pro () {
				console.log( 'offline_content_pro' );

				const badge = document.querySelector( '.for_greetings_header_image_badge' );
				if ( badge ) {
					if ( ctc.offline_badge_color ) {
						badge.classList.add( 'g_header_badge_online' );

						// Apply background color
						document.querySelectorAll( '.g_header_badge_online' )
							.forEach( el => {
								el.style.backgroundColor = ctc.offline_badge_color;
							} );
					}

					// jQuery animation retained
					$( '.for_greetings_header_image_badge' )
						.show();
				}
			}

			function offline () {
				console.log( 'offline' );

				// call to action text update
				if ( ctc.off_cta ) {
					const ctaElems = document.querySelectorAll( '.ht-ctc-chat .ctc_cta, .ctc_chat.ctc_woo_schedule .ctc_cta' );
					ctaElems.forEach( el => {
						el.textContent = ctc.off_cta;
					} );
				}

				// update number for offline
				if ( ctc.off_num ) {
					ctc.number = ctc.off_num;
					ctc.r_nums = '';
				}

				// Show chat if not hidden
				if ( ! ctc.off_hide ) {
					time_scroll();
					woo_display_bh();
				}
			}

			function time_scroll () {

				console.log( 'time_scroll()' );

				// time delay, page scroll
				if ( '' !== ctc.timedelay || '' !== ctc.scroll ) {

					if ( '' !== ctc.timedelay ) {
						console.log( 'display based on time delay: ' + ctc.timedelay );
						setTimeout( () => {
							display_chat( e_chat );
						}, ctc.timedelay * 1000 );
					}

					if ( '' !== ctc.scroll ) {
						window.addEventListener( 'scroll', event_parse_scroll, false );

						function event_parse_scroll () {
							const htmlElement = document.documentElement;
							const bodyElement = document.body;
							const scrollTop = 'scrollTop';
							const scrollHeight = 'scrollHeight';

							const percent = ( ( htmlElement[ scrollTop ] || bodyElement[ scrollTop ] ) /
								( ( htmlElement[ scrollHeight ] || bodyElement[ scrollHeight ] ) - htmlElement.clientHeight ) ) * 100;

							if ( percent >= ctc.scroll ) {
								console.log( 'display based on scroll' );
								display_chat( e_chat );
								window.removeEventListener( 'scroll', event_parse_scroll );
							}
						}
					}

				} else {
					display_chat( e_chat );
				}
			}

			// woo - display
			function woo_display_bh () {
				const el = document.querySelector( '.ctc_woo_schedule' );

				if ( el ) {
					const dt = el.getAttribute( 'data-dt' );
					console.log( dt );
					el.style.display = dt;
				}
			}

		}

		/**
         *
         * Custom event: ht_ctc_event_display. (if ctc.schedule then only this custom event calls)
         *
         * if ctc.display_user_base - then display chat to logged in/out users
         *      and display_user_base function will handle the call of business_hour
         *
         * business hours - online/offline
         *  most of the things update here and call display_chat(ht_ctc_chat)
         *  with in custom element getting this display_chat(ht_ctc_chat)
         * Display
         *  time delay
         *  scroll
         * Offline
         *  call to action
         *  number
         *  hide or not
         *
         * @var is_chat_display - if is_chat_display is 'no'.. then no need to check later display steps
         */
		console.log( 'ht_ctc_event_display - before addEventListener' );
		document.addEventListener( 'ht_ctc_event_display', function handleEventDisplay ( event ) {

			console.log( 'Custom Event: ht_ctc_event_display' );
			console.log( event );

			console.log( ctc );
			ctc = event.detail.ctc;
			console.log( ctc );
			online_content = event.detail.online_content;

			// is_chat_display
			console.log( 'is_chat_display: ' + is_chat_display );

			// user login status
			if ( ctc.display_user_base ) {
				is_chat_display = display_user_base( event );
				console.log( '@display_user_base - is_chat_display: ' + is_chat_display );
			}

			// based on country code
			if ( 'no' !== is_chat_display ) {

				// if country code is set
				if ( ctc_values.display_countries_list && ctc_values.display_countries_list.length > 0 ) {
					console.log( 'display based on country code' );

					document.dispatchEvent( new CustomEvent( 'ht_ctc_event_display_country_base', { detail: { ctc, ctc_setItem, ctc_getItem } } ) );

					/**
                     *
                     * ht_ctc_variables.country_code (ctc_values.country_code) is set from country.js..
                     * if not set with in the given time, then it like ignore the display based on country code option.
                     */
					var i = 0;
					var country_base_interval = setInterval( function handleCountryBaseInterval () {
						console.log( 'country_base - interval' );
						i++;
						console.log( 'getting country code - interval: ' + i );
						if ( ctc_values.country_code ) {
							console.log( 'country code set - ctc_values.country_code: ' + ctc_values.country_code );
							if ( ctc_values.country_code.length > 0 ) {
								// if country code is set (ctc_values.country_code is set from country.js)
								// another way if(ctc_values.display_countries_list.indexOf(current_country) !== -1)
								if ( ctc_values.display_countries_list.includes( ctc_values.country_code ) ) {
									console.log( 'country code match' );
									is_chat_display = 'yes';
								} else {
									console.log( 'country code not match' );
									is_chat_display = 'no';
								}
							}

							console.log( 'country code set - clear interval' );
							clearInterval( country_base_interval );
							next_after_display_country_base();
						}

						// 8 seconds.. 40 * 200 = 8000
						if ( i > 40 ) {
							console.log( 'country code not set - clear interval' );
							clearInterval( country_base_interval );
							next_after_display_country_base();
						}
					}, 200 );

				} else {
					// if country code is not set
					console.log( 'country code not set' );
					next_after_display_country_base();
				}
			}

			function next_after_display_country_base () {
				console.log( 'fn: next_after_display_country_base()' );
				if ( 'no' !== is_chat_display ) {
					business_hour( event );
				}
			}

		} );

		// ht_ctc_event_after_chat_displayed
		document.addEventListener( 'ht_ctc_event_after_chat_displayed', function handleAfterChatDisplayed ( event ) {

			ctc = event.detail.ctc;
			var greetings_open = event.detail.greetings_open;
			var greetings_close = event.detail.greetings_close;

			console.log( ctc );

			// console.log(ctc);
			console.log( 'ht_ctc_event_after_chat_displayed' );

			// g_no_reopen
			console.log( ht_ctc_storage );

			if ( ctc.g_no_reopen && 'user_closed' === ctc_getItem( 'g_user_action' ) ) {
				// no g - time, scroll actions
			} else {

				if ( ctc.g_time_action ) {
					console.log( 'inside time action' );
					setTimeout( function handleGreetingsTimeAction () {
						greetings_open( 'time_action' );
					}, ctc.g_time_action * 1000 );
				}

				if ( ctc.g_scroll_action ) {
					console.log( 'inside scroll action' );

					window.addEventListener( 'scroll', g_event_parse_scroll, false );

					function g_event_parse_scroll () {
						const htmlElement = document.documentElement;
						const bodyElement = document.body;
						const scrollTopProp = 'scrollTop';
						const scrollHeightProp = 'scrollHeight';

						const percent = (
							( htmlElement[ scrollTopProp ] || bodyElement[ scrollTopProp ] ) /
							( ( htmlElement[ scrollHeightProp ] || bodyElement[ scrollHeightProp ] ) - htmlElement.clientHeight )
						) * 100;

						if ( percent >= ctc.g_scroll_action ) {
							console.log( 'greetings display based on scroll' );
							greetings_open( 'scroll_action' );
							window.removeEventListener( 'scroll', g_event_parse_scroll );
						}
					}
				}

			}

			// greetings container

			// method-1
			if ( document.querySelector( '.ctc_greetings_now' ) && 'IntersectionObserver' in window ) {

				let negativeOffset = ( window.innerHeight / 4 ) * -1;
    			negativeOffset = parseInt( negativeOffset );
    			let rm = negativeOffset + 'px';
    			rm = String( rm );

				// method-2
				// var rm = (window.innerHeight > 900) ? '-300px' : '-150px';

				console.log( rm );

				var observer = new IntersectionObserver( function handleIntersectionObserver ( entries ) {

					console.log( 'observer' );
					console.log( entries );

					entries.forEach( function handleIntersectionEntry ( entry ) {
						console.log( entry );
						if ( ! entry.isIntersecting ) { return; }
						greetings_open( 'now' );
						observer.unobserve( entry.target );
					} );

					console.log( entries );

				}, {
					rootMargin: rm,
				} );

				// start observing
				document.querySelectorAll( '.ctc_greetings_now' )
					.forEach( function handleGreetingsNowEach ( element ) {
						console.log( element );
						observer.observe( element, { subtree: true, childList: true } );
					} );

			}

		} );

		/**
         * Apply dynamic values to placeholders within a given string.
         *
         * Supported syntax:
         * - {number}, {title}, {url}       → plugin-specific values
         * - [[cookie_name]]                → cookie values
         * - [param]                        → URL parameters
         * - (future/optional)
         *     {{localStorageKey}}         → local storage values
         *     **sessionStorageKey**       → session storage values
         */
		function apply_variables ( value ) {
			console.log( 'pro: apply_variables: ' + value );

			const number = ( ctc.chat_number && '' !== ctc.chat_number ) ? ctc.chat_number : ctc.number;

			try {
				// Replace special plugin-defined variables
				value = value.replace( '{number}', number );
				value = value.replace( '{title}', post_title );
				value = value.replace( '{url}', url );

				// Replace [[cookie]] placeholders with cookie values
				let matches = value.match( /\[\[(.*?)\]\]/g );
				if ( matches ) {
					console.log( '[[cookie]] matches: ' + matches );
					matches.forEach( function handleCookieMatch ( match ) {
						const key = match.replace( '[[', '' )
							.replace( ']]', '' );
						value = value.replace( match, getCookie( key ) );
						console.log( `Cookie [${key}] →`, getCookie( key ) );
					} );
				}

				// Replace [param] placeholders with URL parameter values
				matches = value.match( /\[(.*?)\]/g );
				if ( matches ) {
					console.log( '[URL param] matches: ' + matches );
					matches.forEach( function handleUrlParamMatch ( match ) {
						const key = match.replace( '[', '' )
							.replace( ']', '' );
						value = value.replace( match, getParameterByName( key ) );
						console.log( `Param [${key}] →`, getParameterByName( key ) );
					} );
				}

				// // local storage: {{value}}
				// var matches = value.match(/\{\{(.*?)\}\}/g);
				// console.log('{{local storage}} matches: ' + matches);
				// if (matches) {
				//     matches.forEach(e => {
				//         console.log(e);
				//         var key = event.replace('{{', '').replace('}}', '');
				//         value = value.replace(event, 'local storage');
				//         console.log(key);
				//         console.log(value);
				//     }
				//     );
				// }

				// // session storage: *value*
				// var matches = value.match(/\*\*(.*?)\*\*/g);
				// console.log('*session storage* matches: ' + matches);
				// if (matches) {
				//     matches.forEach(event => {
				//         console.log(event);
				//         var key = event.replace('**', '');
				//         console.log(key);
				//         value = value.replace(e, 'session storage');
				//         console.log(value);
				//     }
				//     );
				// }

			} catch ( error ) {
				// Fail silently
			}

			console.log( 'Final Value:', value );
			return value;
		}

		// custom event: ht_ctc_event_apply_variables
		document.addEventListener( 'ht_ctc_event_apply_variables', function handleApplyVariables ( event ) {
			console.log( 'custom event: ht_ctc_event_apply_variables' );

			var variables  = event.detail.variables;

			console.log( variables  );
			variables = apply_variables( variables  );
			console.log( variables  );

			// set value to window as apply_variables_value
			window.apply_variables_value = variables;

		} );

		// Analytics
		document.addEventListener( 'ht_ctc_event_analytics', function handleEventAnalytics ( event ) {
			console.log( 'ht_ctc_analytics - PRO analytics' );

			var num = ( ctc.chat_number && '' !== ctc.chat_number ) ? ctc.chat_number : ctc.number;
			console.log( 'clicked number: ' + num );

			// Google Ads conversion tracking
			if ( ctc.gads_conversation ) {
				console.log( 'gads_conversation: ' + ctc.gads_conversation );

				var data_layer = window.dataLayer;
				console.log( data_layer );
				console.log( typeof data_layer );

				if ( typeof data_layer === 'object' ) {
					if ( typeof gtag === 'undefined' ) {
						console.log( 'gtag not defined, define gtag' );
						window.gtag = function handleGtagFallback () {
							data_layer.push( arguments );
						};
					}

					var sendTo = ctc.gads_conversation;
					console.log( sendTo );

					var gadsParams = { send_to: sendTo };

					if ( ctc_values.g_ads_params ) {
						console.log( 'g_ads_params:', ctc_values.g_ads_params );
						ctc_values.g_ads_params.forEach( paramKey => {
							if ( ctc_values[ paramKey ] ) {
								const googleAdsParamData = ctc_values[ paramKey ];
								const processedKey = apply_variables( googleAdsParamData.key );
								const processedValue = apply_variables( googleAdsParamData.value );
								console.log( processedKey, processedValue );
								gadsParams[ processedKey ] = processedValue;
							}
						} );
					}

					console.log( gadsParams );
					gtag( 'event', 'conversion', gadsParams );
				}
			}

			const nonce = ctc.nonce || '';

			// Facebook Conversion API (CAPI) call
			if ( ctc.fb_conversion ) {
				console.log( 'capi..' );

				// todo: make this in better way. dry code
				// Get event name for FB Pixel or use default
				var pixelEventName = ( ctc.pixel_event_name && '' !== ctc.pixel_event_name ) ? ctc.pixel_event_name : 'Click to Chat by HoliThemes';
				console.log( 'Event Name: ' + pixelEventName );

				// Get pixel track type: track or trackCustom
				var pixelTrack = ( ctc_values.pixel_event_type && '' !== ctc_values.pixel_event_type ) ? ctc_values.pixel_event_type : 'trackCustom';
				console.log( 'Track: ' + pixelTrack );

				var pixelParams = {};
				console.log( typeof pixelParams );

				// Prepare pixel parameters
				if ( ctc_values.pixel_params ) {
					console.log( ctc_values.pixel_params );
					console.log( 'pixel_params' );

					ctc_values.pixel_params.forEach( event => {
						console.log( event );

						if ( ctc_values[ event ] ) {
							const pixelData = ctc_values[ event ];
							console.log( pixelData );

							let pixelKey = pixelData.key;
							let pixelValue = pixelData.value;

							pixelKey = apply_variables( pixelKey );
							pixelValue = apply_variables( pixelValue );

							console.log( pixelKey );
							console.log( pixelValue );

							pixelParams[ pixelKey ] = pixelValue;
						}
					} );
				}
				console.log( pixelParams );

				// pixel event ID
				var event_id = ( ctc.ctc_pixel_event_id && '' !== ctc.ctc_pixel_event_id ) ? ctc.ctc_pixel_event_id : '';
				console.log( 'PRO pixel_event_id: ' + event_id );

				const capiParams = new URLSearchParams( {
						action: 'ctc_pro_capi',
						nonce: nonce,
						pixel_event_name: pixelEventName,
						event_source_url: url,
						event_id: event_id,
						title: post_title,
						number: num,
						pixel_track: pixelTrack,
				});

				capiParams.set( 'pixel_params', JSON.stringify( pixelParams ) );

				fetch( ctc.ajaxurl, {
						method: 'POST',
						headers: {
								'Content-Type': 'application/x-www-form-urlencoded',
						},
						body: capiParams,
				} )
				.then( response => response.json() )
				.then( data => {
					console.log( data );
				} )
				.catch( error => {
					console.error( error );
				} );

			}
		} );

		function others () {
			// Check if the element exists
			const layoutBox = document.querySelector( '.ht_ctc_chat_greetings_box_layout' );
			if ( layoutBox ) {
				layoutBox.style.backgroundColor = 'unset';
			}
		}

		others();

		// getParameterByName
		function getParameterByName ( name ) {
			console.log( 'getParameterByName' );
			var url = window.location.href;
			name = name.replace( /[\]]/g, '\\$&' );

			var regex = new RegExp( '[?&]' + name + '(=([^&#]*)|&|#|$)' );

			// array or null
			var results = regex.exec( url );

			console.log( 'regex: ' + regex );
			console.log( 'results: ' + results );

			// if (!results) return null;
			if ( ! results ) { return ''; }
			if ( ! results[ 2 ] ) { return ''; }
			return decodeURIComponent( results[ 2 ].replace( /\+/g, ' ' ) );
		}


		// todo: have to check and move to new getParameterByName function
		// // getParameterByName
		// function getParameterByName ( name ) {
		// 		if ( ! name ) {
		// 				return '';
		// 		}

		// 		var url = ( document.location && document.location.href ) ? document.location.href : '';
		// 		var safeName = name.replace( /[\]]/g, '\\$&' );
		// 		var regex = new RegExp( '[?&]' + safeName + '(=([^&#]*)|&|#|$)' );
		// 		var results = regex.exec( url );

		// 		if ( ! results || ! results[ 2 ] ) {
		// 				return '';
		// 		}

		// 		var value = results[ 2 ].replace( /\+/g, ' ' );
		// 		try {
		// 				return decodeURIComponent( value );
		// 		} catch ( error ) {
		// 				return value;
		// 		}
		// }

		// get cookie
		function getCookie ( name ) {
			console.log( 'getCookie: ' + name );

			var value = '; ' + document.cookie;
			var parts = value.split( '; ' + name + '=' );

			// for subdomain this may not work. parts.length might be more than 2.. it might not be the correct value for that site.

			if ( parts.length === 2 ) {
				return parts.pop()
					.split( ';' )
					.shift();
			} else {
				return '';
			}
		}

		// time based on wordpress timezone
		function time_on_wordpress () {
			var current_time = new Date();
			var current_time_ms = current_time.getTime();
			var time_offset = current_time.getTimezoneOffset() * 60000;
			var adjustedUtcTime = current_time_ms + time_offset;
			var timezone_raw = ctc.tz || '0'; // default to 0 if not set
			var website_timezone = parseFloat( timezone_raw );
			var website_time = adjustedUtcTime + 3600000 * website_timezone;
			var wp_time = new Date( website_time );
			return wp_time;
		}

		// var wptime = time_on_wordpress();

		function get_current_minute () {

			var weekly_min = '';

			var wp_time = time_on_wordpress();

                        var today = wp_time.getDay();
                        var c_h = wp_time.getHours();
                        var c_m = wp_time.getMinutes();
                        if ( 0 === today ) {
				today = 7;
			}
			console.log( 'today: ' + today );
			console.log( 'hour: ' + c_h );
			console.log( 'minute: ' + c_m );

			var weekly_min = ( ( ( ( today - 1 ) * 24 ) + c_h ) * 60 ) + c_m;

			console.log( 'weekly_min: ' + weekly_min );

			return weekly_min;
		}

		get_current_minute();

		function ctc_decodeURI ( value ) {
			var new_value = value;
			try {
				console.log( 'try' );
				new_value = decodeURI( value );
			} catch ( error ) {
				console.log( 'catch' );

				// new_value = value;
			}

			return new_value;
		}

	}

} )( jQuery );
