<?php
/**
 * Software license
 *
 * Thing to change
 *
 * sl.php
 *  HT_CTC_PRO_SL_STORE_URL
 *  HT_CTC_PRO_SL_ITEM_ID
 *  HT_CTC_PRO_SL_ITEM_NAME
 *  HT_CTC_PRO_LICENSE_PAGE
 *
 *  ht_ctc_pro_license_key
 *
 *  class-ht-ctc-pro-admin-sl.php - admin license settings
 *  HT_CTC_PRO_Updater - class name, included file
 *
 * @package Click_To_Chat_Pro
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'HT_CTC_PRO_SL' ) ) :

	/**
	 * HT_CTC_PRO_SL Class.
	 */
	class HT_CTC_PRO_SL {

		/**
		 * Constructor.
		 */
		public function __construct() {
			$this->define_constants();
			$this->hooks();
		}

		/**
		 * Define Constants
		 */
		private function define_constants() {

			$this->define( 'HT_CTC_PRO_SL_STORE_URL', 'https://holithemes.com/shop/' );
			$this->define( 'HT_CTC_PRO_SL_ITEM_ID', 5502 );
			$this->define( 'HT_CTC_PRO_SL_ITEM_NAME', 'Click to Chat PRO' );
			$this->define( 'HT_CTC_PRO_LICENSE_PAGE', 'click-to-chat' );
		}

		/**
		 * Define constant if not already set.
		 *
		 * @uses this->define_constants
		 * @param string $name Constant name.
		 * @param mixed  $value Constant value.
		 */
		public function define( $name, $value ) {
			if ( ! defined( $name ) ) {
				define( $name, $value );
			}
		}

		/**
		 * Setup hooks.
		 */
		public function hooks() {
			add_action( 'init', array( $this, 'plugin_updater' ) );

			// include_once HT_CTC_PRO_PLUGIN_DIR . 'inc/tools/sl/class-ht-ctc-pro-admin-sl.php';
			add_action(
				'ht_ctc_ah_admin_includes',
				function () {
					// software license - using ajax way (calls only in click to chat admin settings pages)
					include_once HT_CTC_PRO_PLUGIN_DIR . 'inc/tools/sl/class-ht-ctc-pro-admin-sl.php';
				}
			);
		}



		/**
		 * Plugin updater.
		 */
		public function plugin_updater() {

			$doing_cron = defined( 'DOING_CRON' ) && DOING_CRON;
			if ( ! current_user_can( 'manage_options' ) && ! $doing_cron ) {
				return;
			}

			if ( ! class_exists( 'HT_CTC_PRO_Updater' ) ) {
				include_once HT_CTC_PRO_PLUGIN_DIR . 'inc/tools/sl/class-ht-ctc-pro-updater.php';
			}

			$license_key = trim( get_option( 'ht_ctc_pro_license_key' ) );

			// setup the updater
			if ( false !== $license_key ) {
				$updater = new HT_CTC_PRO_Updater(
					HT_CTC_PRO_SL_STORE_URL,
					HT_CTC_PRO_PLUGIN_FILE,
					array(
						'version'   => HT_CTC_PRO_VERSION,             // current version number
						'license'   => $license_key,                     // license key
						'item_id'   => HT_CTC_PRO_SL_ITEM_ID,  // ID of the product
						'item_name' => rawurlencode( HT_CTC_PRO_SL_ITEM_NAME ),
						'author'    => 'HoliThemes',                     // author of this plugin
						'beta'      => false,
					)
				);
			}
		}
	}

	new HT_CTC_PRO_SL();

endif; // END class_exists check
