<?php
/**
 * Software licence fields
 *   activate, deactivate ..
 *  doing in ajax way
 *
 * @included sl.php
 * @only: this calls only in Click-to-Chat admin settings pages only
 * @package Click_To_Chat_Pro
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'HT_CTC_PRO_Admin_SL' ) ) :

	/**
	 * HT_CTC_PRO_Admin_SL Class.
	 */
	class HT_CTC_PRO_Admin_SL {

		/**
		 * Constructor.
		 */
		public function __construct() {
			$this->hooks();
		}

		/**
		 * Hooks.
		 */
		public function hooks() {

			// software licence box
			add_action( 'ht_ctc_ah_admin_sidebar_contact', array( $this, 'license_field' ) );

			// ajax ..
			add_action( 'wp_ajax_ctc_pro_activate_license', array( $this, 'activate_license' ) );
			add_action( 'wp_ajax_ctc_pro_deactivate_license', array( $this, 'deactivate_license' ) );
			// add_action( 'wp_ajax_nopriv_ctc_pro_activate_license', [$this, 'activate_license'] );
		}

		/**
		 * License field.
		 */
		public function license_field() {

			$license_key    = get_option( 'ht_ctc_pro_license_key' );
			$license_status = get_option( 'ht_ctc_pro_license_status' );

			$key      = ( false !== $license_key ) ? esc_attr( $license_key ) : '';
			$status   = ( false !== $license_status ) ? esc_attr( $license_status ) : '';
			$li_class = 'active';

			$home_url = home_url();

			$key_styles             = '';
			$after_activated_styles = '';
			$getlicense_class       = '';
			$btn_class              = 'ctc_pro_activate_btn';
			if ( 'valid' === $status ) {
				$text             = __( 'Deactivate License', 'click-to-chat-pro' );
				$key_styles       = 'display: none;';
				$btn_class        = 'ctc_pro_deactivate_btn';
				$getlicense_class = 'ctc_init_display_none';
				$li_class         = '';
			} else {
				$text                   = __( 'Activate License', 'click-to-chat-pro' );
				$btn_class              = 'ctc_pro_activate_btn';
				$after_activated_styles = 'display: none;';
			}
			?>

		<div class="col s12 m8 l12 xl12">
			<div class="row">
				<ul class="collapsible popout">
						<li class="<?php echo esc_attr( $li_class ); ?>">
							<div class="collapsible-header"><?php esc_html_e( 'Click to Chat Pro - Software License', 'click-to-chat-pro' ); ?>
							<span class="right_icon dashicons dashicons-arrow-down-alt2"></span>
						</div>
						<div class="collapsible-body">
							<form action="" method="post">
								<p class="description ctc_pro_license_message" style="display:none; margin-bottom: 5px;"></p>

									<input type="text" required id="ctc_pro_license_key" name="ht_ctc_pro_license_key" value="<?php echo esc_attr( $key ); ?>" style="<?php echo esc_attr( $key_styles ); ?>" placeholder="License Key" >
									<input type="text" id="ctc_pro_activated" value="Activated" style="color: green; <?php echo esc_attr( $after_activated_styles ); ?>" readonly >

								<?php wp_nonce_field( 'ht_ctc_pro_nonce', 'ht_ctc_pro_nonce' ); ?>

									<input type="submit" name="<?php echo esc_attr( $btn_class ); ?>" id="ctc_pro_license_button" class="<?php echo esc_attr( $btn_class ); ?> button-secondary" value="<?php echo esc_attr( $text ); ?>"/>

									<p class="ctc_get_license <?php echo esc_attr( $getlicense_class ); ?>">
										<a href="https://holithemes.com/plugins/click-to-chat/pricing" target="_blank"><?php esc_html_e( 'Get License', 'click-to-chat-pro' ); ?></a> | <a href="https://holithemes.com/shop/" target="_blank"><?php esc_html_e( 'My Account', 'click-to-chat-pro' ); ?></a>
								</p>
							</form>
						</div>
					</li>
				</ul>
			</div>
		</div>
			<?php
		}



		/**
		 * Activate license.
		 */
		public function activate_license() {

			check_ajax_referer( 'ht_ctc_pro_nonce', 'ht_ctc_pro_nonce' );

			$key = ( isset( $_POST['key'] ) && ! empty( $_POST['key'] ) ) ? sanitize_text_field( wp_unslash( $_POST['key'] ) ) : '';

			$license = trim( $key );
			$license = esc_attr( $key );

			$home_url = home_url();

			update_option( 'ht_ctc_pro_license_key', $license );

			// // add site url - useful if user changed the domain name and to deactivate.
			// update_option( 'ht_ctc_pro_license_site', $home_url);

			$api_params = array(
				'edd_action' => 'activate_license',
				'license'    => $license,
				'item_id'    => HT_CTC_PRO_SL_ITEM_ID, // this is better then adding name
				'item_name'  => rawurlencode( HT_CTC_PRO_SL_ITEM_NAME ), // the name of our product
				'url'        => $home_url,
			);

			// Call the custom API.
			$response = wp_remote_post(
				HT_CTC_PRO_SL_STORE_URL,
				array(
					'timeout'   => 45,
					'sslverify' => false,
					'body'      => $api_params,
				)
			);

			// make sure the response came back okay
			if ( is_wp_error( $response ) || 200 !== wp_remote_retrieve_response_code( $response ) ) {

				if ( is_wp_error( $response ) ) {
					$message = $response->get_error_message();
				} else {
					$message = __( 'An error occurred, please try again. (not 200)', 'click-to-chat-pro' );
				}
			} else {

				$license_data = json_decode( wp_remote_retrieve_body( $response ) );

				if ( false === $license_data->success ) {

					switch ( $license_data->error ) {

						case 'expired':
							$message = sprintf(
								/* translators: %s: License expiration date. */
								__( 'Your license key expired on %s.', 'click-to-chat-pro' ),
								date_i18n( get_option( 'date_format' ), strtotime( $license_data->expires, time() ) )
							);
							break;

						case 'disabled':
						case 'revoked':
							$message = __( 'Your license key has been disabled.', 'click-to-chat-pro' );
							break;

						case 'missing':
							$message = __( 'Invalid license.', 'click-to-chat-pro' );
							break;

						case 'invalid':
						case 'site_inactive':
							$message = __( 'Your license is not active for this URL.', 'click-to-chat-pro' );
							break;

						case 'item_name_mismatch':
							/* translators: %s: Product ID. */
							$message = sprintf( __( 'This appears to be an invalid license key for %s.', 'click-to-chat-pro' ), HT_CTC_PRO_SL_ITEM_ID );
							break;

						case 'no_activations_left':
							$message = __( 'Your license key has reached its activation limit.', 'click-to-chat-pro' );
							break;

						default:
							$message = __( 'An error occurred, please try again. (default) 1. might be another product license key', 'click-to-chat-pro' );
							break;
					}
				}
			}

			// $license_data->license will be either "valid" or "invalid"
			update_option( 'ht_ctc_pro_license_status', $license_data->license );

			if ( empty( $message ) ) {
				$message = __( 'Activated', 'click-to-chat-pro' );
			}

			$r = array(
				'message'        => $message,
				'store_response' => $response,
			);

			$this->call_plugin_data( 'Activating License' );

			if ( 'activated' === $message ) {
				wp_send_json_success( $r );
			} else {
				wp_send_json_error( $r );
			}

			// Ends early - this wont runs
			wp_send_json_success( $message );
			wp_die();
		}


		/**
		 * Call plugin data.
		 *
		 * @param string $call_back Callback type.
		 */
		public function call_plugin_data( $call_back = 'Activating License' ) {
			if ( class_exists( 'HT_CTC_PRO_Register' ) ) {
				HT_CTC_PRO_Register::plugin_data( $call_back );
			}
		}




		/**
		 * Deactivate license.
		 */
		public function deactivate_license() {

			check_ajax_referer( 'ht_ctc_pro_nonce', 'ht_ctc_pro_nonce' );

			// retrieve the license from the database
			$license = trim( get_option( 'ht_ctc_pro_license_key' ) );

			$home_url = home_url();

			// // if home_url and saved url is not same.. (i.e. if domain changed..)
			// $ht_ctc_pro_license_site = get_option( 'ht_ctc_pro_license_key' );
			// if ( '' !== $ht_ctc_pro_license_site && $home_url !== $ht_ctc_pro_license_site ) {
			// $home_url = $ht_ctc_pro_license_site;
			// update_option( 'ht_ctc_pro_license_site', $home_url);
			// }

			$api_params = array(
				'edd_action' => 'deactivate_license',
				'license'    => $license,
				'item_id'    => HT_CTC_PRO_SL_ITEM_ID, // this is better then adding name
				'item_name'  => rawurlencode( HT_CTC_PRO_SL_ITEM_NAME ), // the name of our product
				'url'        => $home_url,
			);
			// Send the remote request
			$response = wp_remote_post(
				HT_CTC_PRO_SL_STORE_URL,
				array(
					'body'      => $api_params,
					'timeout'   => 45,
					'sslverify' => false,
				)
			);

			// make sure the response came back okay
			if ( is_wp_error( $response ) || 200 !== wp_remote_retrieve_response_code( $response ) ) {

				if ( is_wp_error( $response ) ) {
					$message = $response->get_error_message();
				} else {
					$message = __( 'An error occurred, please try again. (not 200)', 'click-to-chat-pro' );
				}
			} else {

				$license_data = json_decode( wp_remote_retrieve_body( $response ) );

				if ( false === $license_data->success ) {

					switch ( $license_data->error ) {

						case 'expired':
							$message = sprintf(
								/* translators: %s: License expiration date. */
								__( 'Your license key expired on %s.', 'click-to-chat-pro' ),
								date_i18n( get_option( 'date_format' ), strtotime( $license_data->expires, time() ) )
							);
							break;

						case 'disabled':
						case 'revoked':
							$message = __( 'Your license key has been disabled.', 'click-to-chat-pro' );
							break;

						case 'missing':
							$message = __( 'Invalid license.', 'click-to-chat-pro' );
							break;

						case 'invalid':
						case 'site_inactive':
							$message = __( 'Your license is not active for this URL.', 'click-to-chat-pro' );
							break;

						case 'item_name_mismatch':
							/* translators: %s: Product ID. */
							$message = sprintf( __( 'This appears to be an invalid license key for %s.', 'click-to-chat-pro' ), HT_CTC_PRO_SL_ITEM_ID );
							break;

						case 'no_activations_left':
							$message = __( 'Your license key has reached its activation limit.', 'click-to-chat-pro' );
							break;

						default:
							$message = __( 'An error occurred, please try again. (default) 1. might be another product license key', 'click-to-chat-pro' );
							break;
					}
				}
			}

			// $license_data->license will be either "valid" or "invalid"
			update_option( 'ht_ctc_pro_license_status', $license_data->license );
			// exit();

			if ( empty( $message ) ) {
				$message = __( 'Deactivated', 'click-to-chat-pro' );
			}

			$r = array(
				'message'        => $message,
				'store_response' => $response,
			);

			$this->call_plugin_data( 'Deactivating License' );

			if ( 'deactivated' === $message ) {
				wp_send_json_success( $r );
			} else {
				wp_send_json_error( $r );
			}

			// Ends early - this wont runs
			wp_send_json_success( $message );
			wp_die();
		}
	}

	new HT_CTC_PRO_Admin_SL();

endif; // END class_exists check
