<?php
/**
 * When plugin upgrades
 *
 * Update the db values to compatibile with in versions
 *
 * @package Click_To_Chat_Pro
 * @since 2.14
 * @from ht-ctc-pro-db.php -> db()
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'HT_CTC_PRO_Update_DB' ) ) {

	/**
	 * Handles database migrations on plugin updates.
	 */
	class HT_CTC_PRO_Update_DB {


		/**
		 * Initialize update routine.
		 *
		 * @return void
		 */
		public function __construct() {
			$this->updatedb();
		}


		/**
		 * Update db - First
		 */
		public function updatedb() {

			$ht_ctc_pro_plugin_details = get_option( 'ht_ctc_pro_plugin_details', array() );

			// only if already installed.
			if ( isset( $ht_ctc_pro_plugin_details['version'] ) ) {

				/**
				 * V2.14: if not yet updated to v3.31 or above
				 */
				if ( ! isset( $ht_ctc_pro_plugin_details['v2_14'] ) ) {
					$this->v2_14_update();
				}
			}
		}


		/**
		 * Database updates..
		 */






		/**
		 * V2.14 Update
		 *
		 * Update business hours settings.
		 * in v2.14 added multiple time slots for business hours.
		 * update ht_ctc_chat_options options
		 * if monday_st is set then add monday_times[set_1][st] and monday_et is set then add monday_times[set_1][et]
		 * similarly for other days.
		 * If {day}_st is set then add {day}_times[set_1][st]
		 * and if {day}_et is set then add {day}_times[set_1][et].
		 */
		private function v2_14_update() {

			$ht_ctc_chat_options = get_option( 'ht_ctc_chat_options', array() );

			// if not array or empty then return.
			if ( ! is_array( $ht_ctc_chat_options ) || empty( $ht_ctc_chat_options ) ) {
				return;
			}

			$days = array(
				'monday',
				'tuesday',
				'wednesday',
				'thursday',
				'friday',
				'saturday',
				'sunday',
			);

			$new_data = array(); // hold new structure data

			foreach ( $days as $day ) {
				$st_key    = "{$day}_st";
				$et_key    = "{$day}_et";
				$times_key = "{$day}_times";

				if ( isset( $ht_ctc_chat_options[ $st_key ] ) ) {
					$new_data[ $times_key ]['set_1']['st'] = $ht_ctc_chat_options[ $st_key ];
					// unset( $ht_ctc_chat_options[ $st_key ] );
				}

				if ( isset( $ht_ctc_chat_options[ $et_key ] ) ) {
					$new_data[ $times_key ]['set_1']['et'] = $ht_ctc_chat_options[ $et_key ];
					// unset( $ht_ctc_chat_options[ $et_key ] );
				}
			}

			// before merge make sure both are arrays.
			if ( ! is_array( $new_data ) ) {
				$new_data = array();
			}
			if ( ! is_array( $ht_ctc_chat_options ) ) {
				$ht_ctc_chat_options = array();
			}
			// Merge new values with existing ones — preserves existing settings
			$update_data = array_merge( $new_data, $ht_ctc_chat_options );

			update_option( 'ht_ctc_chat_options', $update_data );
		}
	}

	new HT_CTC_PRO_Update_DB();

} // END class_exists check
