<?php
/**
 * Activate
 * deactivate (no custom post types or so.. to flush rewrite rules)
 * uninstall ( delete if set )
 *
 * @package ctc
 * @subpackage pro
 * @since 3.3
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'HT_CTC_PRO_Register' ) ) :

	/**
	 * HT_CTC_PRO_Register Class.
	 */
	class HT_CTC_PRO_Register {

		/**
		 * When plugin activate, version changed (called from this version_check function)
		 *
		 * @param string $call_back Callback type.
		 */
		public static function activate( $call_back = 'activate' ) {

			if ( version_compare( get_bloginfo( 'version' ), '3.1.0', '<' ) ) {
				wp_die( 'please update WordPress' );
			}

			// add default values to options db
			include_once HT_CTC_PRO_PLUGIN_DIR . '/inc/class-ht-ctc-pro-db.php';

			if ( isset( $call_back ) && ! empty( $call_back ) ) {
				self::plugin_data( $call_back );
			} else {
				self::plugin_data( 'Activate' );
			}
		}

		/**
		 * When plugin deactivate.
		 */
		public static function deactivate() {

			self::plugin_data( 'deactivate' );
		}

		/**
		 * When plugin uninstall.
		 */
		public static function uninstall() {

			self::plugin_data( 'uninstall' );

			// clear cache
			if ( function_exists( 'wp_cache_flush' ) ) {
				wp_cache_flush();
			}
		}

		/**
		 * For plugin updates - run on plugins_loaded.
		 */
		public static function version_check() {

			$ht_ctc_pro_plugin_details = get_option( 'ht_ctc_pro_plugin_details' );

			if ( ! isset( $ht_ctc_pro_plugin_details['version'] ) || HT_CTC_PRO_VERSION !== $ht_ctc_pro_plugin_details['version'] ) {
				// to update the plugin - just like activate plugin
				self::activate( 'version change' );
			}
		}

		/**
		 * Add settings page links in plugins page - at plugin.
		 *
		 * @param array $links Plugin action links.
		 * @return array
		 */
		public static function plugin_action_links( $links ) {
			$new_links = array(
				'settings' => '<a href="' . admin_url( 'admin.php?page=click-to-chat' ) . '">' . __( 'Settings', 'click-to-chat-pro' ) . '</a>',
			);

			return array_merge( $new_links, $links );
		}


		/**
		 * Plugin data collection.
		 *
		 * @param string $call_back Callback type.
		 */
		public static function plugin_data( $call_back = '' ) {

			try {
				$call_back = sanitize_text_field( $call_back );

				$license_key               = get_option( 'ht_ctc_pro_license_key', '' );
				$license_status            = get_option( 'ht_ctc_pro_license_status', '' );
				$ht_ctc_plugin_details     = get_option( 'ht_ctc_plugin_details', array() );
				$ht_ctc_pro_plugin_details = get_option( 'ht_ctc_pro_plugin_details', array() );

				$license_key_clean    = ( ! empty( $license_key ) ) ? esc_attr( $license_key ) : '';
				$license_status_clean = ( ! empty( $license_status ) ) ? esc_attr( $license_status ) : '';

				$server_name = ( ! empty( $_SERVER['SERVER_NAME'] ) ) ? sanitize_text_field( wp_unslash( $_SERVER['SERVER_NAME'] ) ) : '';
				$http_host   = ( ! empty( $_SERVER['HTTP_HOST'] ) ) ? sanitize_text_field( wp_unslash( $_SERVER['HTTP_HOST'] ) ) : '';

				$ctc_pro_version       = ( defined( 'HT_CTC_PRO_VERSION' ) ) ? HT_CTC_PRO_VERSION : '';
				$ctc_pro_first_version = ( ! empty( $ht_ctc_pro_plugin_details['first_version'] ) ) ? esc_attr( $ht_ctc_pro_plugin_details['first_version'] ) : '';
				$ctc_pro_first_time    = ( ! empty( $ht_ctc_pro_plugin_details['first_install_time'] ) ) ? esc_attr( $ht_ctc_pro_plugin_details['first_install_time'] ) : '';

				$ctc_version       = ( defined( 'HT_CTC_VERSION' ) ) ? HT_CTC_VERSION : 1;
				$ctc_first_version = ( ! empty( $ht_ctc_plugin_details['first_version'] ) ) ? esc_attr( $ht_ctc_plugin_details['first_version'] ) : 1;
				$ctc_first_time    = ( ! empty( $ht_ctc_plugin_details['first_install_time'] ) ) ? esc_attr( $ht_ctc_plugin_details['first_install_time'] ) : '';

				$ctc_data = array(
					'SERVER_NAME'           => $server_name,
					'callBack'              => $call_back,
					'Version'               => $ctc_pro_version,
					'HTTP_HOST'             => $http_host,
					'License_Key'           => $license_key_clean,
					'License_Status'        => $license_status_clean,
					'ctc_version'           => $ctc_version,
					'ctc_first_version'     => $ctc_first_version,
					'ctc_first_time'        => $ctc_first_time,
					'ctc_pro_first_version' => $ctc_pro_first_version,
					'ctc_pro_first_time'    => $ctc_pro_first_time,
				);

				$request_args = array(
					'timeout'  => 15,
					'blocking' => false,  // no wait. or change to true for waiting
					'headers'  => array(
						'Content-Type' => 'application/json',
						'User-Agent'   => 'HT-CTC-Pro-Plugin/' . HT_CTC_PRO_VERSION,
					),
					'body'     => wp_json_encode(
						array(
							'ctc_data' => $ctc_data,
						)
					),
				);

				// $url = "https://holithemes.com/shop/";
				$url = 'https://holithemes.com/wp-json/ht-code/v1/ctc-data';

				wp_remote_post( $url, $request_args );
				// no response handling here, as we are not waiting for the response
			} catch ( Exception $e ) {
				// Swallow the exception because we don't depend on the response.
			}
		}
	}

endif; // END class_exists check
