<?php
/**
 * Default values.
 *
 * Set the default values which store in the database options table.
 *
 * @package ctc
 * @since 2.0
 * @from ht-ccw-register.php
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'HT_CTC_PRO_DB' ) ) :

		/**
		 * Handles default database values for the plugin.
		 */
	class HT_CTC_PRO_DB {

			/**
			 * Constructor.
			 */
		public function __construct() {
				$this->db();
		}

			/**
			 * Update the database based on conditions.
			 */
		public function db() {

			$ht_ctc_pro_plugin_details = get_option( 'ht_ctc_pro_plugin_details', array() );

			// if already installed the plugin. then call db updater.
			if ( isset( $ht_ctc_pro_plugin_details['version'] ) ) {
				// call db updater class. @since v2.14
				include_once HT_CTC_PRO_PLUGIN_DIR . '/inc/class-ht-ctc-pro-update-db.php';
			}

			$this->ht_ctc_pro_plugin_details();
		}

			/**
			 * Update plugin details in the database.
			 *
			 * Don't preserve already existing values; always use
			 * update_option to override with new values.
			 *
			 * Adds plugin details and version to the database, useful
			 * when updating the plugin.
			 *
			 * Example version format: v3_1 for version 3.1.
			 * First install time stored since v1.4.
			 */
		public function ht_ctc_pro_plugin_details() {

				$time = time();

				// plugin details
				$values = array(
					'version'            => HT_CTC_PRO_VERSION,
					'first_version'      => HT_CTC_PRO_VERSION,
					'first_install_time' => $time,
					'v1_2'               => $time,
					'v1_4'               => $time,
					'v2_5'               => $time,
					'v2_14'              => $time,
				);

				$db_values = get_option( 'ht_ctc_pro_plugin_details', array() );

				// extra safe instead of directly merge.
				$update_values = $values;
				if ( is_array( $db_values ) ) {
					$update_values = array_merge( $values, $db_values );
				}

				/**
				 * IMP: have to update version number..
				 * (always use the latest value)
				 */
				$update_values['version'] = HT_CTC_PRO_VERSION;

				update_option( 'ht_ctc_pro_plugin_details', $update_values );
		}
	}

	new HT_CTC_PRO_DB();

endif; // END class_exists check
