<?php
/**
 * ** Template/component **
 *
 * Greetings dialog PRO - 2 - settings.. Multi Agent
 *
 * @package Click_To_Chat_Pro
 * @subpackage PRO Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$safe_fallback_values = array();
if ( isset( $fallback_values ) ) {
	$safe_fallback_values = $fallback_values;
}

$gtm_offset = esc_attr( get_option( 'gmt_offset' ) );

$g2_pro_options = get_option( 'ht_ctc_greetings_pro_2', $safe_fallback_values );

$agents = ( isset( $g2_pro_options['agents'] ) ) ? array_map( 'esc_attr', $g2_pro_options['agents'] ) : '';

$agent_count = ( isset( $g2_pro_options['agent_count'] ) ) ? esc_attr( $g2_pro_options['agent_count'] ) : 1;
$key_gen     = 1;


$pre_filled_placeholder = "Hello {site} \nLike to know more information about {title}, {url}";

$days = array(
	'monday',
	'tuesday',
	'wednesday',
	'thursday',
	'friday',
	'saturday',
	'sunday',
);

$fallback_img_url = plugins_url( 'inc/assets/img/wa-round-64.png', HT_CTC_PRO_PLUGIN_FILE );
?>
 
<div class="ht_ctc_pro_agent">

	<!-- display fileds -->
	<div class="ctc_display_agents ctc_sortable">
		<?php

		if ( is_array( $agents ) && isset( $agents[0] ) ) {
			foreach ( $agents as $agent ) {

				$agent_options = ( isset( $g2_pro_options[ $agent ] ) ) ? map_deep( $g2_pro_options[ $agent ], 'esc_attr' ) : '';

				$enable_checked = ( isset( $agent_options['enable'] ) ) ? '1' : '';

				$number = ( isset( $agent_options['number'] ) ) ? $agent_options['number'] : '';
				if ( class_exists( 'HT_CTC_Formatting' ) && method_exists( 'HT_CTC_Formatting', 'wa_number' ) ) {
					$number = HT_CTC_Formatting::wa_number( $number );
				}
				if ( '' !== $number ) {
					$number = "+$number";
				}

				$col_header_styles = '';
				if ( '' === $enable_checked ) {
					$col_header_styles = 'opacity:0.5;';
				}

				$agent_title = ( isset( $agent_options['title'] ) ) ? $agent_options['title'] : '';
				$description = ( isset( $agent_options['description'] ) ) ? $agent_options['description'] : '';
				$pre_filled  = ( isset( $agent_options['pre_filled'] ) ) ? $agent_options['pre_filled'] : '';

				$agent_image_id  = ( isset( $agent_options['agent_image_id'] ) ) ? $agent_options['agent_image_id'] : '';
				$agent_image_url = ( isset( $agent_options['agent_image_url'] ) ) ? $agent_options['agent_image_url'] : '';

				$img_url                = '';
				$hide_img               = '';
				$hide_fallback_img      = '';
				$hide_remove_img_button = '';

				if ( '' !== $agent_image_id ) {
					// wp_get_attachment_image_url return false if image is not available
					$img_url = wp_get_attachment_image_url( $agent_image_id, 'medium' );
				}

				if ( false !== $img_url && '' !== $img_url ) {
					// image is available
					$hide_fallback_img = 'display:none;';
				} else {
					$hide_img               = 'display:none;';
					$hide_remove_img_button = 'display:none;';

					$img_url = $fallback_img_url;
				}


				$agent_header = ( '' !== $agent_title ) ? $agent_title : 'Agent';
				$ref_name     = ( isset( $agent_options['ref_name'] ) ) ? $agent_options['ref_name'] : '';

				$header_ref_name = '';
				if ( '' !== $ref_name ) {
					$header_ref_name = ": $ref_name";
				}

				// timings/schedule - always, set
				$timings           = ( isset( $agent_options['timings'] ) ) ? $agent_options['timings'] : 'always';
				$display_schedule  = ( 'set' === $timings ) ? '' : 'display:none;';
				$current_site_time = ( 'set' === $timings ) ? '' : 'ctc_init_display_none';

				$agent_active_class = ( isset( $agent_options['fallback_values'] ) ) ? 'active' : '';


				?>

				<div class="ht_ctc_pro_agent">
					<div class="agent">
						<ul class="collapsible coll_active <?php echo esc_attr( $agent ); ?>" data-coll_active = "<?php echo esc_attr( $agent ); ?>" >
						<li class="<?php echo esc_attr( $agent_active_class ); ?>">
						<div class="collapsible-header" style="display:flex; <?php echo esc_attr( $col_header_styles ); ?>">
							<span class="left_icon dashicons dashicons-editor-justify handle" style="color:#ddd; cursor:move;"></span>
							<span class="agent_header" style="line-height:1.4; margin: 0 11px;"><span class="header_agent_name"><?php echo esc_html( $agent_header ); ?></span><span class="header_ref_name"><?php echo esc_html( $header_ref_name ); ?></span></span>
							<span style="color:#039be5; cursor:pointer;" class="ht_ctc_pro_agent_remove_agent_link right_icon dashicons dashicons-no-alt" title="Remove Agent"></span>
						</div>
						<div class="collapsible-body">

						<div class="row">

							<!-- agent number - ht_ctc_greetings_pro_2[agents][<agent_count>] -->
							<input name="ht_ctc_greetings_pro_2[agents][]" style="display: none;" type="text" class="ht_ctc_pro_agent_number" value="<?php echo esc_attr( $agent ); ?>">
						
							<!-- name: ht_ctc_greetings_pro_2[agents][<agent_count>] -->
							<input style="display: none;" type="text" class="ht_ctc_pro_agent_field_ref_number" value="<?php echo esc_attr( $agent_count ); ?>">

							<!-- reference name - float right -->
							<input name="ht_ctc_greetings_pro_2[<?php echo esc_attr( $agent ); ?>][ref_name]" value="<?php echo esc_attr( $ref_name ); ?>" placeholder="Reference name" id="<?php echo esc_attr( $agent . '_ref_name' ); ?>" type="text" class="ht_ctc_pro_agent_field_ref_name ref_name browser-default input-margin" style="float:right; border:0; background-color:inherit; margin-top:-19px; width:auto; max-width: 130px; color: darkgrey;">

							<div class="col s12" style="margin-bottom:24px;">
								<label>
									<input name="ht_ctc_greetings_pro_2[<?php echo esc_attr( $agent ); ?>][enable]" value="1" <?php checked( $enable_checked, 1 ); ?> id="<?php echo esc_attr( $agent . '_enable' ); ?>" type="checkbox" class="ht_ctc_pro_agent_field_enable">
										<span><?php esc_html_e( 'Enable Agent', 'click-to-chat-pro' ); ?></span>
								</label>
							</div>

							<div class="input-field col s12">
								<label style="margin-top:-5px;"><?php esc_html_e( 'WhatsApp Number', 'click-to-chat-pro' ); ?></label>
								<input name="ht_ctc_greetings_pro_2[<?php echo esc_attr( $agent ); ?>][number]" data-name="ht_ctc_greetings_pro_2[<?php echo esc_attr( $agent ); ?>][number]" value="<?php echo esc_attr( $number ); ?>" id="<?php echo esc_attr( $agent . '_wa_number' ); ?>" type="text" class="ht_ctc_pro_agent_field_number intl_number browser-default">
							</div>
							<div class="input-field col s12">
								<input name="ht_ctc_greetings_pro_2[<?php echo esc_attr( $agent ); ?>][title]" value="<?php echo esc_attr( $agent_title ); ?>" placeholder="" id="<?php echo esc_attr( $agent . '_title' ); ?>" type="text" class="ht_ctc_pro_agent_field_title input-margin">
										<label><?php esc_html_e( 'Title (first line)', 'click-to-chat-pro' ); ?></label>
							</div>
							<div class="input-field col s12">
								<input name="ht_ctc_greetings_pro_2[<?php echo esc_attr( $agent ); ?>][description]" value="<?php echo esc_attr( $description ); ?>" placeholder="" id="<?php echo esc_attr( $agent . '_description' ); ?>" type="text" class="ht_ctc_pro_agent_field_description input-margin">
										<label><?php esc_html_e( 'Description (second line)', 'click-to-chat-pro' ); ?></label>
							</div>
							<div class="input-field col s12">
								<textarea name="ht_ctc_greetings_pro_2[<?php echo esc_attr( $agent ); ?>][pre_filled]" style="min-height: 64px;" placeholder="<?php echo esc_attr( $pre_filled_placeholder ); ?>" id="<?php echo esc_attr( $agent . '_pre_filled' ); ?>" class="ht_ctc_pro_agent_field_pre_filled materialize-textarea input-margin"><?php echo esc_textarea( $pre_filled ); ?></textarea>
										<label><?php esc_html_e( 'Pre-filled message', 'click-to-chat-pro' ); ?></label>
										<p class="description"><?php esc_html_e( 'Variables {site}, {url}, {title} to replace with site name, current webpage URL, Post title', 'click-to-chat-pro' ); ?> - <a target="_blank" href="https://holithemes.com/plugins/click-to-chat/pre-filled-message/"><?php esc_html_e( 'more info', 'click-to-chat-pro' ); ?></a> </p>
							</div>
							<div class="col s12 pr_agent_image <?php echo esc_attr( 'image_' . $agent ); ?>" style="display:flex; align-items:center;">
								<img class="multi_agent_preview_image" style="width:48px; height:48px; border-radius:50%; <?php echo esc_attr( $hide_img ); ?>" src="<?php echo esc_url( $img_url ); ?>" />
								<img class="multi_agent_preview_fallback_image" style="width:48px; height:48px; border-radius:50%; <?php echo esc_attr( $hide_fallback_img ); ?>" src="<?php echo esc_url( $fallback_img_url ); ?>" />
								<div class="input-field">
									<input name="ht_ctc_greetings_pro_2[<?php echo esc_attr( $agent ); ?>][agent_image_id]" value="<?php echo esc_attr( $agent_image_id ); ?>" placeholder="" id="<?php echo esc_attr( $agent . '_agent_image_id' ); ?>" type="hidden" class="ht_ctc_pro_agent_field_agent_image_id">
									<input name="ht_ctc_greetings_pro_2[<?php echo esc_attr( $agent ); ?>][agent_image_url]" value="<?php echo esc_url( $agent_image_url ); ?>" placeholder="" id="<?php echo esc_attr( $agent . '_agent_image_url' ); ?>" type="hidden" class="ht_ctc_pro_agent_field_agent_image_url">
									<input type='button' style="margin: 0 7px;" class="button-primary greetings_multi_agent_image" value="Agent Image" data-agent="<?php echo esc_attr( $agent ); ?>"/>
									<input type='button' style="margin: 0 1px; <?php echo esc_attr( $hide_remove_img_button ); ?>" class="button-secondary greetings_multi_agent_remove_image" value="Remove Image" data-agent="<?php echo esc_attr( $agent ); ?>"/>
								</div>
							</div>
						</div>

						<div class="row multi_timings">
							<p class="col">
								<label>
								<input name="ht_ctc_greetings_pro_2[<?php echo esc_attr( $agent ); ?>][timings]" value="always" type="radio" <?php checked( 'always' === $timings ); ?> class="with-gap"/>
								<span><?php esc_html_e( '24x7 Online', 'click-to-chat-pro' ); ?></span>
								</label>
							</p>
							<p class="col">
								<label>
								<input name="ht_ctc_greetings_pro_2[<?php echo esc_attr( $agent ); ?>][timings]" value="set" type="radio" <?php checked( 'set' === $timings ); ?> class="with-gap"/>
								<span><?php esc_html_e( 'Set timings', 'click-to-chat-pro' ); ?></span>
								</label>
							</p>
						</div>

						<p class="description current_site_time <?php echo esc_attr( $current_site_time ); ?>" style="margin-bottom:12px;font-size:12px;">Current Site Time: <code><?php echo esc_html( current_time( 'mysql' ) ); ?></code> <span style="font-size:11px;">( Settings -> General - Timezone (<?php echo esc_html( $gtm_offset ); ?>) )</span></p>
						<?php

						foreach ( $days as $day ) {

							$st = $day . '_st';
							$et = $day . '_et';

							$day_checked = ( isset( $agent_options[ $day ] ) ) ? '1' : '';
							$day_times   = ( isset( $agent_options[ $day . '_times' ] ) ) ? $agent_options[ $day . '_times' ] : '';

							$add_time_here_class = ( '1' === $day_checked ) ? '' : 'ctc_init_display_none';
							?>

							<div class="multi_schedule" style="<?php echo esc_attr( $display_schedule ); ?> margin-bottom: 12px; border: 1px solid #dddddd; padding: 20px;" data-agent="<?php echo esc_attr( $agent ); ?>" data-day="<?php echo esc_attr( $day ); ?>">
								<div class="flex" style="display:flex; align-items: center; gap: 12px;">

									<div class="input-field" style="min-width: 130px; margin: 1px 0px;">
										<p>
											<label>
												<input class="day_checkbox" name="<?php echo esc_attr( $dbrow ); ?>[<?php echo esc_attr( $agent ); ?>][<?php echo esc_attr( $day ); ?>]" type="checkbox" value="1" <?php checked( $day_checked, 1 ); ?> id="<?php echo esc_attr( $agent . '_' . $day ); ?>">
												<span><?php echo esc_html( ucfirst( $day ) ); ?></span>
											</label>
										</p>
									</div>

									<div style="display: flex; flex-direction: column;">
									<?php
									if ( is_array( $day_times ) ) { // && $day_times[0]
										?>
										<div class="add_time_here <?php echo esc_attr( $add_time_here_class ); ?> ">
										<?php
										$set_count = 1;
										foreach ( $day_times as $set ) {

											$start_time = ( isset( $set['st'] ) ) ? esc_attr( $set['st'] ) : '';
											$end_time   = ( isset( $set['et'] ) ) ? esc_attr( $set['et'] ) : '';

											/**
											 * Is start or time is set then only end..
											 * and if only one is added then other one is 0: 00;
											 */
											if ( '' === $start_time && '' === $end_time ) {
												continue;
											}
											// by above if - alteast one is added....

											if ( '' === $start_time || '' === $end_time ) {
												$start_time = ( '' !== $start_time ) ? $start_time : '0: 00';
												$end_time   = ( '' !== $end_time ) ? $end_time : '0: 00';
											}
											?>
											<div class="add_time" style="display: flex; flex-direction: column;">
												<div style="display: flex;">
													<div class="input-field ctc_time_<?php echo esc_attr( $day ); ?>" style="min-width: 130px; margin: 1px 0px;">
														<input name="<?php echo esc_attr( $dbrow ); ?>[<?php echo esc_attr( $agent ); ?>][<?php echo esc_attr( $day . '_times' ); ?>][set_<?php echo esc_attr( $set_count ); ?>][st]" placeholder="" value="<?php echo esc_attr( $start_time ); ?>" id="<?php echo esc_attr( $agent . '_' . $st ); ?>" type="text" class="ctc_j_timepicker_start">
														<span class="helper-text">Start time</span>
													</div>
													<div class="input-field ctc_time_<?php echo esc_attr( $day ); ?>" style="min-width: 130px; margin: 1px 10px;">
														<input name="<?php echo esc_attr( $dbrow ); ?>[<?php echo esc_attr( $agent ); ?>][<?php echo esc_attr( $day . '_times' ); ?>][set_<?php echo esc_attr( $set_count ); ?>][et]" placeholder="" value="<?php echo esc_attr( $end_time ); ?>" id="<?php echo esc_attr( $agent . '_' . $et ); ?>" type="text" class="ctc_j_timepicker_end">
														<span class="helper-text">End time</span>
													</div>
													<span style="color:#dddddd;float:right;cursor:pointer;" class="ht_ctc_pro_agent_remove_time_set_link dashicons dashicons-no-alt" title="Remove Agent"></span>
												</div>
												<!-- <span class="agent_set_time_range" style="color:#aeaeae;">Time set for __H __M from __:__ to __:__ </span> -->
											</div>
											<?php
											++$set_count;
										}
										?>
											<div class="add_time_set" style="display: flex; flex-direction: column;">
											</div>
											<div class="today_schedule"><span class="online_24_content" style="display: none;">24 Hours online&emsp;(or)&emsp;</span><span class="click_to_add_time" style="color: #039be5; cursor: pointer; float: right;">Add Time</span></div>
										</div>
										<?php
									} else {
										?>
										<div class="add_time_here <?php echo esc_attr( $add_time_here_class ); ?>">
											<div class="add_time_set" style="display: flex; flex-direction: column;">
											</div>
											<div class="today_schedule"><span class="online_24_content">24 Hours online&emsp;(or)&emsp;</span><span class="click_to_add_time" style="color: #039be5; cursor: pointer; float: right;">Add Time</span></div>
										</div>
										<?php
									}
									?>
									</div>
								</div>
							</div>


							<?php

						}
						?>

						<div>
								<p class="unique_id description">Unique Id: <span><?php echo esc_html( $agent ); ?></span> (useful at translation plugins, .. )</p>
						</div>

						</div>
						</li>
						</ul>
					</div>
				</div>


				<?php
				++$key_gen;
			}
		}

		?>
			</div>

	<!-- new fileds - while adding -->
	<div class="ctc_new_agents">
	</div>

	<!-- Add Agent - button -->
	<div class="ctc_add_agent_button" style="display: inline-block; margin: 10px 0px; cursor:pointer; font-size:16px; font-weight:500; border: 2px solid #2196f3; padding: 8px; border-radius:25px;">
		<span style="color: #039be5;" class="dashicons dashicons-plus-alt2" ></span>
		<span style="color: #039be5;">Add Agent</span>
	</div>



	<!-- snippets, .... -->
	<div class="ctc_agent_snippets" style="display: none;">

		<!-- filed count - agent_1 agent_2 ... -->
						<input type="text" name="ht_ctc_greetings_pro_2[agent_count]" class="ht_ctc_pro_agent_count" value="<?php echo esc_attr( $agent_count ); ?>">

		<!-- snippet: add agent -->
		<div class="ht_ctc_pro_agent">

			<div class="agent">
				<ul class="collapsible">
				<li class="active">

				<div class="collapsible-header">
					<span class="agent_header"><span class="header_agent_name">Agent</span><span class="header_ref_name"></span></span>
					<span style="color:#039be5; margin-left:auto; cursor:pointer;" class="ht_ctc_pro_agent_remove_agent_link dashicons dashicons-no-alt" title="Remove Agent"></span>
				</div>
				<div class="collapsible-body">

				<div class="row">

					<!-- name: ht_ctc_greetings_pro_2[agents][<agent_count>] -->
							<input style="display: none;" type="text" class="ht_ctc_pro_agent_field_ref_number" value="<?php echo esc_attr( $agent_count ); ?>">

					<input value="" placeholder="Reference name" id="ref_name" type="text" class="ht_ctc_pro_agent_field_ref_name ref_name browser-default input-margin" style="float:right; border:0; background-color:inherit; margin-top:-19px; width:auto; max-width: 130px; color: darkgrey;">

					<input value="1" id="enable" checked="checked" type="checkbox" style="display:none;" class="ht_ctc_pro_agent_field_enable hide">

					<div class="input-field col s12" style="margin-top:0;">
							<p class="description" style="margin-bottom:5px;"><?php esc_html_e( 'WhatsApp Number', 'click-to-chat-pro' ); ?></p>
						<input value="" id="whatsapp_number" type="text" class="browser-default ht_ctc_pro_agent_field_number input-margin">
					</div>
					<div class="input-field col s12">
						<input value="" placeholder="Name, Department, .." id="agent_title" type="text" class="ht_ctc_pro_agent_field_title input-margin">
							<label for="agent_title"><?php esc_html_e( 'Title', 'click-to-chat-pro' ); ?></label>
					</div>
					<div class="input-field col s12">
						<input value="" placeholder="Name, Department, .." id="agent_description" type="text" class="ht_ctc_pro_agent_field_description input-margin">
							<label for="agent_description"><?php esc_html_e( 'Description', 'click-to-chat-pro' ); ?></label>
					</div>
					<div class="input-field col s12">
							<textarea style="min-height: 64px;" placeholder="<?php echo esc_attr( $pre_filled_placeholder ); ?>" id=" pre_filled " class="ht_ctc_pro_agent_field_pre_filled materialize-textarea input-margin"></textarea>
							<label for="pre_filled"><?php esc_html_e( 'Pre-filled message', 'click-to-chat-pro' ); ?></label>
							<p class="description"><?php esc_html_e( 'Variables {site}, {url}, {title} to replace with site name, current webpage URL, Post title', 'click-to-chat-pro' ); ?> - <a target="_blank" href="https://holithemes.com/plugins/click-to-chat/pre-filled-message/"><?php esc_html_e( 'more info', 'click-to-chat-pro' ); ?></a> </p>
					</div>
					<div class="col s12 pr_agent_image" style="display:flex; align-items:center;">
						<img class="multi_agent_preview_image" style="width:48px; height:48px; border-radius:50%; display:none;"/>
							<img class="multi_agent_preview_fallback_image" style="width:48px; height:48px; border-radius:50%;" src="<?php echo esc_url( $fallback_img_url ); ?>" />
						<div class="input-field">
							<input placeholder="" id="agent_image_id" type="hidden" class="ht_ctc_pro_agent_field_agent_image_id">
							<input placeholder="" id="agent_image_url" type="hidden" class="ht_ctc_pro_agent_field_agent_image_url">
							<input type='button' style="margin: 0 7px;" class="button-primary greetings_multi_agent_image" value="Agent Image"/>
							<input type='button' style="margin: 0 1px; display:none;" class="button-secondary greetings_multi_agent_remove_image" value="Remove Image"/>
						</div>
					</div>
				</div>

				<div class="row multi_timings">
					<p class="col">
						<label>
						<input checked value="always" type="radio" data-key="timings" checked class="ht_ctc_pro_agent_schedule with-gap"/>
						<span><?php esc_html_e( '24x7 Online', 'click-to-chat-pro' ); ?></span>
						</label>
					</p>
					<p class="col">
						<label>
						<input value="set" type="radio" data-key="timings" class="ht_ctc_pro_agent_schedule with-gap"/>
						<span><?php esc_html_e( 'Set timings', 'click-to-chat-pro' ); ?></span>
						</label>
					</p>
				</div>
				
				<p class="description current_site_time ctc_init_display_none" style="margin-bottom:12px;font-size:12px;">Current Site Time: <code><?php echo esc_html( current_time( 'mysql' ) ); ?></code> <span style="font-size:11px;">( Settings -> General - Timezone (<?php echo esc_html( $gtm_offset ); ?>) )</span></p>
				<?php

				foreach ( $days as $day ) {

					$st = $day . '_st';
					$et = $day . '_et';
					?>
										
					<div class="multi_schedule" style="display:none; margin-bottom: 12px; border: 1px solid #dddddd; padding: 20px;"">
						<div class="flex" style="display:flex; align-items: center; gap: 12px;">

							<div class="input-field" style="min-width: 130px; margin: 1px 0px;">
								<p>
									<label>
										<input class="day_checkbox ht_ctc_pro_agent_schedule" type="checkbox" value="1" id="<?php echo esc_attr( $day ); ?>" data-key="<?php echo esc_attr( $day ); ?>">
										<span><?php echo esc_html( ucfirst( $day ) ); ?></span>
									</label>
								</p>
							</div>

							<div style="display: flex; flex-direction: column;">
								<div class="add_time_here ctc_init_display_none">
									<div class="add_time_set" style="display: flex; flex-direction: column;">
									</div>
									<div class="today_schedule"><span class="online_24_content">24 Hours online&emsp;(or)&emsp;</span><span class="click_to_add_time" style="color: #039be5; cursor: pointer; float: right;">Add Time</span></div>
								</div>
							</div>
						</div>
					</div>


					<?php
				}
				?>

				<div>
					<p class="unique_id description">Unique Id: <span></span> (useful at translation plugins, .. )</p>
				</div>


				</div>
				</li>
				</ul>
			</div>
			
		</div>

		<!-- snippet: add time -->
		<div class="add_time" style="display: flex;">
			<div class="input-field" style="min-width: 130px; margin: 1px 0px;">
				<input placeholder="" type="text" class="ctc_j_timepicker_start add_time_st">
				<span class="helper-text">Start time</span>
			</div>
			<div class="input-field" style="min-width: 130px; margin: 1px 10px;">
				<input placeholder="" type="text" class="ctc_j_timepicker_end add_time_et">
				<span class="helper-text">End time</span>
			</div>
			<span style="color:#dddddd; float:right; cursor:pointer;" class="ht_ctc_pro_agent_remove_time_set_link dashicons dashicons-no-alt" title="Remove Agent"></span>
		</div>


	</div>
	<!-- #END snippets -->

</div>


<br><br>
