<?php
/**
 *  ** template/component **
 *
 * Greetings dialog PRO - 1 - settings.. form fields..
 *
 * @package Click_To_Chat_Pro
 * @subpackage PRO Admin
 *
 * $field_count - next save field count
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$safe_fallback_values = array();
if ( isset( $fallback_values ) ) {
	$safe_fallback_values = $fallback_values;
}

$g1_pro_options = get_option( 'ht_ctc_greetings_pro_1', $safe_fallback_values );

$fields = ( isset( $g1_pro_options['fields'] ) ) ? array_map( 'esc_attr', $g1_pro_options['fields'] ) : '';

$is_load_intltelinput            = ( isset( $g1_pro_options['is_load_intltelinput'] ) ) ? esc_attr( $g1_pro_options['is_load_intltelinput'] ) : 'n';
$load_type_intltel_files         = ( isset( $g1_pro_options['load_type_intltel_files'] ) ) ? esc_attr( $g1_pro_options['load_type_intltel_files'] ) : 'delay_2';
$intl_separate_dialcode_checkbox = ( isset( $g1_pro_options['intl_separate_dialcode'] ) ) ? esc_attr( $g1_pro_options['intl_separate_dialcode'] ) : '';
$intl_language                   = ( isset( $g1_pro_options['intl_language'] ) ) ? esc_attr( $g1_pro_options['intl_language'] ) : '';
$intl_initial_country            = ( isset( $g1_pro_options['intl_initial_country'] ) ) ? esc_attr( $g1_pro_options['intl_initial_country'] ) : 'auto';
$is_load_date_field              = ( isset( $g1_pro_options['is_load_date_field'] ) ) ? esc_attr( $g1_pro_options['is_load_date_field'] ) : 'n';


$field_count = ( isset( $g1_pro_options['field_count'] ) ) ? esc_attr( $g1_pro_options['field_count'] ) : 1;
$key_gen     = 1;
?>

<div class="ht_ctc_pro_form">

	<!-- display fileds -->
	<div class="ctc_display_fields ctc_sortable">

		<?php

		if ( is_array( $fields ) && isset( $fields[0] ) ) {
			foreach ( $fields as $field ) {
				$field_options     = ( isset( $g1_pro_options[ $field ] ) ) ? array_map( 'esc_attr', $g1_pro_options[ $field ] ) : '';
				$select_field_type = ( isset( $field_options['type'] ) ) ? $field_options['type'] : '';
				$field_name        = ( isset( $field_options['name'] ) ) ? $field_options['name'] : '';
				$field_placeholder = ( isset( $field_options['placeholder'] ) ) ? $field_options['placeholder'] : '';
				$time_name         = ( isset( $field_options['time_name'] ) ) ? $field_options['time_name'] : '';
				$required          = ( isset( $field_options['required'] ) ) ? $field_options['required'] : '';
				$add_to_prefilled  = ( isset( $field_options['add_to_prefilled'] ) ) ? $field_options['add_to_prefilled'] : '';
				?>
				<div class="ht_ctc_pro_field" style="border: 1px solid #dddddd; max-width: 800px; padding:20px; margin-bottom:15px;">

					<div class="row">
						<span class="dashicons dashicons-editor-justify handle" style="color:#ddd; cursor:move; margin-right:11px;"></span>
						<span style="color:#039be5; float:right; cursor:pointer;" class="ht_ctc_pro_form_remove_field_link dashicons dashicons-no-alt" title="Remove field"></span>
					</div>
					
					<div class="row">
						<!-- field number - ht_ctc_greetings_pro_1[fields][<field_count>] -->
						<input name="ht_ctc_greetings_pro_1[fields][]" style="display: none;" type="text" class="ht_ctc_pro_form_field_number" value="<?php echo esc_attr( $field ); ?>">

						<!-- select field type -->
						<div class="input-field col s6">
							<!-- ht_ctc_greetings_pro_1[<field_count>][type] -->
							<select name="ht_ctc_greetings_pro_1[<?php echo esc_attr( $field ); ?>][type]" class="ht_ctc_pro_form_select_field_type browser-default">
								<option value="text" <?php selected( $select_field_type, 'text' ); ?> >Text </option>
								<option value="email" <?php selected( $select_field_type, 'email' ); ?>>Email</option>
								<option value="textarea" <?php selected( $select_field_type, 'textarea' ); ?>>TextArea (large field)</option>
								<option value="checkbox" <?php selected( $select_field_type, 'checkbox' ); ?>>Checkbox</option>
								<option value="select" <?php selected( $select_field_type, 'select' ); ?>>Select</option>
								<option value="date" <?php selected( $select_field_type, 'date' ); ?>>Date (Beta)</option>
								<option value="number" <?php selected( $select_field_type, 'number' ); ?>>Number (intl tel input)</option>
								<option value="hidden" <?php selected( $select_field_type, 'hidden' ); ?>>Hidden</option>
							</select>
						</div>
						
						<!-- field - name, placeholder, required -->
						<div class="input-field col s6">
							<?php
							$select_textarea_placeholder = "option 1, \noption 2, \noption 3, \n...";

							// this way.. while saving options for the next time. not saving the select values if the field type is not select. (especially when changing the field type from select to text or email..)
							$field_selectvalues       = '';
							$selectvalues_display_css = 'display: none;';
							if ( 'select' === $select_field_type ) {
								$field_selectvalues       = ( isset( $field_options['selectvalues'] ) ) ? $field_options['selectvalues'] : '';
								$selectvalues_display_css = '';
							}
							// hiddenvalue
							$hiddenvalue             = '';
							$hiddenvalue_display_css = 'display: none;';
							if ( 'hidden' === $select_field_type ) {
								$hiddenvalue             = ( isset( $field_options['hiddenvalue'] ) ) ? $field_options['hiddenvalue'] : '';
								$hiddenvalue_display_css = '';
							}
							?>

							<div class="g_form_field_type_select" style="<?php echo esc_attr( $selectvalues_display_css ); ?> margin-bottom: 12px;">
								<label>Select options (required)</label>
								<textarea name="ht_ctc_greetings_pro_1[<?php echo esc_attr( $field ); ?>][selectvalues]" placeholder="<?php echo esc_attr( $select_textarea_placeholder ); ?>" class="ht_ctc_pro_form_select_field_selectvalues" style="min-height: 88px;"><?php echo esc_textarea( $field_selectvalues ); ?></textarea>
								<p class="description">Add each select option in different line or separate with comma(,).</p>
							</div>
							<div class="g_form_field_type_name">
								<label for=""><?php esc_html_e( 'Field Name', 'click-to-chat-pro' ); ?></label>
								<input name="ht_ctc_greetings_pro_1[<?php echo esc_attr( $field ); ?>][name]" class="ht_ctc_pro_form_select_field_name" type="text" value="<?php echo esc_attr( $field_name ); ?>">
							</div>
							<div class="g_form_field_type_placeholder">
								<label for=""><?php esc_html_e( 'Placeholder', 'click-to-chat-pro' ); ?></label>
								<input name="ht_ctc_greetings_pro_1[<?php echo esc_attr( $field ); ?>][placeholder]" class="ht_ctc_pro_form_select_field_placeholder" type="text" value="<?php echo esc_attr( $field_placeholder ); ?>">
							</div>
							<div class="g_form_field_type_time_name ctc_init_display_none ctc_dt_field">
								<label for=""><?php esc_html_e( 'Time Field Name', 'click-to-chat-pro' ); ?></label>
								<input name="ht_ctc_greetings_pro_1[<?php echo esc_attr( $field ); ?>][time_name]" class="ht_ctc_pro_form_select_field_time_name" type="text" value="<?php echo esc_attr( $time_name ); ?>">
							</div>
							<div class="g_form_field_type_hidden" style="<?php echo esc_attr( $hiddenvalue_display_css ); ?>">
								<label for="">Value</label>
								<input name="ht_ctc_greetings_pro_1[<?php echo esc_attr( $field ); ?>][hiddenvalue]" class="ht_ctc_pro_form_select_field_hiddenvalue" type="text" value="<?php echo esc_attr( $hiddenvalue ); ?>" placeholder="[gclid]">
							</div>
							<div class="g_form_field_type_checkboxes">
								<div class="g_form_field_type_required">
									<label for="ctc_required_checkbox_<?php echo esc_attr( $key_gen ); ?>">
										<input type="checkbox" name="ht_ctc_greetings_pro_1[<?php echo esc_attr( $field ); ?>][required]" <?php checked( $required, 1 ); ?> id="ctc_required_checkbox_<?php echo esc_attr( $key_gen ); ?>" value="1">
										<span>Required</span>
									</label>
								</div>
								<div class="g_form_field_type_add_to_prefilled">
									<label for="ctc_add_to_prefilled_checkbox_<?php echo esc_attr( $key_gen ); ?>">
										<input type="checkbox" name="ht_ctc_greetings_pro_1[<?php echo esc_attr( $field ); ?>][add_to_prefilled]" <?php checked( $add_to_prefilled, 1 ); ?> id="ctc_add_to_prefilled_checkbox_<?php echo esc_attr( $key_gen ); ?>" value="1">
										<span>Add to Prefilled message</span>
									</label>
								</div>
							</div>

							<!-- display for checkbox field -->
							<div class="ctc_init_display_none g_form_element g_form_element_checbox">
								<p class="description"><a target="_blank" href="https://holithemes.com/plugins/click-to-chat/greetings-form/#checkbox">Add links</a>: e.g. [privacy](https://...)</p>
							</div>
							
							<!-- for number field -->
							<div class="ctc_init_display_none g_form_element g_form_element_number">
								<p class="description"><a href="#intltelinput_settings">Number Field (IntltelInput) settings.</a></p>
								<?php
								if ( defined( 'HT_CTC_FILES_PLUGIN_FILE' ) ) {
									// click to chat files plugin is active
									?>
									<p class="description" style="font-size: 0.8em;">plugin loads Intltel library from the plugin: 'Click to Chat Files' (installed on this website)</p>
									<?php
								} else {
									// load from github using jsDelivr cdn.  (click to chat files plugin is not active)
									?>
									<p class="description" style="font-size: 0.8em;">plugin loads Intltel library hosted at GitHub using jsDelivr cdn</p>
									<?php
								}
								?>
							</div>

							<!-- todo: for date filed -->
							<div class="ctc_init_display_none g_form_element g_form_element_date">
								<p class="description"><a href="#g_form_date_settings">Date Field settings</a></p>
							</div>

							<!-- for hidden field -->
							<div class="ctc_init_display_none g_form_element g_form_element_hidden">
								<details style="margin:7px 0px;">
									<summary>Dynamic Variables: cookie: [[]], URL parameters: []</summary>
									<p class="description" style="margin:8px 10px 10px 10px;">
										<strong>Get value from url parameters:</strong> Text with in single square brackets <code>[]</code> will get value from url parameters. if not exists, return blank
										e.g. <code>[gclid]</code>, <code>[utm_source]</code> 
										<br>
										<strong>Get value from cookies:</strong> Text with in double square brackets <code>[[]]</code> will get value from cookies. if not exists, return blank.
										<br> e.g. <code>[[_ga]]</code> 
									</p>
									<a style="margin:15px 10px;" target="_blank" href="https://holithemes.com/plugins/click-to-chat/greetings-form/#hidden">Hidden Field</a>
									</details>
								<!-- todo: at docs.. add id to make this link works .. and uncomment here. -->
								<!-- <a target="_blank" href="#hiddenfield">Hidden filed Values</a> -->
							</div>
							

						</div>
					</div>


				</div>
				<?php
				++$key_gen;
			}
		}

		?>

		<!-- date settings -->
		<!-- todo: display if date type is set..  logic similar to number.. -->
		<details id="g_form_date_settings" class="g_form_date_settings" open style="margin: 12px 0px;">
			<summary><strong>Date Field Settings</strong></summary>
			<div style="margin:0 12px;">

				<input type="hidden" name="ht_ctc_greetings_pro_1[is_load_date_field]" class="ht_ctc_pro_form_fields ctc_is_load_date_field" value="<?php echo esc_attr( $is_load_date_field ); ?>">
				<?php
				// Fetch and debug form_date options
				$form_date       = ( isset( $g1_pro_options['form_date'] ) ) ? $g1_pro_options['form_date'] : '';
				$date_mode       = ( isset( $form_date['date_mode'] ) ) ? esc_attr( $form_date['date_mode'] ) : 'date_only';
				$schedule_upto   = ( isset( $form_date['schedule_upto'] ) ) ? esc_attr( $form_date['schedule_upto'] ) : '';
				$min_notice      = ( isset( $form_date['min_notice'] ) ) ? esc_attr( $form_date['min_notice'] ) : '';
				$slot_duration   = ( isset( $form_date['slot_duration'] ) ) ? esc_attr( $form_date['slot_duration'] ) : '';
				$selected_timing = isset( $form_date['timings'] ) ? $form_date['timings'] : 'always';
				$min_date        = ( isset( $form_date['min_date'] ) ) ? esc_attr( $form_date['min_date'] ) : '';
				$max_date        = ( isset( $form_date['max_date'] ) ) ? esc_attr( $form_date['max_date'] ) : '';

				?>

				<div class="row">
					<div class="col s6">
						<p>Date Mode</p>
					</div>
					<div class="input-field col s6">
						<select name="ht_ctc_greetings_pro_1[form_date][date_mode]" class="ht_ctc_g1_pro_date_mode">
							<option value="date_only" <?php selected( $date_mode, 'date_only' ); ?>><?php esc_html_e( 'Date Only', 'click-to-chat-pro' ); ?></option>
							<option value="scheduler" <?php selected( $date_mode, 'scheduler' ); ?>><?php esc_html_e( 'Scheduler (Date + Time)', 'click-to-chat-pro' ); ?></option>
						</select>
					</div>
				</div>

				<div class="fd_scheduler_settings" style="<?php echo ( 'date_only' === $date_mode ) ? 'display:none;' : ''; ?>">
					<div class="row">
						<div class="col s6">
							<p>Schedule Timings</p>
						</div>
					<div class="row fd_schedule_timings">
						<p class="col">
							<label>
								<input name="ht_ctc_greetings_pro_1[form_date][timings]" value="always" type="radio" <?php checked( $selected_timing, 'always' ); ?> class="with-gap ht_ctc_g1_pro_timesets"/>
								<span><?php esc_html_e( '24x7 Online', 'click-to-chat-pro' ); ?></span>
							</label>
						</p>
						<p class="col">
							<label>
								<input name="ht_ctc_greetings_pro_1[form_date][timings]" value="set" type="radio" <?php checked( $selected_timing, 'set' ); ?> class="with-gap ht_ctc_g1_pro_timesets"/>
								<span><?php esc_html_e( 'Set Schedule', 'click-to-chat-pro' ); ?></span>
							</label>
						</p>
					</div>
				</div>
				
				<?php

				$dbrow = 'ht_ctc_greetings_pro_1';

				$days = array( 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday' );

				foreach ( $days as $day ) {

					// for id generation. $agent . '_st';
					$st = $day . '_st';
					$et = $day . '_et';

					$day_checked = ( isset( $form_date[ $day ] ) ) ? '1' : '';
					$day_times   = ( isset( $form_date[ $day . '_times' ] ) ) ? $form_date[ $day . '_times' ] : '';

					$add_time_here_class = ( isset( $form_date[ $day ] ) && '1' === $form_date[ $day ] ) ? '' : 'ctc_init_display_none';
					?>

					<div class="fd_date_schedule" style="margin-bottom: 12px; border: 1px solid #dddddd; padding: 20px;" data-day="<?php echo esc_attr( $day ); ?>">
						<div class="flex" style=" margin-bottom: 12px; display:flex; align-items: center; gap: 12px;">

							<div class="input-field" style="min-width: 130px; margin: 1px 0px;">
								<p>
									<label>
										<input class="fd_day_checkbox" name="<?php echo esc_attr( $dbrow ); ?>[form_date][<?php echo esc_attr( $day ); ?>]" type="checkbox" value="1" <?php checked( isset( $form_date[ $day ] ) ? $form_date[ $day ] : '', 1 ); ?> id="<?php echo esc_attr( '_' . $day ); ?>">
										<span><?php echo esc_html( ucfirst( $day ) ); ?></span>
									</label>
								</p>
							</div>

							<div style="display: flex; flex-direction: column;">
							<?php
							if ( is_array( $day_times ) ) {
								?>
								<div class="fd_add_time_here <?php echo esc_attr( $add_time_here_class ); ?>">
									<?php
									$set_count = 1;
									foreach ( $day_times as $set ) {

										$start_time = ( isset( $set['st'] ) ) ? esc_attr( $set['st'] ) : '';
										$end_time   = ( isset( $set['et'] ) ) ? esc_attr( $set['et'] ) : '';

										if ( '' === $start_time && '' === $end_time ) {
											continue;
										}

										if ( '' === $start_time || '' === $end_time ) {
											$start_time = ( '' !== $start_time ) ? $start_time : '0:00';
											$end_time   = ( '' !== $end_time ) ? $end_time : '0:00';
										}
										?>
										<div class="fd_add_time" style="display: flex; flex-direction: column;">
											<div style="display: flex;">
												<div class="input-field fd_ctc_time_<?php echo esc_attr( $day ); ?>" style="min-width: 130px; margin: 1px 0px;">
													<input name="<?php echo esc_attr( $dbrow ); ?>[form_date][<?php echo esc_attr( $day . '_times' ); ?>][set_<?php echo esc_attr( $set_count ); ?>][st]" value="<?php echo esc_attr( $start_time ); ?>" type="text" class="fd_ctc_j_timepicker_start">
													<span class="helper-text">Start time</span>
												</div>
												<div class="input-field fd_ctc_time_<?php echo esc_attr( $day ); ?>" style="min-width: 130px; margin: 1px 10px;">
													<input name="<?php echo esc_attr( $dbrow ); ?>[form_date][<?php echo esc_attr( $day . '_times' ); ?>][set_<?php echo esc_attr( $set_count ); ?>][et]" value="<?php echo esc_attr( $end_time ); ?>" type="text" class="fd_ctc_j_timepicker_end">
													<span class="helper-text">End time</span>
												</div>
												<span style="color:#dddddd;float:right;cursor:pointer;" class="fd_ht_ctc_pro_agent_remove_time_set_link dashicons dashicons-no-alt" title="Remove Time Set"></span>
											</div>
										</div>
										<?php
										++$set_count;
									}
									?>
									<div class="fd_add_time_set" style="display: flex; flex-direction: column;"></div>
									<div class="fd_today_schedule"><span class="fd_online_24_content" style="display: none;">24 Hours online &emsp;(or)&emsp;</span><span class="fd_click_to_add_time_form" style="color: #039be5; cursor: pointer; float: right;">Add Time</span></div>
								</div>
								<?php
							} else {
								?>
								<div class="fd_add_time_here <?php echo esc_attr( $add_time_here_class ); ?>">
									<div class="fd_add_time_set" style="display: flex; flex-direction: column;"></div>
									<div class="fd_today_schedule"><span class="fd_online_24_content">24 Hours online &emsp;(or)&emsp;</span><span class="fd_click_to_add_time_form" style="color: #039be5; cursor: pointer; float: right;">Add Time</span></div>
								</div>
								<?php
							}
							?>
							</div>
						</div>
					</div>

					<div class="fd_add_time_snippet_template" style="display: none;">
						<div class="fd_add_time" style="display: flex; flex-direction: column;">
							<div style="display: flex;">
								<div class="input-field" style="min-width: 130px; margin: 1px 0px;">
									<input type="text" class="fd_add_time_st fd_ctc_j_timepicker_start" placeholder="">
									<span class="helper-text">Start time</span>
								</div>
								<div class="input-field" style="min-width: 130px; margin: 1px 10px;">
									<input type="text" class="fd_add_time_et fd_ctc_j_timepicker_end" placeholder="">
									<span class="helper-text">End time</span>
								</div>
								<span style="color:#dddddd; float:right; cursor:pointer;" class="fd_ht_ctc_pro_agent_remove_time_set_link dashicons dashicons-no-alt" title="Remove Time Set"></span>
							</div>
						</div>
					</div>
					<?php
				}
				?>
				
					<!-- schedule upto -->
					<div class="row">
						<div class="col s6">
							<p>Schedule upto</p>
						</div>
						<div class="col s6">
							<input type="number" name="ht_ctc_greetings_pro_1[form_date][schedule_upto]" value="<?php echo esc_attr( $schedule_upto ); ?>" min="1" placeholder="e.g., 7 for next 1 week">
							<p class="description">Define the maximum booking window - enter days (e.g., 7 for one week, 30 for one month) to manage availability effectively.</p>
						</div>
					</div>

					<!-- minimum notice -->
					<div class="row">
						<div class="col s6">
							<p>Minimum Notice</p>
						</div>
						<div class="col s6">
							<input type="number" name="ht_ctc_greetings_pro_1[form_date][min_notice]" value="<?php echo esc_attr( $min_notice ); ?>" min="0" placeholder="e.g., 4 for for next 4 hours">
							<p class="description">Set minimum advance notice in hours (e.g., 4 for same-day, 24 for next-day) to ensure preparation time and prevent conflicts.</p>
						</div>
					</div>

					<!-- duration -->
					<div class="row">
						<div class="col s6">
							<p>Duration</p>
						</div>
						<div class="col s6">
							<input type="number" name="ht_ctc_greetings_pro_1[form_date][slot_duration]" value="<?php echo esc_attr( $slot_duration ); ?>" min="1" max="1440" placeholder="e.g., 15, 30, or 60 minutes">
							<p class="description">Set appointment slot duration in minutes (1-1440) - common values: 15 min consultations, 30 min meetings, 60 min sessions.</p>
						</div>
					</div>
				</div>

				<!-- Date Only Constraints -->
				<div class="fd_date_only_settings" style="<?php echo ( 'scheduler' === $date_mode ) ? 'display:none;' : ''; ?>">
					<div class="row">
						<div class="col s6">
							<p>Min Date</p>
						</div>
						<div class="col s6">
							<input type="text" name="ht_ctc_greetings_pro_1[form_date][min_date]" value="<?php echo esc_attr( $min_date ); ?>" placeholder="e.g., 0 for today or 2025-01-01">
							<p class="description">
								Relative days: 
								0 for today, -7 for today and the past 7 days <br>
								specific date format: 2025-01-01 <br> 
								If no need to set min date leave it blank.
							</p>
						</div>
					</div>
					<div class="row">
						<div class="col s6">
							<p>Max Date</p>
						</div>
						<div class="col s6">
							<input type="text" name="ht_ctc_greetings_pro_1[form_date][max_date]" value="<?php echo esc_attr( $max_date ); ?>" placeholder="e.g., +90 (3 months) or 2025-12-31">
							<p class="description">
								Relative days: 
								+7 for next 7 days, +90 for next 3 months <br>
								specific date format: 2025-12-31 <br> 
								If no need to set max date leave it blank.
							</p>
						</div>
					</div>
				</div>
			</div>
		</details>

		


		<!-- using js, this will display after color settings .pr_g_p_1_message_box_bg_color  -->
		<details id="intltelinput_settings" class="intltelinput_settings" open style="margin: 12px 0px;">
			<summary>Number (intl tel input) Settings</summary>

			<div style="margin:0 12px;">

				<input type="hidden" name="ht_ctc_greetings_pro_1[is_load_intltelinput]" class="ht_ctc_pro_form_fields ctc_is_load_intltelinput" value="<?php echo esc_attr( $is_load_intltelinput ); ?>">

				<p class="description" style="margin: 14px 0;">The number field loads the Intl-tel-input library
				<?php
				if ( defined( 'HT_CTC_FILES_PLUGIN_FILE' ) ) {
					// click to chat files plugin is active
					?>
					from the plugin: 'Click to Chat Files' (installed on this website)
					<?php
				} else {
					// load from github using jsDelivr cdn.  (click to chat files plugin is not active)
					?>
					hosted on <a target="_blank" href="https://github.com/holithemes/click-to-chat-files">GitHub</a> using jsDelivr CDN (a recommended way for easy updates).
					If you do not wish to load from an external source, 
					please install and activate the <a href="https://holithemes.com/shop/downloads/click-to-chat-files/" target="_blank">Click to Chat Files</a> plugin.
					<!-- <a href="https://holithemes.com/plugins/click-to-chat/todo" target="_blank">(more info)</a> -->
					<?php
				}
				?>
				</p>
				

				<div class="row">
					<div class="col s6">
						<p class="description">When to load the intl tel library</p>
					</div>
					<div class="input-field col s6">
						<select name="ht_ctc_greetings_pro_1[load_type_intltel_files]" class="">
							<option value="nodelay" <?php selected( $load_type_intltel_files, 'nodelay' ); ?> >No Delay</option>
							<option value="delay_1" <?php selected( $load_type_intltel_files, 'delay_1' ); ?>>Idle Time</option>
							<option value="delay_2" <?php selected( $load_type_intltel_files, 'delay_2' ); ?>>After user interaction with the Widget</option>
						</select>
						<!-- <p class="description"><a href="todo" target="_blank">more info</a></p> -->
					</div>
				</div>

				<!-- intl_separate_dialcode -->
				<div class="row">
					<div class="col s6">
						<p>Seperate Dial Code</p>
					</div>
					<div class="col s6">
						<label>
							<input name="ht_ctc_greetings_pro_1[intl_separate_dialcode]" type="checkbox" value="1" <?php checked( $intl_separate_dialcode_checkbox, 1 ); ?> />
							<span>Seperate Dial Code</span>
							<p class="description">if checked. displays country dial code, next to the country flag.</p>
						</label>
					</div>
				</div>


				<!-- localization -->
				<div class="row">
					<div class="col s6">
						<p>Localization</p>
					</div>
					<div class="col s6">
						<!-- add options from greetins.js -->
						<select name="ht_ctc_greetings_pro_1[intl_language]" class="browser-default select_intl_language" data-selected="<?php echo esc_attr( $intl_language ); ?>">
						</select>
						<p class="description">Auto : Current page language</p>
					</div>
				</div>

				<!-- intl_initial_country -->
				<div class="row">
					<div class="col s6">
						<p>Initial Country</p>
					</div>
					<div class="col s6">
						<!-- add options from greetins.js -->
						<select name="ht_ctc_greetings_pro_1[intl_initial_country]" class="browser-default select_intl_initial_country" data-selected="<?php echo esc_attr( $intl_initial_country ); ?>">
						</select>
						<p class="description">Auto:  Website vistor country (using ipinfo.io)</p>
					</div>
				</div>

			</div>

		</details>

	</div>

	<!-- new fileds - while adding -->
	<div class="ctc_new_fields">
	</div>

	<!-- Add Field - button -->
	<div class="ctc_add_field_button" style="display:inline-block; margin:10px 0px; cursor:pointer; font-size:16px; border: 1px solid orange; padding: 15px; border-radius:25px;">
		<span style="color: #039be5;" class="dashicons dashicons-plus-alt2" ></span>
		<span style="color: #039be5;">Add Field</span>
	</div>



	<!-- snippets, .... -->
	<div class="ctc_form_snippets" style="display: none;">

		<!-- filed count - field_1 field_2 ... -->
		<input type="text" name="ht_ctc_greetings_pro_1[field_count]" class="ht_ctc_pro_form_field_count" value="<?php echo esc_attr( $field_count ); ?>">

		<!-- snippet: add field -->
		<div class="ht_ctc_pro_field">

			<div class="row">
				<span style="color:#039be5; float:right; cursor:pointer;" class="ht_ctc_pro_form_remove_field_link dashicons dashicons-no-alt" title="Remove Page"></span>
			</div>
			
			<div class="row">
				
				<!-- name: ht_ctc_greetings_pro_1[fields][<field_count>] -->
				<input style="display: none;" type="text" class="ht_ctc_pro_form_field_number" value="<?php echo esc_attr( $field_count ); ?>">

				<div class="input-field col s6">
					<select class="ht_ctc_pro_form_select_field_type browser-default">
						<option value="text">Text </option>
						<option value="email">Email</option>
						<option value="textarea">TextArea (large field)</option>
						<option value="checkbox">Checkbox</option>
						<option value="select">Select</option>
						<option value="date">Date (Beta)</option>
						<option value="number">Number (intl tel input)</option>
						<option value="hidden">Hidden</option>
					</select>
				</div>
				<div class="input-field col s6">
					<div class="g_form_field_type_select" style="margin-bottom: 12px; display:none;">
						<label>Select options (required)</label>
						<textarea class="ht_ctc_pro_form_select_field_selectvalues" placeholder="option 1, option 2, option 3, ..." style="min-height: 88px;"></textarea>
						<p class="description">Add each select option in different line or separate with comma(,).</p>
					</div>
					<div class="g_form_field_type_name">
						<label for=""><?php esc_html_e( 'Field Name', 'click-to-chat-pro' ); ?></label>
						<input class="ht_ctc_pro_form_select_field_name" type="text" placeholder="Name:, Email:, .... ">
					</div>
					<div class="g_form_field_type_placeholder">
						<label for=""><?php esc_html_e( 'Placeholder', 'click-to-chat-pro' ); ?></label>
						<input class="ht_ctc_pro_form_select_field_placeholder" type="text" placeholder="Name, Email, .... ">
					</div>
					<div class="g_form_field_type_time_name ctc_init_display_none ctc_dt_field">
						<label for=""><?php esc_html_e( 'Time Field Name', 'click-to-chat-pro' ); ?></label>
						<input class="ht_ctc_pro_form_select_field_time_name" type="text" placeholder="Time">
					</div>
					<div class="g_form_field_type_hidden" style="<?php echo esc_attr( $hiddenvalue_display_css ); ?>">
						<label for="">Value</label>
						<input class="ht_ctc_pro_form_select_field_hiddenvalue" type="text" placeholder="[gclid]">
					</div>
					<div class="g_form_field_type_checkboxes">
						<div class="g_form_field_type_required">
							<label>
								<input class="ht_ctc_pro_form_select_field_required" type="checkbox" value="1">
								<span>Required</span>
							</label>
						</div>
						<div class="g_form_field_type_add_to_prefilled">
							<label>
								<input class="ht_ctc_pro_form_select_field_add_to_prefilled" type="checkbox" checked value="1">
								<span>Add to Prefilled message</span>
							</label>
						</div>
					</div>

					<!-- display for checkbox field -->
					<div class="ctc_init_display_none g_form_element g_form_element_checbox">
						<p class="description"><a target="_blank" href="https://holithemes.com/plugins/click-to-chat/greetings-form/#checkbox">Add links</a>: e.g. [privacy](https://...)</p>
					</div>
				
					<!-- for number field -->
					<div class="ctc_init_display_none g_form_element g_form_element_number">
						<p class="description"><a href="#intltelinput_settings">Number Field (IntltelInput) settings.</a></p>
						<?php
						if ( defined( 'HT_CTC_FILES_PLUGIN_FILE' ) ) {
							// click to chat files plugin is active
							?>
							<p class="description" style="font-size: 0.8em;">plugin loads Intltel library from the plugin: 'Click to Chat Files' (installed on this website)</p>
							<?php
						} else {
							// load from github using jsDelivr cdn.  (click to chat files plugin is not active)
							?>
							<p class="description" style="font-size: 0.8em;">plugin loads Intltel library hosted at GitHub using jsDelivr cdn</p>
							<?php
						}
						?>
					</div>

					<!-- for hidden field -->
					<div class="ctc_init_display_none g_form_element g_form_element_hidden">
						
						<details style="margin:7px 0px;">
							<summary>Dynamic Variables: cookie: [[]], URL parameters: []</summary>
							<p class="description" style="margin:8px 10px 10px 10px;">
								<strong>Get value from url parameters:</strong> Text with in single square brackets <code>[]</code> will get value from url parameters. if not exists, return blank
								e.g. <code>[gclid]</code>, <code>[utm_source]</code> 
								<br>
								<strong>Get value from cookies:</strong> Text with in double square brackets <code>[[]]</code> will get value from cookies. if not exists, return blank.
								<br> e.g. <code>[[_ga]]</code> 
							</p>
							<a style="margin:15px 10px;" target="_blank" href="https://holithemes.com/plugins/click-to-chat/greetings-form/#hidden">Hidden Field</a>
						</details>
						<!-- todo: at docs.. add id to make this link works .. and uncomment here. -->
						<!-- <a target="_blank" href="#hiddenfield">Hidden filed Values</a> -->
					</div>

					<br>
				</div>
				
			</div>
		</div>


	</div>
	<!-- #END snippets -->

</div>

<br><br>
