( function greetingsInit ( $ ) {

	// ready
	$( function readyHandler () {

		// console.log('greetings.js');

		// intl_languages
		var intl_languages = {
			'default': '',
			'auto': 'AUTO',
			'ar': 'Arabic',
			'bn': 'Bengali',
			'bs': 'Bosnian',
			'bg': 'Bulgarian',
			'ca': 'Catalan',
			'zh': 'Chinese',
			'hr': 'Croatian',
			'cs': 'Czech',
			'nl': 'Dutch',
			'en': 'English',
			'et': 'Estonian',
			'fi': 'Finnish',
			'fr': 'French',
			'de': 'German',
			'el': 'Greek',
			'hi': 'Hindi',
			'hu': 'Hungarian',
			'id': 'Indonesian',
			'it': 'Italian',
			'ja': 'Japanese',
			'ko': 'Korean',
			'mr': 'Marathi',
			'no': 'Norwegian',
			'fa': 'Persian',
			'pl': 'Polish',
			'pt': 'Portuguese',
			'ro': 'Romanian',
			'ru': 'Russian',
			'sk': 'Slovak',
			'es': 'Spanish',
			'sv': 'Swedish',
			'te': 'Telugu',
			'th': 'Thai',
			'tr': 'Turkish',
			'ur': 'Urdu',
			'vi': 'Vietnamese',
		};

		// .intl_languages select .. add options
		var intl_languages_select = $( '.select_intl_language' );
		if ( intl_languages_select.length ) {
			var selected = intl_languages_select.data( 'selected' );
			var options = '';
			$.each( intl_languages, function handleIntlLanguagesEach ( key, value ) {
				// options += '<option value="' + key + '">' + value + '</option>';
				options += '<option value="' + key + '" ' + ( key === selected ? 'selected' : '' ) + '>' + value + '</option>';
			} );

			// console.log(options);
			intl_languages_select.append( options );
		}

		// intl_countries
		var default_auto = {
			'default': '',
			'auto': 'AUTO',
		};

		/**
         * List of all countries with their country codes (use ai tools to sort.. easy..)
         *
         * src/js/i18n/en/countries.ts
         * build/js/intlTelInput.js ..  at var countries_default
         * https://github.com/jackocnr/intl-tel-input/blob/433fe0888f780c52737803a61bbc1be670314633/build/js/intlTelInput.js#L1122
         */
		var countries_list = {
			af: 'Afghanistan',
			ax: 'Åland Islands',
			al: 'Albania',
			dz: 'Algeria',
			as: 'American Samoa',
			ad: 'Andorra',
			ao: 'Angola',
			ai: 'Anguilla',
			aq: 'Antarctica',
			ag: 'Antigua & Barbuda',
			ar: 'Argentina',
			am: 'Armenia',
			aw: 'Aruba',
			au: 'Australia',
			at: 'Austria',
			az: 'Azerbaijan',
			bs: 'Bahamas',
			bh: 'Bahrain',
			bd: 'Bangladesh',
			bb: 'Barbados',
			by: 'Belarus',
			be: 'Belgium',
			bz: 'Belize',
			bj: 'Benin',
			bm: 'Bermuda',
			bt: 'Bhutan',
			bo: 'Bolivia',
			ba: 'Bosnia & Herzegovina',
			bw: 'Botswana',
			bv: 'Bouvet Island',
			br: 'Brazil',
			io: 'British Indian Ocean Territory',
			vg: 'British Virgin Islands',
			bn: 'Brunei',
			bg: 'Bulgaria',
			bf: 'Burkina Faso',
			bi: 'Burundi',
			cv: 'Cape Verde',
			kh: 'Cambodia',
			cm: 'Cameroon',
			ca: 'Canada',
			ky: 'Cayman Islands',
			cf: 'Central African Republic',
			td: 'Chad',
			cl: 'Chile',
			cn: 'China',
			cx: 'Christmas Island',
			cc: 'Cocos (Keeling) Islands',
			co: 'Colombia',
			km: 'Comoros',
			cg: 'Congo - Brazzaville',
			cd: 'Congo - Kinshasa',
			ck: 'Cook Islands',
			cr: 'Costa Rica',
			hr: 'Croatia',
			cu: 'Cuba',
			cw: 'Curaçao',
			cy: 'Cyprus',
			cz: 'Czechia',
			dk: 'Denmark',
			dj: 'Djibouti',
			dm: 'Dominica',
			do: 'Dominican Republic',
			ec: 'Ecuador',
			eg: 'Egypt',
			sv: 'El Salvador',
			gq: 'Equatorial Guinea',
			er: 'Eritrea',
			ee: 'Estonia',
			sz: 'Eswatini',
			et: 'Ethiopia',
			fk: 'Falkland Islands',
			fo: 'Faroe Islands',
			fj: 'Fiji',
			fi: 'Finland',
			fr: 'France',
			gf: 'French Guiana',
			pf: 'French Polynesia',
			tf: 'French Southern Territories',
			ga: 'Gabon',
			gm: 'Gambia',
			ge: 'Georgia',
			de: 'Germany',
			gh: 'Ghana',
			gi: 'Gibraltar',
			gr: 'Greece',
			gl: 'Greenland',
			gd: 'Grenada',
			gp: 'Guadeloupe',
			gu: 'Guam',
			gt: 'Guatemala',
			gg: 'Guernsey',
			gn: 'Guinea',
			gw: 'Guinea-Bissau',
			gy: 'Guyana',
			ht: 'Haiti',
			hm: 'Heard & McDonald Islands',
			hn: 'Honduras',
			hk: 'Hong Kong SAR China',
			hu: 'Hungary',
			is: 'Iceland',
			in: 'India',
			id: 'Indonesia',
			ir: 'Iran',
			iq: 'Iraq',
			ie: 'Ireland',
			im: 'Isle of Man',
			il: 'Israel',
			it: 'Italy',
			ci: 'Côte d’Ivoire',
			jm: 'Jamaica',
			jp: 'Japan',
			je: 'Jersey',
			jo: 'Jordan',
			kz: 'Kazakhstan',
			ke: 'Kenya',
			ki: 'Kiribati',
			kp: 'North Korea',
			kr: 'South Korea',
			kw: 'Kuwait',
			kg: 'Kyrgyzstan',
			la: 'Laos',
			lv: 'Latvia',
			lb: 'Lebanon',
			ls: 'Lesotho',
			lr: 'Liberia',
			ly: 'Libya',
			li: 'Liechtenstein',
			lt: 'Lithuania',
			lu: 'Luxembourg',
			mo: 'Macao SAR China',
			mg: 'Madagascar',
			mw: 'Malawi',
			my: 'Malaysia',
			mv: 'Maldives',
			ml: 'Mali',
			mt: 'Malta',
			mh: 'Marshall Islands',
			mq: 'Martinique',
			mr: 'Mauritania',
			mu: 'Mauritius',
			yt: 'Mayotte',
			mx: 'Mexico',
			fm: 'Micronesia',
			md: 'Moldova',
			mc: 'Monaco',
			mn: 'Mongolia',
			me: 'Montenegro',
			ms: 'Montserrat',
			ma: 'Morocco',
			mz: 'Mozambique',
			mm: 'Myanmar (Burma)',
			na: 'Namibia',
			nr: 'Nauru',
			np: 'Nepal',
			nl: 'Netherlands',
			nc: 'New Caledonia',
			nz: 'New Zealand',
			ni: 'Nicaragua',
			ne: 'Niger',
			ng: 'Nigeria',
			nu: 'Niue',
			nf: 'Norfolk Island',
			mk: 'North Macedonia',
			mp: 'Northern Mariana Islands',
			no: 'Norway',
			om: 'Oman',
			pk: 'Pakistan',
			pw: 'Palau',
			ps: 'Palestinian Territories',
			pa: 'Panama',
			pg: 'Papua New Guinea',
			py: 'Paraguay',
			pe: 'Peru',
			ph: 'Philippines',
			pn: 'Pitcairn Islands',
			pl: 'Poland',
			pt: 'Portugal',
			pr: 'Puerto Rico',
			qa: 'Qatar',
			re: 'Réunion',
			ro: 'Romania',
			ru: 'Russia',
			rw: 'Rwanda',
			bl: 'St. Barthélemy',
			sh: 'St. Helena',
			kn: 'St. Kitts & Nevis',
			lc: 'St. Lucia',
			mf: 'St. Martin',
			pm: 'St. Pierre & Miquelon',
			vc: 'St. Vincent & Grenadines',
			ws: 'Samoa',
			sm: 'San Marino',
			st: 'São Tomé & Príncipe',
			sa: 'Saudi Arabia',
			sn: 'Senegal',
			rs: 'Serbia',
			sc: 'Seychelles',
			sl: 'Sierra Leone',
			sg: 'Singapore',
			sx: 'Sint Maarten',
			sk: 'Slovakia',
			si: 'Slovenia',
			sb: 'Solomon Islands',
			so: 'Somalia',
			za: 'South Africa',
			gs: 'South Georgia & South Sandwich Islands',
			ss: 'South Sudan',
			es: 'Spain',
			lk: 'Sri Lanka',
			sd: 'Sudan',
			sr: 'Suriname',
			sj: 'Svalbard & Jan Mayen',
			se: 'Sweden',
			ch: 'Switzerland',
			sy: 'Syria',
			tw: 'Taiwan',
			tj: 'Tajikistan',
			tz: 'Tanzania',
			th: 'Thailand',
			tl: 'Timor-Leste',
			tg: 'Togo',
			tk: 'Tokelau',
			to: 'Tonga',
			tt: 'Trinidad & Tobago',
			tn: 'Tunisia',
			tr: 'Turkey',
			tm: 'Turkmenistan',
			tc: 'Turks & Caicos Islands',
			tv: 'Tuvalu',
			ug: 'Uganda',
			ua: 'Ukraine',
			ae: 'United Arab Emirates',
			gb: 'United Kingdom',
			us: 'United States',
			um: 'U.S. Outlying Islands',
			vi: 'U.S. Virgin Islands',
			uy: 'Uruguay',
			uz: 'Uzbekistan',
			vu: 'Vanuatu',
			va: 'Vatican City',
			ve: 'Venezuela',
			vn: 'Vietnam',
			wf: 'Wallis & Futuna',
			eh: 'Western Sahara',
			ye: 'Yemen',
			zm: 'Zambia',
			zw: 'Zimbabwe',
		};

		// default_auto + countries_list
		var intl_countries = Object.assign( default_auto, countries_list );

		// var intl_countries = {
		//     ...default_auto,
		//     ...countries_list
		// };

		// .intl_initial_country select .. add options
		var intl_initial_country = $( '.select_intl_initial_country' );

		// console.log(intl_initial_country);
		if ( intl_initial_country.length ) {
			var selected = intl_initial_country.data( 'selected' );

			// console.log('selected: ' + selected);
			var options = '';
			$.each( intl_countries, function handleIntlCountriesEach ( key, value ) {
				// options += '<option value="' + key + '">' + value + '</option>';
				options += '<option value="' + key + '" ' + ( key === selected ? 'selected' : '' ) + '>' + value + '</option>';
			} );

			// console.log(options);
			intl_initial_country.append( options );
		}

	} );

} )( jQuery );
