(function ($) {
    "use strict";
    var G5PlusExpandable = {
        init: function () {
            if($('.expandable-container').length){
                $('.expandable-container').each(function(){
                    var $this = $(this);
                    var $more_label = 'VIEW MORE';
                    if($(this).find('.expandable-button').data('moretext') !== ""){
                        $more_label = $(this).find('.expandable-button').data('moretext');
                    }
                    var $less_label = 'VIEW LESS';
                    if($(this).find('.expandable-button').data('lesstext') !== ""){
                        $less_label = $(this).find('.expandable-button').data('lesstext');
                    }
                    $this.find('.expandable-button').on("mouseenter",function(){
                        $(this).css('color',$(this).data('hovercolor'));
                    }).on("mouseleave",function() {
                        if(!$this.find('.expandable-content').is(':visible')){
                            $(this).css('color',$(this).data('color'));
                        }
                    });

                    $this.find('.expandable-button').click(function(){
                        if(!$this.find('.expandable-content').is(':visible')){
                            $(this).find('span').text($less_label);
                            $(this).find('i').addClass('rotate-arrow');
                        } else {
                            if(!$this.find('.expandable-button').is(":hover")){
                                $this.find('.expandable-button').css('color',$this.find('.expandable-button').data('color'));
                            }
                            $(this).find('span').text($more_label);
                            $(this).find('i').removeClass('rotate-arrow');
                        }
                    });
                });
            }
        }
    };
    $(document).ready(G5PlusExpandable.init);
})(jQuery);