<?php
/**
 * Created by PhpStorm.
 * User: phuongth
 * Date: 1/21/2016
 * Time: 5:33 PM
 */

$args_term = array(
    'orderby' => 'term_order',
    'order' => 'ASC',
    'pad_counts' => true,
    'hide_empty' => false,
);
$terms = get_terms('product_cat', $args_term);
$data_id =  uniqid();
?>
<div class="course-search simple style01 p-bg">
    <div class="title-wrap p-font p-bg-dark">
        <div class="title">
        <span>
            <?php esc_html_e('Search for','g5plus-academia') ?>
        </span>
        <span>
            <?php esc_html_e('Course','g5plus-academia') ?>
        </span>
        <span>
            <?php esc_html_e('and Sign Up','g5plus-academia') ?>
        </span>
        </div>
    </div>
    <div class="keyword-wrap" id="<?php echo esc_attr($data_id) ?>">
        <div class="keyword">
            <form method="get" id="searchform" action="<?php echo home_url( '/' ); ?>">

                    <label for="location">Location
                    <select id="location" class="search-field-location"name="location">
                        <option value=""><?php esc_html_e('All', 'g5plus-academia') ?></option>
                        <?php
                        $locations = get_course_location();
                        foreach($locations as $location){
                        ?>
                            <option value="<?php echo esc_attr($location) ?>"><?php echo wp_kses_post($location) ?></option>
                        <?php } ?>
                    </select>
                    </label>

                    <label for="level">Level
                    <select id="level" class="search-field-level" name="level">
                        <option value=""><?php esc_html_e('All', 'g5plus-academia') ?></option>
                        <?php
                        $levels = get_course_level();
                            foreach($levels as $level) {
                                if ($level == '')
                                    continue;
                        ?>
                            <option value="<?php echo esc_attr($level) ?>"><?php echo wp_kses_post($level) ?></option>
                        <?php } ?>
                    </select>
                    </label>

                    <label for="category">Session
                    <select id="category" class="search-field-category" name="product_cat">
                        <option value=""><?php esc_html_e('All', 'g5plus-academia') ?></option>
                        <?php
                        foreach($terms as $category ){
                            if ($category->slug == 'beginner-validation' or $category->slug == 'uncategorized')
                                continue;
                        ?>
                            <option value="<?php echo esc_attr($category->slug) ?>"><?php echo wp_kses_post($category->name) ?></option>
                        <?php } ?>
                    </select>
                    </label>

                    <label for="month">Month
                    <select id="month" class="search-field-month"name="month">
                        <option value=""><?php esc_html_e('All', 'g5plus-academia') ?></option>
                        <?php
                        $months = rtm_get_course_months();
                        ksort($months);
                        foreach($months as $index => $month){
                        ?>
                            <option value="<?php echo esc_attr($index) ?>"><?php echo wp_kses_post($month) ?></option>
                        <?php } ?>
                    </select>
                    </label>

                <input type="hidden" id="post_type" name="post_type" value="product">
                <input type="hidden" id="view" name="view" value="view-list">
                <button type="submit" class="s-bg">Search<i class="fa fa-search"></i></button>
            </form>

        </div>

    </div>
</div>
