<?php


namespace RTMTrade\OpenCart\AdminApi\Model;


class Zone
{

    private int $id;
    private int $countryId;
    private ?string $name;
    private ?string $code;
    private bool $status;

    /**
     * Zone constructor.
     * @param int $id
     * @param int $countryId
     * @param string|null $name
     * @param string|null $code
     * @param bool $status
     */
    public function __construct(int $id, int $countryId, ?string $name, ?string $code, bool $status)
    {
        $this->id = $id;
        $this->countryId = $countryId;
        $this->name = $name;
        $this->code = $code;
        $this->status = $status;
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @param int $id
     * @return Zone
     */
    public function setId(int $id): Zone
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return int
     */
    public function getCountryId(): int
    {
        return $this->countryId;
    }

    /**
     * @param int $countryId
     * @return Zone
     */
    public function setCountryId(int $countryId): Zone
    {
        $this->countryId = $countryId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     * @return Zone
     */
    public function setName(?string $name): Zone
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCode(): ?string
    {
        return $this->code;
    }

    /**
     * @param string|null $code
     * @return Zone
     */
    public function setCode(?string $code): Zone
    {
        $this->code = $code;
        return $this;
    }

    /**
     * @return bool
     */
    public function isStatus(): bool
    {
        return $this->status;
    }

    /**
     * @param bool $status
     * @return Zone
     */
    public function setStatus(bool $status): Zone
    {
        $this->status = $status;
        return $this;
    }


}