<?php

namespace RTMTrade\OpenCart\AdminApi\Model;

/**
 * Class ProductOptionValue
 * @package RTMTrade\OpenCart\AdminApi\Model
 * @author Beau Fiechter (RTM Business)
 * @link https://gitlab.rtmbusiness.nl/spyder/opencart-admin-api-php
 */
class ProductOptionValue
{

    /**
     * The ID of the ProductOptionValue (Coupled to ProductOption)
     * product_option_value_id
     * @var int|null
     */
    private ?int $id;

    /**
     * The ID of the OptionValue
     *
     * option_value_id
     * @var int|null
     */
    private ?int $optionValueId;

    private ?string $image;

    private ?string $name;
    private ?string $model;
    private ?string $ean;
    private ?string $sku;
    private ?string $upc;

    private ?float $price;
    private ?string $pricePrefix;
    private ?string $priceFormatted;

    /**
     * Whether to subtract from stock on order
     * @var bool|null
     */
    private ?bool $subtract;

    private ?int $points;
    private ?string $pointsPrefix;

    private ?string $weight;
    private ?string $weightPrefix;

    private ?int $quantity;

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return ProductOptionValue
     */
    public function setId(?int $id): ProductOptionValue
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getOptionValueId(): ?int
    {
        return $this->optionValueId;
    }

    /**
     * @param int|null $optionValueId
     * @return ProductOptionValue
     */
    public function setOptionValueId(?int $optionValueId): ProductOptionValue
    {
        $this->optionValueId = $optionValueId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getImage(): ?string
    {
        return $this->image;
    }

    /**
     * @param string|null $image
     * @return ProductOptionValue
     */
    public function setImage(?string $image): ProductOptionValue
    {
        $this->image = $image;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     * @return ProductOptionValue
     */
    public function setName(?string $name): ProductOptionValue
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEan(): ?string
    {
        return $this->ean;
    }

    /**
     * @param string|null $ean
     * @return ProductOptionValue
     */
    public function setEan(?string $ean): ProductOptionValue
    {
        $this->ean = $ean;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getPrice(): ?float
    {
        return $this->price;
    }

    /**
     * @param float|null $price
     * @return ProductOptionValue
     */
    public function setPrice(?float $price): ProductOptionValue
    {
        $this->price = $price;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPricePrefix(): ?string
    {
        return $this->pricePrefix;
    }

    /**
     * @param string|null $pricePrefix
     * @return ProductOptionValue
     */
    public function setPricePrefix(?string $pricePrefix): ProductOptionValue
    {
        $this->pricePrefix = $pricePrefix;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPriceFormatted(): ?string
    {
        return $this->priceFormatted;
    }

    /**
     * @param string|null $priceFormatted
     * @return ProductOptionValue
     */
    public function setPriceFormatted(?string $priceFormatted): ProductOptionValue
    {
        $this->priceFormatted = $priceFormatted;
        return $this;
    }

    /**
     * @return bool|null
     */
    public function getSubtract(): ?bool
    {
        return $this->subtract;
    }

    /**
     * @param bool|null $subtract
     * @return ProductOptionValue
     */
    public function setSubtract(?bool $subtract): ProductOptionValue
    {
        $this->subtract = $subtract;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getPoints(): ?int
    {
        return $this->points;
    }

    /**
     * @param int|null $points
     * @return ProductOptionValue
     */
    public function setPoints(?int $points): ProductOptionValue
    {
        $this->points = $points;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPointsPrefix(): ?string
    {
        return $this->pointsPrefix;
    }

    /**
     * @param string|null $pointsPrefix
     * @return ProductOptionValue
     */
    public function setPointsPrefix(?string $pointsPrefix): ProductOptionValue
    {
        $this->pointsPrefix = $pointsPrefix;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getWeight(): ?string
    {
        return $this->weight;
    }

    /**
     * @param string|null $weight
     * @return ProductOptionValue
     */
    public function setWeight(?string $weight): ProductOptionValue
    {
        $this->weight = $weight;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getWeightPrefix(): ?string
    {
        return $this->weightPrefix;
    }

    /**
     * @param string|null $weightPrefix
     * @return ProductOptionValue
     */
    public function setWeightPrefix(?string $weightPrefix): ProductOptionValue
    {
        $this->weightPrefix = $weightPrefix;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getQuantity(): ?int
    {
        return $this->quantity;
    }

    /**
     * @param int|null $quantity
     * @return ProductOptionValue
     */
    public function setQuantity(?int $quantity): ProductOptionValue
    {
        $this->quantity = $quantity;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getModel(): ?string
    {
        return $this->model;
    }

    /**
     * @param string|null $model
     * @return ProductOptionValue
     */
    public function setModel(?string $model): ProductOptionValue
    {
        $this->model = $model;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSku(): ?string
    {
        return $this->sku;
    }

    /**
     * @param string|null $sku
     * @return ProductOptionValue
     */
    public function setSku(?string $sku): ProductOptionValue
    {
        $this->sku = $sku;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getUpc(): ?string
    {
        return $this->upc;
    }

    /**
     * @param string|null $upc
     * @return ProductOptionValue
     */
    public function setUpc(?string $upc): ProductOptionValue
    {
        $this->upc = $upc;
        return $this;
    }

}


