<?php


namespace RTMTrade\OpenCart\AdminApi\Model;


use DateTime;

/**
 * Class OrderStatusHistory
 * @package RTMTrade\OpenCart\AdminApi\Model
 * @author Beau Fiechter (RTM Business)
 * @link https://gitlab.rtmbusiness.nl/spyder/opencart-admin-api-php
 */
class OrderStatusHistory
{

    private ?int $id;
    private ?int $orderStatusId;
    private ?bool $notify;
    private ?string $status;
    private ?string $comment;
    private ?DateTime $dateAdded;

    /**
     * OrderStatusHistory constructor.
     * @param int|null $id
     * @param int|null $orderStatusId
     * @param bool|null $notify
     * @param string|null $status
     * @param string|null $comment
     * @param DateTime|null $dateAdded
     */
    public function __construct(?int      $id = null,
                                ?int      $orderStatusId = null,
                                ?bool     $notify = null,
                                ?string   $status = null,
                                ?string   $comment = null,
                                ?DateTime $dateAdded = null)
    {
        $this->id = $id;
        $this->orderStatusId = $orderStatusId;
        $this->notify = $notify;
        $this->status = $status;
        $this->comment = $comment;
        $this->dateAdded = $dateAdded;
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return OrderStatusHistory
     */
    public function setId(?int $id): OrderStatusHistory
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getOrderStatusId(): ?int
    {
        return $this->orderStatusId;
    }

    /**
     * @param int|null $orderStatusId
     * @return OrderStatusHistory
     */
    public function setOrderStatusId(?int $orderStatusId): OrderStatusHistory
    {
        $this->orderStatusId = $orderStatusId;
        return $this;
    }


    /**
     * @return bool|null
     */
    public function getNotify(): ?bool
    {
        return $this->notify;
    }

    /**
     * @param bool|null $notify
     * @return OrderStatusHistory
     */
    public function setNotify(?bool $notify): OrderStatusHistory
    {
        $this->notify = $notify;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * @param string|null $status
     * @return OrderStatusHistory
     */
    public function setStatus(?string $status): OrderStatusHistory
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getComment(): ?string
    {
        return $this->comment;
    }

    /**
     * @param string|null $comment
     * @return OrderStatusHistory
     */
    public function setComment(?string $comment): OrderStatusHistory
    {
        $this->comment = $comment;
        return $this;
    }

    /**
     * @return DateTime|null
     */
    public function getDateAdded(): ?DateTime
    {
        return $this->dateAdded;
    }

    /**
     * @param DateTime|null $dateAdded
     * @return OrderStatusHistory
     */
    public function setDateAdded(?DateTime $dateAdded): OrderStatusHistory
    {
        $this->dateAdded = $dateAdded;
        return $this;
    }


}