<?php

namespace RTMTrade\OpenCart\AdminApi\Model;

class OrderProduct
{
    private ?int $id;
    private ?int $productId;
    private ?int $quantity;
    /**
     * @var OrderProductOption[]
     */
    private array $options;
    private ?string $name;
    private ?string $model;
    private ?string $sku;
    private ?int $taxClassId;
    private ?string $currencyCode;
    private ?string $currencyValue;
    private ?string $priceFormatted;
    private ?float $price;
    private ?float $priceExcludeTax;
    private ?float $tax;
    private ?string $totalFormatted;
    private ?float $total;
    private ?float $totalExcludeTax;
    private ?float $totalTax;

    /**
     * OrderProduct constructor.
     * @param int|null $productId
     * @param int|null $quantity
     * @param int|null $orderProductId
     * @param array $option
     * @param string|null $name
     * @param string|null $model
     * @param string|null $sku
     * @param int|null $taxClassId
     * @param string|null $currencyCode
     * @param string|null $currencyValue
     * @param string|null $priceFormatted
     * @param float|null $price
     * @param float|null $priceExcludeTax
     * @param float|null $tax
     * @param string|null $totalFormatted
     * @param float|null $total
     * @param float|null $totalExcludeTax
     * @param float|null $totalTax
     */
    public function __construct(?int $productId = null,
                                ?int $quantity = null,
                                ?int $orderProductId = null,
                                array $option = [],
                                ?string $name = null,
                                ?string $model = null,
                                ?string $sku = null,
                                ?int $taxClassId = null,
                                ?string $currencyCode = null,
                                ?string $currencyValue = null,
                                ?string $priceFormatted = null,
                                ?float $price = null,
                                ?float $priceExcludeTax = null,
                                ?float $tax = null,
                                ?string $totalFormatted = null,
                                ?float $total = null,
                                ?float $totalExcludeTax = null,
                                ?float $totalTax = null)
    {
        $this->productId = $productId;
        $this->quantity = $quantity;
        $this->id = $orderProductId;
        $this->options = $option;
        $this->name = $name;
        $this->model = $model;
        $this->sku = $sku;
        $this->taxClassId = $taxClassId;
        $this->currencyCode = $currencyCode;
        $this->currencyValue = $currencyValue;
        $this->priceFormatted = $priceFormatted;
        $this->price = $price;
        $this->priceExcludeTax = $priceExcludeTax;
        $this->tax = $tax;
        $this->totalFormatted = $totalFormatted;
        $this->total = $total;
        $this->totalExcludeTax = $totalExcludeTax;
        $this->totalTax = $totalTax;
    }

    /**
     * @return int|null
     */
    public function getProductId(): ?int
    {
        return $this->productId;
    }

    /**
     * @param int|null $productId
     * @return OrderProduct
     */
    public function setProductId(?int $productId): OrderProduct
    {
        $this->productId = $productId;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getQuantity(): ?int
    {
        return $this->quantity;
    }

    /**
     * @param int|null $quantity
     * @return OrderProduct
     */
    public function setQuantity(?int $quantity): OrderProduct
    {
        $this->quantity = $quantity;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return OrderProduct
     */
    public function setId(?int $id): OrderProduct
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return OrderProductOption[]
     */
    public function getOptions(): array
    {
        return $this->options;
    }

    /**
     * @param OrderProductOption[] $options
     * @return OrderProduct
     */
    public function setOptions(array $options): OrderProduct
    {
        $this->options = $options;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     * @return OrderProduct
     */
    public function setName(?string $name): OrderProduct
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getModel(): ?string
    {
        return $this->model;
    }

    /**
     * @param string|null $model
     * @return OrderProduct
     */
    public function setModel(?string $model): OrderProduct
    {
        $this->model = $model;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSku(): ?string
    {
        return $this->sku;
    }

    /**
     * @param string|null $sku
     * @return OrderProduct
     */
    public function setSku(?string $sku): OrderProduct
    {
        $this->sku = $sku;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getTaxClassId(): ?int
    {
        return $this->taxClassId;
    }

    /**
     * @param int|null $taxClassId
     * @return OrderProduct
     */
    public function setTaxClassId(?int $taxClassId): OrderProduct
    {
        $this->taxClassId = $taxClassId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCurrencyCode(): ?string
    {
        return $this->currencyCode;
    }

    /**
     * @param string|null $currencyCode
     * @return OrderProduct
     */
    public function setCurrencyCode(?string $currencyCode): OrderProduct
    {
        $this->currencyCode = $currencyCode;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCurrencyValue(): ?string
    {
        return $this->currencyValue;
    }

    /**
     * @param string|null $currencyValue
     * @return OrderProduct
     */
    public function setCurrencyValue(?string $currencyValue): OrderProduct
    {
        $this->currencyValue = $currencyValue;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPriceFormatted(): ?string
    {
        return $this->priceFormatted;
    }

    /**
     * @param string|null $priceFormatted
     * @return OrderProduct
     */
    public function setPriceFormatted(?string $priceFormatted): OrderProduct
    {
        $this->priceFormatted = $priceFormatted;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getPrice(): ?float
    {
        return $this->price;
    }

    /**
     * @param float|null $price
     * @return OrderProduct
     */
    public function setPrice(?float $price): OrderProduct
    {
        $this->price = $price;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getPriceExcludeTax(): ?float
    {
        return $this->priceExcludeTax;
    }

    /**
     * @param float|null $priceExcludeTax
     * @return OrderProduct
     */
    public function setPriceExcludeTax(?float $priceExcludeTax): OrderProduct
    {
        $this->priceExcludeTax = $priceExcludeTax;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getTax(): ?float
    {
        return $this->tax;
    }

    /**
     * @param float|null $tax
     * @return OrderProduct
     */
    public function setTax(?float $tax): OrderProduct
    {
        $this->tax = $tax;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getTotalFormatted(): ?string
    {
        return $this->totalFormatted;
    }

    /**
     * @param string|null $totalFormatted
     * @return OrderProduct
     */
    public function setTotalFormatted(?string $totalFormatted): OrderProduct
    {
        $this->totalFormatted = $totalFormatted;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getTotal(): ?float
    {
        return $this->total;
    }

    /**
     * @param float|null $total
     * @return OrderProduct
     */
    public function setTotal(?float $total): OrderProduct
    {
        $this->total = $total;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getTotalExcludeTax(): ?float
    {
        return $this->totalExcludeTax;
    }

    /**
     * @param float|null $totalExcludeTax
     * @return OrderProduct
     */
    public function setTotalExcludeTax(?float $totalExcludeTax): OrderProduct
    {
        $this->totalExcludeTax = $totalExcludeTax;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getTotalTax(): ?float
    {
        return $this->totalTax;
    }

    /**
     * @param float|null $totalTax
     * @return OrderProduct
     */
    public function setTotalTax(?float $totalTax): OrderProduct
    {
        $this->totalTax = $totalTax;
        return $this;
    }


}


