<?php


namespace RTMTrade\OpenCart\AdminApi\Model;

/**
 * Class OrderHttpInfo
 * @package RTMTrade\OpenCart\AdminApi\Model
 * @author Beau Fiechter (RTM Business)
 * @link https://gitlab.rtmbusiness.nl/spyder/opencart-admin-api-php
 */
class OrderHttpInfo
{

    private ?string $ip;
    private ?string $forwardedIp;
    private ?string $userAgent;
    private ?string $acceptLanguage;

    /**
     * OrderHttpInfo constructor.
     * @param string|null $ip
     * @param string|null $forwardedIp
     * @param string|null $userAgent
     * @param string|null $acceptLanguage
     */
    public function __construct(?string $ip = null,
                                ?string $forwardedIp = null,
                                ?string $userAgent = null,
                                ?string $acceptLanguage = null)
    {
        $this->ip = $ip;
        $this->forwardedIp = $forwardedIp;
        $this->userAgent = $userAgent;
        $this->acceptLanguage = $acceptLanguage;
    }


    /**
     * @return string|null
     */
    public function getIp(): ?string
    {
        return $this->ip;
    }

    /**
     * @param string|null $ip
     * @return OrderHttpInfo
     */
    public function setIp(?string $ip): OrderHttpInfo
    {
        $this->ip = $ip;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getForwardedIp(): ?string
    {
        return $this->forwardedIp;
    }

    /**
     * @param string|null $forwardedIp
     * @return OrderHttpInfo
     */
    public function setForwardedIp(?string $forwardedIp): OrderHttpInfo
    {
        $this->forwardedIp = $forwardedIp;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getUserAgent(): ?string
    {
        return $this->userAgent;
    }

    /**
     * @param string|null $userAgent
     * @return OrderHttpInfo
     */
    public function setUserAgent(?string $userAgent): OrderHttpInfo
    {
        $this->userAgent = $userAgent;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAcceptLanguage(): ?string
    {
        return $this->acceptLanguage;
    }

    /**
     * @param string|null $acceptLanguage
     * @return OrderHttpInfo
     */
    public function setAcceptLanguage(?string $acceptLanguage): OrderHttpInfo
    {
        $this->acceptLanguage = $acceptLanguage;
        return $this;
    }

}