<?php


namespace RTMTrade\OpenCart\AdminApi\Model;


class OptionValue
{

    private $id;
    /**
     * @var MetaDescription[]
     */
    private array $description;

    private string $image;
    private string $thumb;
    private int $sortOrder;

    /**
     * OptionValue constructor.
     * @param $id
     * @param MetaDescription[] $description
     * @param string $image
     * @param string $thumb
     * @param int $sortOrder
     */
    public function __construct($id, array $description, string $image, string $thumb, int $sortOrder)
    {
        $this->id = $id;
        $this->description = $description;
        $this->image = $image;
        $this->thumb = $thumb;
        $this->sortOrder = $sortOrder;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     * @return OptionValue
     */
    public function setId($id): OptionValue
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return MetaDescription[]
     */
    public function getDescription(): array
    {
        return $this->description;
    }

    /**
     * @param MetaDescription[] $description
     * @return OptionValue
     */
    public function setDescription(array $description): OptionValue
    {
        $this->description = $description;
        return $this;
    }

    /**
     * @return string
     */
    public function getImage(): string
    {
        return $this->image;
    }

    /**
     * @param string $image
     * @return OptionValue
     */
    public function setImage(string $image): OptionValue
    {
        $this->image = $image;
        return $this;
    }

    /**
     * @return string
     */
    public function getThumb(): string
    {
        return $this->thumb;
    }

    /**
     * @param string $thumb
     * @return OptionValue
     */
    public function setThumb(string $thumb): OptionValue
    {
        $this->thumb = $thumb;
        return $this;
    }

    /**
     * @return int
     */
    public function getSortOrder(): int
    {
        return $this->sortOrder;
    }

    /**
     * @param int $sortOrder
     * @return OptionValue
     */
    public function setSortOrder(int $sortOrder): OptionValue
    {
        $this->sortOrder = $sortOrder;
        return $this;
    }


}