<?php
/**
 * ProductOption
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Documentation of Opencart Rest Admin Api (OAuth version)
 *
 * For this demo, first you have to call the `Token` service to get an access token.<br>Then click on the `Authorize` button and set the Bearer Token, for example: <strong>`Bearer 7487c50afc37dbf6e5a484dc49c363128036c356`</strong>.<br>Please do not forget the `Bearer` part, if you forget it, then you will get `Malformed auth header` error.<br>Then you have to call the `User` &rArr; `Login` service before you can access the other services.<br><div class=\"main_steps\">First step - Get access token</div><span class=\"method\">POST</span> <span class=\"links\">/oauth2/token/client_credentials</span> The received token needs to be added to every API call.<br><br><div class=\"main_steps\">Second step - Login user</div><span class=\"method\">POST</span> <span class=\"links\">/api/rest_admin/login</span> After successful login you can access the REST API services
 *
 * The version of the OpenAPI document: 1.0
 *
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.0-beta
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace RTMTrade\OpenCart\AdminApi\Model;

/**
 * ProductOption Class Doc Comment
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class Option
{
    private string $type;
    private int $optionId;
    private int $sortOrder;
    private string $name;
    private string $description;
    /**
     * @var OptionValue[]
     */
    private array $optionValue;

    /**
     * ProductOption constructor.
     * @param string $type
     * @param int $optionId
     * @param int $sortOrder
     * @param string $name
     * @param string $description
     * @param ProductOptionValue[] $optionValue
     */
    public function __construct(string $type, int $optionId, int $sortOrder, string $name, string $description, array $optionValue)
    {
        $this->type = $type;
        $this->optionId = $optionId;
        $this->sortOrder = $sortOrder;
        $this->name = $name;
        $this->description = $description;
        $this->optionValue = $optionValue;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @param string $type
     * @return Option
     */
    public function setType(string $type): Option
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return int
     */
    public function getOptionId(): int
    {
        return $this->optionId;
    }

    /**
     * @param int $optionId
     * @return Option
     */
    public function setOptionId(int $optionId): Option
    {
        $this->optionId = $optionId;
        return $this;
    }

    /**
     * @return int
     */
    public function getSortOrder(): int
    {
        return $this->sortOrder;
    }

    /**
     * @param int $sortOrder
     * @return Option
     */
    public function setSortOrder(int $sortOrder): Option
    {
        $this->sortOrder = $sortOrder;
        return $this;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return Option
     */
    public function setName(string $name): Option
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getDescription(): string
    {
        return $this->description;
    }

    /**
     * @param string $description
     * @return Option
     */
    public function setDescription(string $description): Option
    {
        $this->description = $description;
        return $this;
    }

    /**
     * @return ProductOptionValue[]
     */
    public function getOptionValue(): array
    {
        return $this->optionValue;
    }

    /**
     * @param ProductOptionValue[] $optionValue
     * @return Option
     */
    public function setOptionValue(array $optionValue): Option
    {
        $this->optionValue = $optionValue;
        return $this;
    }


}


