<?php


namespace RTMTrade\OpenCart\AdminApi\Model;

/**
 * Class Address
 * @package RTMTrade\OpenCart\AdminApi\Model
 * @author Beau Fiechter (RTM Business)
 * @link https://gitlab.rtmbusiness.nl/spyder/opencart-admin-api-php
 */
class Address
{

    private ?int $id;
    private ?string $firstname;
    private ?string $lastname;
    private ?string $company;
    private ?string $address1;
    private ?string $address2;
    private ?string $postcode;
    private ?string $city;
    private ?int $zoneId;
    private ?string $zone;
    private ?string $zoneCode;
    private ?int $countryId;
    private ?string $country;
    private ?string $isoCode2;
    private ?string $isoCode3;
    private ?string $addressFormat;

    private array $customFields;

    /**
     * Address constructor.
     * @param string|null $firstname
     * @param string|null $lastname
     * @param string|null $company
     * @param string|null $address1
     * @param string|null $address2
     * @param string|null $postcode
     * @param string|null $city
     * @param int|null $zoneId
     * @param string|null $zone
     * @param string|null $zoneCode
     * @param int|null $countryId
     * @param string|null $country
     * @param string|null $isoCode2
     * @param string|null $isoCode3
     * @param string|null $addressFormat
     * @param array $customField
     */
    public function __construct(?int    $id = null,
                                ?string $firstname = null,
                                ?string $lastname = null,
                                ?string $company = null,
                                ?string $address1 = null,
                                ?string $address2 = null,
                                ?string $postcode = null,
                                ?string $city = null,
                                ?int    $zoneId = null,
                                ?string $zone = null,
                                ?string $zoneCode = null,
                                ?int    $countryId = null,
                                ?string $country = null,
                                ?string $isoCode2 = null,
                                ?string $isoCode3 = null,
                                ?string $addressFormat = null,
                                array   $customField = [])
    {
        $this->id = $id;
        $this->firstname = $firstname;
        $this->lastname = $lastname;
        $this->company = $company;
        $this->address1 = $address1;
        $this->address2 = $address2;
        $this->postcode = $postcode;
        $this->city = $city;
        $this->zoneId = $zoneId;
        $this->zone = $zone;
        $this->zoneCode = $zoneCode;
        $this->countryId = $countryId;
        $this->country = $country;
        $this->isoCode2 = $isoCode2;
        $this->isoCode3 = $isoCode3;
        $this->addressFormat = $addressFormat;
        $this->customFields = $customField;
    }

    /**
     * @return string|null
     */
    public function getFirstname(): ?string
    {
        return $this->firstname;
    }

    /**
     * @param string|null $firstname
     * @return Address
     */
    public function setFirstname(?string $firstname): Address
    {
        $this->firstname = $firstname;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getLastname(): ?string
    {
        return $this->lastname;
    }

    /**
     * @param string|null $lastname
     * @return Address
     */
    public function setLastname(?string $lastname): Address
    {
        $this->lastname = $lastname;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCompany(): ?string
    {
        return $this->company;
    }

    /**
     * @param string|null $company
     * @return Address
     */
    public function setCompany(?string $company): Address
    {
        $this->company = $company;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAddress1(): ?string
    {
        return $this->address1;
    }

    /**
     * @param string|null $address1
     * @return Address
     */
    public function setAddress1(?string $address1): Address
    {
        $this->address1 = $address1;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAddress2(): ?string
    {
        return $this->address2;
    }

    /**
     * @param string|null $address2
     * @return Address
     */
    public function setAddress2(?string $address2): Address
    {
        $this->address2 = $address2;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPostcode(): ?string
    {
        return $this->postcode;
    }

    /**
     * @param string|null $postcode
     * @return Address
     */
    public function setPostcode(?string $postcode): Address
    {
        $this->postcode = $postcode;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCity(): ?string
    {
        return $this->city;
    }

    /**
     * @param string|null $city
     * @return Address
     */
    public function setCity(?string $city): Address
    {
        $this->city = $city;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getZoneId(): ?int
    {
        return $this->zoneId;
    }

    /**
     * @param int|null $zoneId
     * @return Address
     */
    public function setZoneId(?int $zoneId): Address
    {
        $this->zoneId = $zoneId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getZone(): ?string
    {
        return $this->zone;
    }

    /**
     * @param string|null $zone
     * @return Address
     */
    public function setZone(?string $zone): Address
    {
        $this->zone = $zone;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getZoneCode(): ?string
    {
        return $this->zoneCode;
    }

    /**
     * @param string|null $zoneCode
     * @return Address
     */
    public function setZoneCode(?string $zoneCode): Address
    {
        $this->zoneCode = $zoneCode;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getCountryId(): ?int
    {
        return $this->countryId;
    }

    /**
     * @param int|null $countryId
     * @return Address
     */
    public function setCountryId(?int $countryId): Address
    {
        $this->countryId = $countryId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCountry(): ?string
    {
        return $this->country;
    }

    /**
     * @param string|null $country
     * @return Address
     */
    public function setCountry(?string $country): Address
    {
        $this->country = $country;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getIsoCode2(): ?string
    {
        return $this->isoCode2;
    }

    /**
     * @param string|null $isoCode2
     * @return Address
     */
    public function setIsoCode2(?string $isoCode2): Address
    {
        $this->isoCode2 = $isoCode2;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getIsoCode3(): ?string
    {
        return $this->isoCode3;
    }

    /**
     * @param string|null $isoCode3
     * @return Address
     */
    public function setIsoCode3(?string $isoCode3): Address
    {
        $this->isoCode3 = $isoCode3;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAddressFormat(): ?string
    {
        return $this->addressFormat;
    }

    /**
     * @param string|null $addressFormat
     * @return Address
     */
    public function setAddressFormat(?string $addressFormat): Address
    {
        $this->addressFormat = $addressFormat;
        return $this;
    }

    /**
     * @return array|null
     */
    public function getCustomFields(): ?array
    {
        return $this->customFields;
    }

    /**
     * @param array $customFields
     * @return Address
     */
    public function setCustomFields(array $customFields): Address
    {
        $this->customFields = $customFields;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return Address
     */
    public function setId(?int $id): Address
    {
        $this->id = $id;
        return $this;
    }

}


