<?php

/**
 * Documentation of Opencart Rest Admin Api (OAuth version)
 *
 * For this demo, first you have to call the `Token` service to get an access token.<br>Then click on the `Authorize` button and set the Bearer Token, for example: <strong>`Bearer 7487c50afc37dbf6e5a484dc49c363128036c356`</strong>.<br>Please do not forget the `Bearer` part, if you forget it, then you will get `Malformed auth header` error.<br>Then you have to call the `User` &rArr; `Login` service before you can access the other services.<br><div class=\"main_steps\">First step - Get access token</div><span class=\"method\">POST</span> <span class=\"links\">/oauth2/token/client_credentials</span> The received token needs to be added to every API call.<br><br><div class=\"main_steps\">Second step - Login user</div><span class=\"method\">POST</span> <span class=\"links\">/api/rest_admin/login</span> After successful login you can access the REST API services
 *
 * The version of the OpenAPI document: 1.0
 *
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.0-beta
 */


namespace RTMTrade\OpenCart\AdminApi\Api;

use AutoMapperPlus\Exception\UnregisteredMappingException;
use GuzzleHttp\Exception\GuzzleException;
use GuzzleHttp\Psr7\Request;
use InvalidArgumentException;
use RTMTrade\OpenCart\AdminApi\ApiException;
use RTMTrade\OpenCart\AdminApi\Model\ApiResponse;
use RTMTrade\OpenCart\AdminApi\Model\Country;
use RTMTrade\OpenCart\AdminApi\Model\UtcOffsetInfo;

/**
 * SystemDataApi Class Doc Comment
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class SystemDataApi extends BaseHttpApi
{

    /**
     * Get checksums of product specific tables
     *
     *
     * @return ApiResponse
     * @throws ApiException on non-2xx response
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function listDatabaseChecksums(): ApiResponse
    {
        [$response] = $this->listDatabaseChecksumsWithHttpInfo();
        return $response;
    }

    /**
     * Get checksums of product specific tables
     *
     *
     * @return array of \RTMTrade\OpenCart\AdminApi\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws ApiException on non-2xx response
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function listDatabaseChecksumsWithHttpInfo(): array
    {
        $request = $this->createListDatabaseChecksumsRequest();

        return $this->sendRequest($request);
    }

    /**
     * Create request for operation 'checksumList'
     *
     *
     * @return Request
     * @throws InvalidArgumentException
     */
    protected function createListDatabaseChecksumsRequest(): Request
    {

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            []
        );

        $headers = $this->addDefaultHeaders($headers);

        return new Request('GET', "{$this->config->getBaseUrl()}/checksums", $headers);
    }

    /**
     * @param int $id Country ID (required)
     *
     * @return ApiResponse
     * @throws ApiException on non-2xx response
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function getCountry(int $id): ApiResponse
    {
        [$response] = $this->getCountryWithHttpInfo($id);
        return $this->mapper->map($response->getData(), Country::class);
    }

    /**
     * @param int $id Country ID (required)
     *
     * @return array of \RTMTrade\OpenCart\AdminApi\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws ApiException on non-2xx response
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function getCountryWithHttpInfo(int $id): array
    {
        $request = $this->createGetCountryRequest($id);

        return $this->sendRequest($request);
    }

    /**
     * Create request for operation 'countriesDetails'
     *
     * @param int $id Country ID (required)
     *
     * @return Request
     * @throws InvalidArgumentException
     */
    protected function createGetCountryRequest(int $id): Request
    {
        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            []
        );
        $headers = $this->addDefaultHeaders($headers);

        return new Request(
            'GET',
            "{$this->config->getBaseUrl()}/countries/{$id}",
            $headers
        );
    }

    /**
     * Get list of countries
     *
     *
     * @return ApiResponse
     * @throws ApiException on non-2xx response
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function listCountries(): ApiResponse
    {
        [$response] = $this->listCountriesWithHttpInfo();
        return $response;
    }

    /**
     * Get list of countries
     *
     *
     * @return array of \RTMTrade\OpenCart\AdminApi\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws ApiException on non-2xx response
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function listCountriesWithHttpInfo(): array
    {
        $request = $this->createListCountriesRequest();

        return $this->sendRequest($request);
    }

    /**
     * Create request for operation 'countriesList'
     *
     *
     * @return Request
     * @throws InvalidArgumentException
     */
    protected function createListCountriesRequest(): Request
    {

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            []
        );
        $headers = $this->addDefaultHeaders($headers);

        return new Request(
            'GET',
            $this->config->getBaseUrl() . '/countries',
            $headers
        );
    }

    /**
     * Get UTC offset
     *
     *
     * @return ApiResponse
     * @throws ApiException on non-2xx response
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function getUtcOffset(): ApiResponse
    {
        [$response] = $this->getUtcOffsetWithHttpInfo();
        return $this->mapper->map($response->getData(), UtcOffsetInfo::class);
    }

    /**
     * Get UTC offset
     *
     *
     * @return array of \RTMTrade\OpenCart\AdminApi\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws ApiException on non-2xx response
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function getUtcOffsetWithHttpInfo(): array
    {
        $request = $this->createGetUtcOffsetRequest();

        return $this->sendRequest($request);
    }

    /**
     * Create request for operation 'ordersUtcOffset'
     *
     *
     * @return Request
     * @throws InvalidArgumentException
     */
    protected function createGetUtcOffsetRequest(): Request
    {
        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            []
        );

        $headers = $this->addDefaultHeaders($headers);

        return new Request(
            'GET',
            $this->config->getBaseUrl() . '/utc_offset',
            $headers
        );
    }

    /**
     * Get product classes and other select values
     *
     *
     * @return ApiResponse
     * @throws ApiException on non-2xx response
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function listSystemData(): ApiResponse
    {
        [$response] = $this->listSystemDataWithHttpInfo();
        return $response;
    }

    /**
     * Get product classes and other select values
     *
     *
     * @return array of \RTMTrade\OpenCart\AdminApi\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws ApiException on non-2xx response
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function listSystemDataWithHttpInfo(): array
    {
        $request = $this->createListSystemDataRequest();

        return $this->sendRequest($request);
    }

    /**
     * Create request for operation 'productsProductclasses'
     *
     *
     * @return Request
     * @throws InvalidArgumentException
     */
    protected function createListSystemDataRequest(): Request
    {
        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            []
        );

        $headers = $this->addDefaultHeaders($headers);

        return new Request(
            'GET',
            $this->config->getBaseUrl() . '/init',
            $headers
        );
    }

    /**
     * Get system information
     *
     * @param string $type information type (required)
     *
     * @return ApiResponse
     * @throws ApiException on non-2xx response
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function getSystemDataByType(string $type): ApiResponse
    {
        [$response] = $this->getSystemDataByTypeWithHttpInfo($type);
        return $response;
    }

    /**
     * Get system information
     *
     * @param string $type information type (required)
     *
     * @return array of \RTMTrade\OpenCart\AdminApi\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws ApiException on non-2xx response
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function getSystemDataByTypeWithHttpInfo(string $type): array
    {
        $request = $this->createGetSystemDataByTypeRequest($type);

        return $this->sendRequest($request);
    }

    /**
     * Create request for operation 'systemDataByType'
     *
     * @param string $type information type (required)
     *
     * @return Request
     * @throws InvalidArgumentException
     */
    protected function createGetSystemDataByTypeRequest(string $type): Request
    {
        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            []
        );
        $headers = $this->addDefaultHeaders($headers);

        $str = "{$this->config->getBaseUrl()}/init/{$type}";
        return new Request('GET', $str, $headers);
    }

}
