<?php

/**
 * Documentation of Opencart Rest Admin Api (OAuth version)
 *
 * For this demo, first you have to call the `Token` service to get an access token.<br>Then click on the `Authorize` button and set the Bearer Token, for example: <strong>`Bearer 7487c50afc37dbf6e5a484dc49c363128036c356`</strong>.<br>Please do not forget the `Bearer` part, if you forget it, then you will get `Malformed auth header` error.<br>Then you have to call the `User` &rArr; `Login` service before you can access the other services.<br><div class=\"main_steps\">First step - Get access token</div><span class=\"method\">POST</span> <span class=\"links\">/oauth2/token/client_credentials</span> The received token needs to be added to every API call.<br><br><div class=\"main_steps\">Second step - Login user</div><span class=\"method\">POST</span> <span class=\"links\">/api/rest_admin/login</span> After successful login you can access the REST API services
 *
 * The version of the OpenAPI document: 1.0
 *
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.0-beta
 */


namespace RTMTrade\OpenCart\AdminApi\Api;

use AutoMapperPlus\AutoMapperInterface;
use AutoMapperPlus\Exception\UnregisteredMappingException;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\GuzzleException;
use Psr\Log\LoggerInterface;
use RTMTrade\OpenCart\AdminApi\ApiException;
use RTMTrade\OpenCart\AdminApi\Configuration;
use RTMTrade\OpenCart\AdminApi\HeaderSelector;
use RTMTrade\OpenCart\AdminApi\Model\ProductAttributeDescription;

/**
 * ProductAttributeApi Class Doc Comment
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ProductAttributeApi extends AbstractApi
{

    public function __construct(ClientInterface $client, Configuration $config, HeaderSelector $headerSelector, AutoMapperInterface $mapper, LoggerInterface $logger = null)
    {
        parent::__construct($client, $config, $headerSelector, $mapper, $logger);

        $this->resourceClass = ProductAttributeDescription::class;
        $this->resourceName = 'attributes';

        $this->allowedOperations = [
            'add',
            'delete',
            'bulkDelete',
            'pagination',
            'paginationSubresource' => true
        ];
    }

    /**
     * Get list of product attributes filter by group
     *
     * @param int $groupId Group id (required)
     * @param int $limit Limit (required)
     * @param int $page Page (required)
     *
     * @return ProductAttributeDescription[]
     * @throws ApiException on non-2xx response
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function listByGroupId(int $groupId, int $limit, int $page): array
    {
        [$response] = $this->listByGroupIdWithHttpInfo($groupId, $limit, $page);
        return $this->mapper->mapMultiple($response->getData(), ProductAttributeDescription::class);
    }

    /**
     * Get list of product attributes filter by group
     *
     * @param int $groupId Group id (required)
     * @param int $limit Limit (required)
     * @param int $page Page (required)
     *
     * @return array of \RTMTrade\OpenCart\AdminApi\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws ApiException on non-2xx response
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function listByGroupIdWithHttpInfo(int $groupId, int $limit, int $page): array
    {
        $request = $this->createPaginationSubresourceRequest("group/{$groupId}", $limit, $page);

        return $this->sendRequest($request);
    }
}
