<?php

namespace RTMTrade\OpenCart\AdminApi\Api;

use AutoMapperPlus\AutoMapperInterface;
use GuzzleHttp\ClientInterface;
use Psr\Log\LoggerInterface;
use RTMTrade\OpenCart\AdminApi\Configuration;
use RTMTrade\OpenCart\AdminApi\HeaderSelector;
use RTMTrade\OpenCart\AdminApi\Model\CustomerGroup;

class CustomerGroupApi extends AbstractApi
{

    public function __construct(ClientInterface $client, Configuration $config, HeaderSelector $headerSelector, AutoMapperInterface $mapper, LoggerInterface $logger = null)
    {
        parent::__construct($client, $config, $headerSelector, $mapper, $logger);
        $this->resourceClass = CustomerGroup::class;
        $this->resourceName = 'customergroups';

        $this->allowedOperations = [
            'add',
            'update',
            'delete',
            'pagination',
            'bulkDelete'
        ];
    }

}
