<?php
/**
 * VoucherObject
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Documentation of Opencart Rest Admin Api (OAuth version)
 *
 * For this demo, first you have to call the `Token` service to get an access token.<br>Then click on the `Authorize` button and set the Bearer Token, for example: <strong>`Bearer 7487c50afc37dbf6e5a484dc49c363128036c356`</strong>.<br>Please do not forget the `Bearer` part, if you forget it, then you will get `Malformed auth header` error.<br>Then you have to call the `User` &rArr; `Login` service before you can access the other services.<br><div class=\"main_steps\">First step - Get access token</div><span class=\"method\">POST</span> <span class=\"links\">/oauth2/token/client_credentials</span> The received token needs to be added to every API call.<br><br><div class=\"main_steps\">Second step - Login user</div><span class=\"method\">POST</span> <span class=\"links\">/api/rest_admin/login</span> After successful login you can access the REST API services
 *
 * The version of the OpenAPI document: 1.0
 *
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.0-beta
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace RTMTrade\OpenCart\AdminApi\Model;

/**
 * VoucherObject Class Doc Comment
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class Voucher
{

    private string $code;
    private string $fromName;
    private string $fromEmail;
    private string $toName;
    private string $toEmail;
    private string $message;
    private int $voucherThemeId;
    private int $amount;
    private bool $status;

    /**
     * Voucher constructor.
     * @param string $code
     * @param string $fromName
     * @param string $fromEmail
     * @param string $toName
     * @param string $toEmail
     * @param string $message
     * @param int $voucherThemeId
     * @param int $amount
     * @param bool $status
     */
    public function __construct(string $code, string $fromName, string $fromEmail, string $toName, string $toEmail, string $message, int $voucherThemeId, int $amount, bool $status)
    {
        $this->code = $code;
        $this->fromName = $fromName;
        $this->fromEmail = $fromEmail;
        $this->toName = $toName;
        $this->toEmail = $toEmail;
        $this->message = $message;
        $this->voucherThemeId = $voucherThemeId;
        $this->amount = $amount;
        $this->status = $status;
    }

    /**
     * @return string
     */
    public function getCode(): string
    {
        return $this->code;
    }

    /**
     * @param string $code
     * @return Voucher
     */
    public function setCode(string $code): Voucher
    {
        $this->code = $code;
        return $this;
    }

    /**
     * @return string
     */
    public function getFromName(): string
    {
        return $this->fromName;
    }

    /**
     * @param string $fromName
     * @return Voucher
     */
    public function setFromName(string $fromName): Voucher
    {
        $this->fromName = $fromName;
        return $this;
    }

    /**
     * @return string
     */
    public function getFromEmail(): string
    {
        return $this->fromEmail;
    }

    /**
     * @param string $fromEmail
     * @return Voucher
     */
    public function setFromEmail(string $fromEmail): Voucher
    {
        $this->fromEmail = $fromEmail;
        return $this;
    }

    /**
     * @return string
     */
    public function getToName(): string
    {
        return $this->toName;
    }

    /**
     * @param string $toName
     * @return Voucher
     */
    public function setToName(string $toName): Voucher
    {
        $this->toName = $toName;
        return $this;
    }

    /**
     * @return string
     */
    public function getToEmail(): string
    {
        return $this->toEmail;
    }

    /**
     * @param string $toEmail
     * @return Voucher
     */
    public function setToEmail(string $toEmail): Voucher
    {
        $this->toEmail = $toEmail;
        return $this;
    }

    /**
     * @return string
     */
    public function getMessage(): string
    {
        return $this->message;
    }

    /**
     * @param string $message
     * @return Voucher
     */
    public function setMessage(string $message): Voucher
    {
        $this->message = $message;
        return $this;
    }

    /**
     * @return int
     */
    public function getVoucherThemeId(): int
    {
        return $this->voucherThemeId;
    }

    /**
     * @param int $voucherThemeId
     * @return Voucher
     */
    public function setVoucherThemeId(int $voucherThemeId): Voucher
    {
        $this->voucherThemeId = $voucherThemeId;
        return $this;
    }

    /**
     * @return int
     */
    public function getAmount(): int
    {
        return $this->amount;
    }

    /**
     * @param int $amount
     * @return Voucher
     */
    public function setAmount(int $amount): Voucher
    {
        $this->amount = $amount;
        return $this;
    }

    /**
     * @return bool
     */
    public function isStatus(): bool
    {
        return $this->status;
    }

    /**
     * @param bool $status
     * @return Voucher
     */
    public function setStatus(bool $status): Voucher
    {
        $this->status = $status;
        return $this;
    }

}


