<?php


namespace RTMTrade\OpenCart\AdminApi\Model;


class UtcOffsetInfo
{

    private array $databaseTimezone;
    private int $offset;

    /**
     * UtcOffsetInfo constructor.
     * @param array $databaseTimezone
     * @param int $offset
     */
    public function __construct(array $databaseTimezone, int $offset)
    {
        $this->databaseTimezone = $databaseTimezone;
        $this->offset = $offset;
    }

    /**
     * @return array
     */
    public function getDatabaseTimezone(): array
    {
        return $this->databaseTimezone;
    }

    /**
     * @param array $databaseTimezone
     * @return UtcOffsetInfo
     */
    public function setDatabaseTimezone(array $databaseTimezone): UtcOffsetInfo
    {
        $this->databaseTimezone = $databaseTimezone;
        return $this;
    }

    /**
     * @return int
     */
    public function getOffset(): int
    {
        return $this->offset;
    }

    /**
     * @param int $offset
     * @return UtcOffsetInfo
     */
    public function setOffset(int $offset): UtcOffsetInfo
    {
        $this->offset = $offset;
        return $this;
    }

}