<?php


namespace RTMTrade\OpenCart\AdminApi\Model;

/**
 * Class ProductOptions
 * @package RTMTrade\OpenCart\AdminApi\Model
 * @author Beau Fiechter (RTM Business)
 * @link https://gitlab.rtmbusiness.nl/spyder/opencart-admin-api-php
 */
class ProductOptions
{

    /**
     * The ID of the ProductOption (Coupled to Product)
     * @var int|null
     */
    private ?int $id;

    /**
     * The ID of the Option
     * option_id
     * @var int|null
     */
    private ?int $optionId;

    private ?bool $required;

    private ?string $name;
    private ?string $type;

    /**
     * @var ProductOptionValue[]
     */
    private array $values;

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return ProductOptions
     */
    public function setId(?int $id): ProductOptions
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getOptionId(): ?int
    {
        return $this->optionId;
    }

    /**
     * @param int|null $optionId
     * @return ProductOptions
     */
    public function setOptionId(?int $optionId): ProductOptions
    {
        $this->optionId = $optionId;
        return $this;
    }

    /**
     * @return bool|null
     */
    public function getRequired(): ?bool
    {
        return $this->required;
    }

    /**
     * @param bool|null $required
     * @return ProductOptions
     */
    public function setRequired(?bool $required): ProductOptions
    {
        $this->required = $required;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     * @return ProductOptions
     */
    public function setName(?string $name): ProductOptions
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getType(): ?string
    {
        return $this->type;
    }

    /**
     * @param string|null $type
     * @return ProductOptions
     */
    public function setType(?string $type): ProductOptions
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return ProductOptionValue[]
     */
    public function getValues(): array
    {
        return $this->values;
    }

    /**
     * @param ProductOptionValue[] $values
     * @return ProductOptions
     */
    public function setValues(array $values): ProductOptions
    {
        $this->values = $values;
        return $this;
    }


}