<?php


namespace RTMTrade\OpenCart\AdminApi\Model;

/**
 * Class OrderInvoice
 * @package RTMTrade\OpenCart\AdminApi\Model
 * @author Beau Fiechter (RTM Business)
 * @link https://gitlab.rtmbusiness.nl/spyder/opencart-admin-api-php
 */
class OrderInvoice
{

    private ?string $number;
    private ?string $prefix;

    /**
     * OrderInvoice constructor.
     * @param string|null $number
     * @param string|null $prefix
     */
    public function __construct(?string $number, ?string $prefix)
    {
        $this->number = $number;
        $this->prefix = $prefix;
    }


    /**
     * @return string|null
     */
    public function getNumber(): ?string
    {
        return $this->number;
    }

    /**
     * @param string|null $number
     * @return OrderInvoice
     */
    public function setNumber(?string $number): OrderInvoice
    {
        $this->number = $number;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPrefix(): ?string
    {
        return $this->prefix;
    }

    /**
     * @param string|null $prefix
     * @return OrderInvoice
     */
    public function setPrefix(?string $prefix): OrderInvoice
    {
        $this->prefix = $prefix;
        return $this;
    }

    public function __toString()
    {
        return "{$this->prefix}{$this->number}";
    }

}