<?php


namespace RTMTrade\OpenCart\AdminApi\Model;


use DateTimeInterface;

class Currency
{

    private int $id;
    private string $title;
    private string $code;
    private string $symbolLeft;
    private string $symbolRight;
    private int $decimalPlace;
    private float $value;
    private bool $status;
    private DateTimeInterface $dateModified;

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @param int $id
     * @return Currency
     */
    public function setId(int $id): Currency
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @param string $title
     * @return Currency
     */
    public function setTitle(string $title): Currency
    {
        $this->title = $title;
        return $this;
    }

    /**
     * @return string
     */
    public function getCode(): string
    {
        return $this->code;
    }

    /**
     * @param string $code
     * @return Currency
     */
    public function setCode(string $code): Currency
    {
        $this->code = $code;
        return $this;
    }

    /**
     * @return string
     */
    public function getSymbolLeft(): string
    {
        return $this->symbolLeft;
    }

    /**
     * @param string $symbolLeft
     * @return Currency
     */
    public function setSymbolLeft(string $symbolLeft): Currency
    {
        $this->symbolLeft = $symbolLeft;
        return $this;
    }

    /**
     * @return string
     */
    public function getSymbolRight(): string
    {
        return $this->symbolRight;
    }

    /**
     * @param string $symbolRight
     * @return Currency
     */
    public function setSymbolRight(string $symbolRight): Currency
    {
        $this->symbolRight = $symbolRight;
        return $this;
    }

    /**
     * @return int
     */
    public function getDecimalPlace(): int
    {
        return $this->decimalPlace;
    }

    /**
     * @param int $decimalPlace
     * @return Currency
     */
    public function setDecimalPlace(int $decimalPlace): Currency
    {
        $this->decimalPlace = $decimalPlace;
        return $this;
    }

    /**
     * @return float
     */
    public function getValue(): float
    {
        return $this->value;
    }

    /**
     * @param float $value
     * @return Currency
     */
    public function setValue(float $value): Currency
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @return bool
     */
    public function isStatus(): bool
    {
        return $this->status;
    }

    /**
     * @param bool $status
     * @return Currency
     */
    public function setStatus(bool $status): Currency
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return DateTimeInterface
     */
    public function getDateModified(): DateTimeInterface
    {
        return $this->dateModified;
    }

    /**
     * @param DateTimeInterface $dateModified
     * @return Currency
     */
    public function setDateModified(DateTimeInterface $dateModified): Currency
    {
        $this->dateModified = $dateModified;
        return $this;
    }

}