<?php

namespace RTMTrade\OpenCart\AdminApi\Api;

use AutoMapperPlus\AutoMapperInterface;
use AutoMapperPlus\Exception\UnregisteredMappingException;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\GuzzleException;
use GuzzleHttp\Psr7\Query;
use Psr\Log\LoggerInterface;
use RTMTrade\OpenCart\AdminApi\ApiException;
use RTMTrade\OpenCart\AdminApi\Configuration;
use RTMTrade\OpenCart\AdminApi\HeaderSelector;
use RTMTrade\OpenCart\AdminApi\Model\ApiResponse;
use RTMTrade\OpenCart\AdminApi\Model\Product;
use RTMTrade\OpenCart\AdminApi\Model\ProductQuantity;
use RTMTrade\OpenCart\AdminApi\Model\ProductQuantitySku;
use SplFileObject;

/**
 * ProductsApi Class Doc Comment
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @extends AbstractApi<Product>
 */
class ProductsApi extends AbstractApi
{

    public function __construct(ClientInterface $client,
                                Configuration $config,
                                HeaderSelector $headerSelector,
                                AutoMapperInterface $mapper,
                                LoggerInterface $logger = null)
    {
        parent::__construct($client, $config, $headerSelector, $mapper, $logger);
        $this->resourceClass = Product::class;
        $this->resourceName = 'products';

        $this->allowedOperations = [
            'get',
            'add',
            'update',
            'delete',
            'list',
            'pagination',
            'bulkAdd',
            'bulkUpdate',
            'updateSubresource' => [
                'quantity' => ProductQuantity::class,
                'quantity_by_sku' => ProductQuantitySku::class
            ],
            'getBySubresource' => [
                'getproductbysku' => Product::class,
            ],
            'listBySubresource' => true,
            'paginationSubresource' => true
        ];
    }

    /**
     * Update products quantity
     *
     * @param ProductQuantity[] $arrayOfProductQuantityObjects Array of Product quantity objects (required)
     *
     * @return ApiResponse
     * @throws ApiException on non-2xx response
     * @throws GuzzleException
     * @throws UnregisteredMappingException
     */
    public function bulkUpdateQuantity(array $arrayOfProductQuantityObjects): ApiResponse
    {
        return $this->bulkUpdateQuantityWithHttpInfo($arrayOfProductQuantityObjects)[0];
    }

    /**
     * Update products quantity
     *
     * @param ProductQuantity[] $arrayOfProductQuantityObjects Array of Product quantity objects (required)
     *
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws ApiException on non-2xx response
     * @throws GuzzleException
     * @throws UnregisteredMappingException
     */
    public function bulkUpdateQuantityWithHttpInfo(array $arrayOfProductQuantityObjects): array
    {
        $request = $this->createSubresourceBulkUpdateRequest('quantity', $arrayOfProductQuantityObjects);
        return $this->sendRequest($request);
    }

    /**
     * Update products quantity by sku
     *
     * @param ProductQuantitySku[] $productQuantityObjects Array of Product quantity objects (required)
     *
     * @return ApiResponse
     * @throws ApiException on non-2xx response
     * @throws GuzzleException
     * @throws UnregisteredMappingException
     */
    public function bulkUpdateQuantityBySku(array $productQuantityObjects): ApiResponse
    {
        return $this->bulkUpdateQuantityBySkuWithHttpInfo($productQuantityObjects)[0];
    }

    /**
     * Update products quantity by sku
     *
     * @param ProductQuantitySku[] $productQuantityObjects Array of Product quantity objects (required)
     *
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws ApiException on non-2xx response
     * @throws GuzzleException
     * @throws UnregisteredMappingException
     */
    public function bulkUpdateQuantityBySkuWithHttpInfo(array $productQuantityObjects): array
    {
        $request = $this->createSubresourceBulkUpdateRequest('quantitybysku', $productQuantityObjects);
        return $this->sendRequest($request);
    }

    /**
     * Get list of products by category ID
     *
     * @param int $id Product&#39;s category id (required)
     *
     * @return Product[]
     * @throws ApiException on non-2xx response
     * @throws GuzzleException
     * @throws UnregisteredMappingException
     */
    public function listByCategory(int $id): array
    {
        [$response] = $this->listByCategoryWithHttpInfo($id);
        return $this->mapper->mapMultiple($response->getData(), Product::class);
    }

    /**
     * Get list of products by category ID
     *
     * @param int $id Product&#39;s category id (required)
     *
     * @return array of \RTMTrade\OpenCart\AdminApi\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws ApiException on non-2xx response
     * @throws GuzzleException
     * @throws UnregisteredMappingException
     */
    public function listByCategoryWithHttpInfo(int $id): array
    {
        $request = $this->createListBySubresourceRequest('category', $id);
        return $this->sendRequest($request);
    }

    /**
     * Get product by sku
     *
     * @param string $sku Sku (required)
     *
     * @return Product
     * @throws ApiException on non-2xx response
     * @throws GuzzleException
     * @throws UnregisteredMappingException
     */
    public function getBySku(string $sku): Product
    {
        [$response] = $this->getBySkuWithHttpInfo($sku);
        return $this->mapper->map($response->getData(), Product::class);
    }

    /**
     * Get product by sku
     *
     * @param string $sku Sku (required)
     *
     * @return array of \RTMTrade\OpenCart\AdminApi\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws ApiException on non-2xx response
     * @throws GuzzleException
     * @throws UnregisteredMappingException
     */
    public function getBySkuWithHttpInfo(string $sku): array
    {
        $request = $this->createGetBySubresourceRequest('getproductbysku', $sku);
        return $this->sendRequest($request);
    }

    /**
     * Add image to product by product ID, you can send an array of images too.
     *
     * @param int $productId Product Id (required)
     * @param int $sortOrder Sort order (required)
     * @param SplFileObject $file (required)
     *
     * @return ApiResponse
     * @throws ApiException on non-2xx response
     * @throws GuzzleException
     * @throws UnregisteredMappingException
     */
    public function addProductImage(int $productId, int $sortOrder, SplFileObject $file): ApiResponse
    {
        [$response] = $this->addProductImageWithHttpInfo($productId, $sortOrder, $file);
        return $response;
    }

    /**
     * Add image to product by product ID, you can send an array of images too.
     *
     * @param int $id Product Id (required)
     * @param int $sortOrder Sort order (required)
     * @param SplFileObject $file (required)
     *
     * @return array of \RTMTrade\OpenCart\AdminApi\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws ApiException on non-2xx response
     * @throws GuzzleException
     * @throws UnregisteredMappingException
     */
    public function addProductImageWithHttpInfo(int $id, int $sortOrder, SplFileObject $file): array
    {
        $request = $this->createPostFileRequest("products/$id", $file, "other/$sortOrder");
        return $this->sendRequest($request);
    }

    /**
     * Get list of products by category ID and page and limit
     *
     * @param int $id Product&#39;s category id (required)
     * @param int $limit Limit (required)
     * @param int $page Page (required)
     *
     * @return Product[]
     * @throws ApiException on non-2xx response
     * @throws GuzzleException
     * @throws UnregisteredMappingException
     */
    public function paginationByCategory(int $id, int $limit, int $page): array
    {
        [$response] = $this->paginationByCategoryWithHttpInfo($id, $limit, $page);
        return $this->mapper->mapMultiple($response->getData(), Product::class);
    }

    /**
     * Get list of products by category ID and page and limit
     *
     * @param int $id Product&#39;s category id (required)
     * @param int $limit Limit (required)
     * @param int $page Page (required)
     *
     * @return array of \RTMTrade\OpenCart\AdminApi\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws ApiException on non-2xx response
     * @throws GuzzleException
     * @throws UnregisteredMappingException
     */
    public function paginationByCategoryWithHttpInfo(int $id, int $limit, int $page): array
    {
        $request = $this->createPaginationSubresourceRequest("category/$id", $limit, $page);
        return $this->sendRequest($request);
    }

    /**
     * Search resources
     *
     * @param string $search Search text (required)
     *
     * @return array
     * @throws ApiException on non-2xx response
     * @throws GuzzleException
     * @throws UnregisteredMappingException
     */
    public function search(string $search): array
    {
        [$response] = $this->searchWithHttpInfo($search);
        return $this->mapper->mapMultiple($response->getData(), Product::class);
    }

    /**
     * Search resources
     *
     * @param string $search Search text (required)
     *
     * @return array of \RTMTrade\OpenCart\AdminApi\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws ApiException on non-2xx response
     * @throws GuzzleException
     * @throws UnregisteredMappingException
     */
    public function searchWithHttpInfo(string $search): array
    {
        $request = $this->createListBySubresourceRequest('search', $search);
        return $this->sendRequest($request);
    }

    /**
     * Search resources by page and limit
     *
     * @param string $search Search text (required)
     * @param int $limit Limit (required)
     * @param int $page Page (required)
     *
     * @return array
     * @throws ApiException on non-2xx response
     * @throws GuzzleException
     * @throws UnregisteredMappingException
     */
    public function searchPaginated(string $search, int $limit, int $page): array
    {
        [$response] = $this->searchPaginationWithHttpInfo($search, $limit, $page);
        return $this->mapper->mapMultiple($response->getData(), $this->resourceClass);
    }

    /**
     * Search resources by page and limit
     *
     * @param string $search Search text (required)
     * @param int $limit Limit (required)
     * @param int $page Page (required)
     *
     * @return array of \RTMTrade\OpenCart\AdminApi\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws ApiException on non-2xx response
     * @throws GuzzleException
     * @throws UnregisteredMappingException
     */
    public function searchPaginationWithHttpInfo(string $search, int $limit, int $page): array
    {
        $request = $this->createPaginationSubresourceRequest("search/$search", $limit, $page);

        return $this->sendRequest($request);
    }

    /**
     * Set primary image to resource by resource ID
     *
     * @param int $id resource Id (required)
     * @param SplFileObject $file (required)
     *
     * @return ApiResponse
     * @throws ApiException on non-2xx response
     * @throws GuzzleException
     * @throws UnregisteredMappingException
     */
    public function setPrimaryImage(int $id, SplFileObject $file): ApiResponse
    {
        [$response] = $this->setPrimaryImageWithHttpInfo($id, $file);
        return $response;
    }

    /**
     * Set primary image to resource by resource ID
     *
     * @param int $id resource Id (required)
     * @param SplFileObject $file (required)
     *
     * @return array of \RTMTrade\OpenCart\AdminApi\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws ApiException on non-2xx response
     * @throws GuzzleException
     * @throws UnregisteredMappingException
     */
    public function setPrimaryImageWithHttpInfo(int $id, SplFileObject $file): array
    {
        $request = $this->createPostFileRequest("products/$id", $file);
        return $this->sendRequest($request);
    }

    public function getLongUrl()
    {
        $host = $this->config->getBaseUrl();
        return $host . (!str_ends_with($host, '/') ?: '/') . 'index.php?route=rest/' . Inflect::singularize($this->resourceName) . '_admin/' . $this->resourceName;
    }

    public function listQuery(array $filters): array
    {
        if (!empty($filters)) {
            $query = Query::build($filters);
            $uri = $this->getLongUrl() . $query;

            $request = $this->createHttpGetRequest($uri);

            [$response] = $this->sendRequest($request);

            return $this->mapper->mapMultiple($response->getData(), Product::class);
        }
        return $this->list();
    }
}
