<?php

namespace RTMTrade\OpenCart\AdminApi\Api;

use AutoMapperPlus\AutoMapperInterface;
use AutoMapperPlus\Exception\UnregisteredMappingException;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\GuzzleException;
use Psr\Log\LoggerInterface;
use RTMTrade\OpenCart\AdminApi\ApiException;
use RTMTrade\OpenCart\AdminApi\Configuration;
use RTMTrade\OpenCart\AdminApi\HeaderSelector;
use RTMTrade\OpenCart\AdminApi\Model\ApiResponse;
use RTMTrade\OpenCart\AdminApi\Model\Option;
use SplFileObject;

/**
 * ProductOptionApi Class Doc Comment
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ProductOptionApi extends AbstractApi
{

    public function __construct(ClientInterface $client, Configuration $config, HeaderSelector $headerSelector, AutoMapperInterface $mapper, LoggerInterface $logger = null)
    {
        parent::__construct($client, $config, $headerSelector, $mapper, $logger);
        $this->resourceClass = Option::class;
        $this->resourceName = 'product_options';

        $this->allowedOperations = [
            'get',
            'add',
            'delete',
            'pagination',
            'bulkDelete'
        ];
    }


    /**
     * Add image to category by category ID
     *
     * @param int $id Category Id (required)
     * @param SplFileObject $file (required)
     *
     * @return ApiResponse
     * @throws ApiException on non-2xx response
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function updateImage(int $id, SplFileObject $file): ApiResponse
    {
        [$response] = $this->updateImageWithHttpInfo($id, $file);
        return $response;
    }

    /**
     * Add image to category by category ID
     *
     * @param int $id Category Id (required)
     * @param SplFileObject $file (required)
     *
     * @return array of \RTMTrade\OpenCart\AdminApi\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws ApiException on non-2xx response
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function updateImageWithHttpInfo(int $id, SplFileObject $file): array
    {
        $request = $this->createPutFileRequest("{$this->resourceName}/{$id}", $file);

        return $this->sendRequest($request);
    }


    /**
     * Add image to category by category ID
     *
     * @param int $id Category Id (required)
     * @param SplFileObject $file (required)
     *
     * @return ApiResponse
     * @throws ApiException on non-2xx response
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function addImage(int $id, SplFileObject $file): ApiResponse
    {
        [$response] = $this->updateImageWithHttpInfo($id, $file);
        return $response;
    }

    /**
     * Add image to category by category ID
     *
     * @param int $id Category Id (required)
     * @param SplFileObject $file (required)
     *
     * @return array of \RTMTrade\OpenCart\AdminApi\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws ApiException on non-2xx response
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function addImageWithHttpInfo(int $id, SplFileObject $file): array
    {
        $request = $this->createPostFileRequest("{$this->resourceName}/{$id}", $file);

        return $this->sendRequest($request);
    }
}
