<?php

namespace RTMTrade\OpenCart\AdminApi\Api;

use AutoMapperPlus\AutoMapperInterface;
use AutoMapperPlus\Exception\UnregisteredMappingException;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\GuzzleException;
use Psr\Log\LoggerInterface;
use RTMTrade\OpenCart\AdminApi\ApiException;
use RTMTrade\OpenCart\AdminApi\Configuration;
use RTMTrade\OpenCart\AdminApi\HeaderSelector;
use RTMTrade\OpenCart\AdminApi\Model\FeaturedProduct;

class ProductFeaturedApi extends AbstractApi
{

    public function __construct(ClientInterface $client, Configuration $config, HeaderSelector $headerSelector, AutoMapperInterface $mapper, LoggerInterface $logger = null)
    {
        parent::__construct($client, $config, $headerSelector, $mapper, $logger);
        $this->resourceName = 'featured';
        $this->resourceClass = FeaturedProduct::class;
        $this->allowedOperations = [
            'add',
            'update',
            'list',
            'listSubresourceById' => [
                'limit' => FeaturedProduct::class
            ]
        ];
    }

    /**
     * @param int $limit
     * @return FeaturedProduct[]
     * @throws ApiException
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function listLimit(int $limit): array
    {
        [$response] = $this->listLimitWithHttpInfo($limit);
        return $this->mapper->mapMultiple($response->getData(), FeaturedProduct::class);
    }

    /**
     * @param int $limit
     * @return array
     * @throws ApiException
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function listLimitWithHttpInfo(int $limit): array
    {
        $request = $this->createListBySubresourceRequest('limit', $limit);

        return $this->sendRequest($request);
    }
}
