# OpenAPIClient-php

For this demo, first you have to call the `Token` service to get an access token.<br>Then click on the `Authorize` button and set the Bearer Token, for example: <strong>`Bearer 7487c50afc37dbf6e5a484dc49c363128036c356`</strong>.<br>Please do not forget the `Bearer` part, if you forget it, then you will get `Malformed auth header` error.<br>Then you have to call the `User` &rArr; `Login` service before you can access the other services.<br><div class=\"main_steps\">First step - Get access token</div><span class=\"method\">POST</span> <span class=\"links\">/oauth2/token/client_credentials</span> The received token needs to be added to every API call.<br><br><div class=\"main_steps\">Second step - Login user</div><span class=\"method\">POST</span> <span class=\"links\">/api/rest_admin/login</span> After successful login you can access the REST API services

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
- Package version: 1.0
- Build package: org.openapitools.codegen.languages.PhpClientCodegen

## Requirements

PHP 7.2 and later

## Installation & Usage

### Composer

To install the bindings via [Composer](http://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/beau.fiechter/opencart-admin-api-php.git"
    }
  ],
  "require": {
    "beau.fiechter/opencart-admin-api-php": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
    require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Tests

To run the unit tests:

```bash
composer install
./vendor/bin/phpunit
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$level = 2; // int | Level number

try {
    $result = $apiInstance->categoriesByLevel($level);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoryApi->categoriesByLevel: ', $e->getMessage(), PHP_EOL;
}

?>
```

## Documentation for API Endpoints

All URIs are relative to *https://api-oauth.opencart-api.com/api/rest_admin*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CategoryApi* | [**categoriesByLevel**](docs/Api/CategoryApi.md#categoriesbylevel) | **GET** /categories/level/{level} | Get list of categories by depth level
*CategoryApi* | [**categoriesByParentId**](docs/Api/CategoryApi.md#categoriesbyparentid) | **GET** /categories/parent/{parent} | Get list of categories by parent ID
*CategoryApi* | [**categoriesByParentId1**](docs/Api/CategoryApi.md#categoriesbyparentid1) | **GET** /categories/parent/{parent}/level/{level} | Get list of categories by parent ID and level
*CategoryApi* | [**categoriesDelete**](docs/Api/CategoryApi.md#categoriesdelete) | **DELETE** /categories | Delete categories
*CategoryApi* | [**categoriesDeleteById**](docs/Api/CategoryApi.md#categoriesdeletebyid) | **DELETE** /categories/{id} | Delete category by ID
*CategoryApi* | [**categoriesDetails**](docs/Api/CategoryApi.md#categoriesdetails) | **GET** /categories/{id} | Get category details by ID
*CategoryApi* | [**categoriesList**](docs/Api/CategoryApi.md#categorieslist) | **GET** /categories | Get list of categories (default 1 level)
*CategoryApi* | [**categoryAdd**](docs/Api/CategoryApi.md#categoryadd) | **POST** /categories | Add new category to store
*CategoryApi* | [**categoryEdit**](docs/Api/CategoryApi.md#categoryedit) | **PUT** /categories/{id} | Edit category
*CategoryApi* | [**categoryExtendedListPagination**](docs/Api/CategoryApi.md#categoryextendedlistpagination) | **GET** /categories/extended/limit/{limit}/page/{page} | Get list of categories (all in one request)
*CategoryApi* | [**categoryUpdateImage**](docs/Api/CategoryApi.md#categoryupdateimage) | **POST** /categories/{id}/images | Add image to category by category ID
*Class1TokenApi* | [**tokenGet**](docs/Api/Class1TokenApi.md#tokenget) | **POST** /oauth2/token/{grant_type} | Get access token
*Class2UserApi* | [**forgotten**](docs/Api/Class2UserApi.md#forgotten) | **POST** /forgotten | Forgotten password
*Class2UserApi* | [**loginUser**](docs/Api/Class2UserApi.md#loginuser) | **POST** /login | Logs user into the system
*Class2UserApi* | [**logoutUser**](docs/Api/Class2UserApi.md#logoutuser) | **POST** /logout | Logs out current logged in user session
*Class2UserApi* | [**reset**](docs/Api/Class2UserApi.md#reset) | **POST** /reset | Reset password
*Class2UserApi* | [**userDetails**](docs/Api/Class2UserApi.md#userdetails) | **GET** /user | Get user account details
*CouponApi* | [**couponAdd**](docs/Api/CouponApi.md#couponadd) | **POST** /coupons | Add new coupon to store
*CouponApi* | [**couponDelete**](docs/Api/CouponApi.md#coupondelete) | **DELETE** /coupons/{id} | Delete coupon by ID
*CouponApi* | [**couponDeleteMultiple**](docs/Api/CouponApi.md#coupondeletemultiple) | **DELETE** /coupons | Delete coupons
*CouponApi* | [**couponList**](docs/Api/CouponApi.md#couponlist) | **GET** /coupons/limit/{limit}/page/{page} | Get list of coupons
*CouponApi* | [**couponUpdate**](docs/Api/CouponApi.md#couponupdate) | **PUT** /coupons/{id} | Update coupon by ID
*CustomFieldsApi* | [**customfieldList**](docs/Api/CustomFieldsApi.md#customfieldlist) | **GET** /customfields/limit/{limit}/page/{page} | Get list of custom fields
*CustomerApi* | [**customerAdd**](docs/Api/CustomerApi.md#customeradd) | **POST** /customers | Add new customer
*CustomerApi* | [**customerDelete**](docs/Api/CustomerApi.md#customerdelete) | **DELETE** /customers | Delete customers
*CustomerApi* | [**customerDeleteById**](docs/Api/CustomerApi.md#customerdeletebyid) | **DELETE** /customers/{id} | Delete customer by ID
*CustomerApi* | [**customerDetails**](docs/Api/CustomerApi.md#customerdetails) | **GET** /customers/{id} | Get customer details by ID
*CustomerApi* | [**customerDetailsEmail**](docs/Api/CustomerApi.md#customerdetailsemail) | **GET** /customers/email/{email} | Get customer details by email
*CustomerApi* | [**customerListAddedBetween**](docs/Api/CustomerApi.md#customerlistaddedbetween) | **GET** /customers/added_from/{added_from}/added_to/{added_to} | Get list of customers filtered by date parameter (between)
*CustomerApi* | [**customerListAddedFrom**](docs/Api/CustomerApi.md#customerlistaddedfrom) | **GET** /customers/added_from/{added_from} | Get list of customers filtered by date parameter (from)
*CustomerApi* | [**customerListAddedOn**](docs/Api/CustomerApi.md#customerlistaddedon) | **GET** /customers/added_on/{added_on} | Get list of customers filtered by  date parameter (on)
*CustomerApi* | [**customerModify**](docs/Api/CustomerApi.md#customermodify) | **PUT** /customers/{id} | Modify customer
*CustomerApi* | [**customersList**](docs/Api/CustomerApi.md#customerslist) | **GET** /customers/limit/{limit}/page/{page} | Get list of customers
*CustomerApi* | [**rewardAdd**](docs/Api/CustomerApi.md#rewardadd) | **POST** /reward/{id} | Add reward points to customer
*CustomerApi* | [**transactionAdd**](docs/Api/CustomerApi.md#transactionadd) | **POST** /transaction/{id} | Add transaction points to customer
*CustomerGroupApi* | [**customergroupAdd**](docs/Api/CustomerGroupApi.md#customergroupadd) | **POST** /customergroups | Add new customer group
*CustomerGroupApi* | [**customergroupDelete**](docs/Api/CustomerGroupApi.md#customergroupdelete) | **DELETE** /customergroups/{id} | Delete customer group
*CustomerGroupApi* | [**customergroupDeleteMultiple**](docs/Api/CustomerGroupApi.md#customergroupdeletemultiple) | **DELETE** /customergroups | Delete customer groups
*CustomerGroupApi* | [**customergroupList**](docs/Api/CustomerGroupApi.md#customergrouplist) | **GET** /customergroups/limit/{limit}/page/{page} | Get customer groups
*CustomerGroupApi* | [**customergroupModify**](docs/Api/CustomerGroupApi.md#customergroupmodify) | **PUT** /customergroups/{id} | Modify customer group
*ManufacturerApi* | [**manufacturerAdd**](docs/Api/ManufacturerApi.md#manufactureradd) | **POST** /manufacturers | Add new manufacturer to store
*ManufacturerApi* | [**manufacturerDelete**](docs/Api/ManufacturerApi.md#manufacturerdelete) | **DELETE** /manufacturers/{id} | Delete manufacturer by ID
*ManufacturerApi* | [**manufacturerDeleteMultiple**](docs/Api/ManufacturerApi.md#manufacturerdeletemultiple) | **DELETE** /manufacturers | Delete manufacturers
*ManufacturerApi* | [**manufacturerList**](docs/Api/ManufacturerApi.md#manufacturerlist) | **GET** /manufacturers/limit/{limit}/page/{page} | Get list of manufacturers
*ManufacturerApi* | [**manufacturerUpdate**](docs/Api/ManufacturerApi.md#manufacturerupdate) | **PUT** /manufacturers/{id} | Update manufacturer by ID
*ManufacturerApi* | [**manufacturerUpdateImage**](docs/Api/ManufacturerApi.md#manufacturerupdateimage) | **POST** /manufacturers/{id}/images | Add image to manufacturer by manufacturer ID
*OrderApi* | [**invoiceCreate**](docs/Api/OrderApi.md#invoicecreate) | **POST** /orders/invoice/{id} | Generate invoice number to the orders
*OrderApi* | [**invoiceUpdate**](docs/Api/OrderApi.md#invoiceupdate) | **PUT** /orders/invoice/{id} | Set custom invoice number to the orders
*OrderApi* | [**orderhistoryUpdate**](docs/Api/OrderApi.md#orderhistoryupdate) | **PUT** /orderhistory/{id} | Add order history
*OrderApi* | [**ordersDelete**](docs/Api/OrderApi.md#ordersdelete) | **DELETE** /orders/{id} | Delete order by ID
*OrderApi* | [**ordersDetails**](docs/Api/OrderApi.md#ordersdetails) | **GET** /orders/{id} | Get order details by ID
*OrderApi* | [**ordersDetailsByCustomer**](docs/Api/OrderApi.md#ordersdetailsbycustomer) | **GET** /orders/user/{id} | Get order details by customer ID
*OrderApi* | [**ordersList**](docs/Api/OrderApi.md#orderslist) | **GET** /orders | Get list of orders
*OrderApi* | [**ordersListAddedBetween**](docs/Api/OrderApi.md#orderslistaddedbetween) | **GET** /orders/added_from/{added_from}/added_to/{added_to} | Get list of orders filtered by date parameter (between)
*OrderApi* | [**ordersListAddedFrom**](docs/Api/OrderApi.md#orderslistaddedfrom) | **GET** /orders/added_from/{added_from} | Get list of orders filtered by date parameter (from)
*OrderApi* | [**ordersListAddedOn**](docs/Api/OrderApi.md#orderslistaddedon) | **GET** /orders/added_on/{added_on} | Get list of orders filtered by  date parameter (on)
*OrderApi* | [**ordersListDetails**](docs/Api/OrderApi.md#orderslistdetails) | **GET** /orders/details | Get list of orders with details
*OrderApi* | [**ordersListDetailsAddedBetween**](docs/Api/OrderApi.md#orderslistdetailsaddedbetween) | **GET** /orders/details/added_from/{added_from}/added_to/{added_to} | Get list of orders with details filtered by date parameter (between)
*OrderApi* | [**ordersListDetailsAddedFrom**](docs/Api/OrderApi.md#orderslistdetailsaddedfrom) | **GET** /orders/details/added_from/{added_from} | Get list of orders with details filtered by date parameter (from)
*OrderApi* | [**ordersListDetailsAddedOn**](docs/Api/OrderApi.md#orderslistdetailsaddedon) | **GET** /orders/details/added_on/{added_on} | Get list of orders with details filtered by  date parameter (on)
*OrderApi* | [**ordersListDetailsIdLargerThan**](docs/Api/OrderApi.md#orderslistdetailsidlargerthan) | **GET** /orders/details/id_larger_than/{id} | Get list of orders with id larger than {id}
*OrderApi* | [**ordersListDetailsIdLowerThan**](docs/Api/OrderApi.md#orderslistdetailsidlowerthan) | **GET** /orders/details/id_lower_than/{id} | Get list of orders with id lower than {id}
*OrderApi* | [**ordersListDetailsModifiedBetween**](docs/Api/OrderApi.md#orderslistdetailsmodifiedbetween) | **GET** /orders/details/modified_from/{modified_from}/modified_to/{modified_to} | Get list of orders with details filtered by modified date parameter (between)
*OrderApi* | [**ordersListDetailsModifiedFrom**](docs/Api/OrderApi.md#orderslistdetailsmodifiedfrom) | **GET** /orders/details/modified_from/{modified_from} | Get list of orders with details filtered by modified date parameter (from)
*OrderApi* | [**ordersListDetailsModifiedOn**](docs/Api/OrderApi.md#orderslistdetailsmodifiedon) | **GET** /orders/details/modified_on/{modified_on} | Get list of orders with details filtered by modified date parameter (on)
*OrderApi* | [**ordersListDetailsStatusId**](docs/Api/OrderApi.md#orderslistdetailsstatusid) | **GET** /orders/details/status/{status_id} | Get list of orders with details filtered by status id
*OrderApi* | [**ordersListIdLargerThan**](docs/Api/OrderApi.md#orderslistidlargerthan) | **GET** /orders/id_larger_than/{id} | Get list of orders with id larger than {id}
*OrderApi* | [**ordersListIdLowerThan**](docs/Api/OrderApi.md#orderslistidlowerthan) | **GET** /orders/id_lower_than/{id} | Get list of orders with id lower than {id}
*OrderApi* | [**ordersListModifiedBetween**](docs/Api/OrderApi.md#orderslistmodifiedbetween) | **GET** /orders/modified_from/{modified_from}/modified_to/{modified_to} | Get list of orders filtered by modified date parameter (between)
*OrderApi* | [**ordersListModifiedFrom**](docs/Api/OrderApi.md#orderslistmodifiedfrom) | **GET** /orders/modified_from/{modified_from} | Get list of orders filtered by modified date parameter (from)
*OrderApi* | [**ordersListModifiedOn**](docs/Api/OrderApi.md#orderslistmodifiedon) | **GET** /orders/modified_on/{modified_on} | Get list of orders filtered by modified date parameter (on)
*OrderApi* | [**ordersListPagination**](docs/Api/OrderApi.md#orderslistpagination) | **GET** /orders/limit/{limit}/page/{page} | Get list of orders
*OrderApi* | [**ordersListPaginationDetailed**](docs/Api/OrderApi.md#orderslistpaginationdetailed) | **GET** /orders/details/limit/{limit}/page/{page} | Get list of orders
*OrderApi* | [**ordersListStatusId**](docs/Api/OrderApi.md#ordersliststatusid) | **GET** /orders/status/{status_id} | Get list of orders filtered by status id
*OrderApi* | [**ordersUpdate**](docs/Api/OrderApi.md#ordersupdate) | **PUT** /orders/{id} | Update order by ID
*OrderApi* | [**ordersUpdateStatus**](docs/Api/OrderApi.md#ordersupdatestatus) | **PUT** /order_status/{id} | Update order status by order ID
*OrderApi* | [**ordersUpdateTrackingnumber**](docs/Api/OrderApi.md#ordersupdatetrackingnumber) | **PUT** /trackingnumber/{id} | Update order tracking number by order ID
*OrderCreateOrderApi* | [**orderadminAddv2**](docs/Api/OrderCreateOrderApi.md#orderadminaddv2) | **POST** /orderadmin | Add new order to database
*PaymentMethodApi* | [**paymentmethodsList**](docs/Api/PaymentMethodApi.md#paymentmethodslist) | **GET** /paymentmethods | Get payment methods
*ProductAttributeApi* | [**attributeAdd**](docs/Api/ProductAttributeApi.md#attributeadd) | **POST** /attributes | Add new attribute
*ProductAttributeApi* | [**attributeDelete**](docs/Api/ProductAttributeApi.md#attributedelete) | **DELETE** /attributes/{id} | Delete attribute by ID
*ProductAttributeApi* | [**attributeDeleteMultiple**](docs/Api/ProductAttributeApi.md#attributedeletemultiple) | **DELETE** /attributes | Delete attribute
*ProductAttributeApi* | [**attributesList**](docs/Api/ProductAttributeApi.md#attributeslist) | **GET** /attributes/limit/{limit}/page/{page} | Get list of product attributes
*ProductAttributeApi* | [**attributesList1**](docs/Api/ProductAttributeApi.md#attributeslist1) | **GET** /attributes/group/{group_id}/limit/{limit}/page/{page} | Get list of product attributes filter by group
*ProductAttributeGroupsApi* | [**attributegroupAdd**](docs/Api/ProductAttributeGroupsApi.md#attributegroupadd) | **POST** /attributegroups | Add new attribute group
*ProductAttributeGroupsApi* | [**attributegroupDelete**](docs/Api/ProductAttributeGroupsApi.md#attributegroupdelete) | **DELETE** /attributegroups/{id} | Delete attribute group by ID
*ProductAttributeGroupsApi* | [**attributegroupDeleteMultiple**](docs/Api/ProductAttributeGroupsApi.md#attributegroupdeletemultiple) | **DELETE** /attributegroups | Delete attribute groups
*ProductAttributeGroupsApi* | [**attributegroupList**](docs/Api/ProductAttributeGroupsApi.md#attributegrouplist) | **GET** /attributegroups/limit/{limit}/page/{page} | Get attribute groups
*ProductAttributeGroupsApi* | [**attributegroupModify**](docs/Api/ProductAttributeGroupsApi.md#attributegroupmodify) | **PUT** /attributegroups/{id} | Modify attribute group
*ProductFeaturedApi* | [**productsFeatured**](docs/Api/ProductFeaturedApi.md#productsfeatured) | **GET** /featured | Get list of featured products
*ProductFeaturedApi* | [**productsFeatured1**](docs/Api/ProductFeaturedApi.md#productsfeatured1) | **GET** /featured/limit/{limit} | Get list of featured products per limit
*ProductFeaturedApi* | [**productsSetFeatured**](docs/Api/ProductFeaturedApi.md#productssetfeatured) | **POST** /featured | Set featured products
*ProductFeaturedApi* | [**productsUpdateFeatured**](docs/Api/ProductFeaturedApi.md#productsupdatefeatured) | **PUT** /featured/{id} | Update featured products
*ProductFilterApi* | [**filtersList**](docs/Api/ProductFilterApi.md#filterslist) | **GET** /product_filters/filters/limit/{limit}/page/{page} | Get product filters
*ProductFilterApi* | [**filtersListByGroup**](docs/Api/ProductFilterApi.md#filterslistbygroup) | **GET** /product_filters/filters/group/{id} | Get product filters by filter group id
*ProductFilterApi* | [**groupsList**](docs/Api/ProductFilterApi.md#groupslist) | **GET** /product_filters/groups/limit/{limit}/page/{page} | Get product filter groups
*ProductLatestApi* | [**productsLatestDetailsLimit**](docs/Api/ProductLatestApi.md#productslatestdetailslimit) | **GET** /latestwithdetails/limit/{limit} | Get list of latest products with product info
*ProductLatestApi* | [**productsLatestLimit**](docs/Api/ProductLatestApi.md#productslatestlimit) | **GET** /latest/limit/{limit} | Get list of latest product ids
*ProductLatestApi* | [**productsLatestLimit1**](docs/Api/ProductLatestApi.md#productslatestlimit1) | **GET** /latest | Get the latest product id
*ProductLatestApi* | [**productsLatestwithdetails**](docs/Api/ProductLatestApi.md#productslatestwithdetails) | **GET** /latestwithdetails | Get the latest product with product info
*ProductOptionApi* | [**optionDelete**](docs/Api/ProductOptionApi.md#optiondelete) | **DELETE** /product_options/{id} | Delete product option details by ID
*ProductOptionApi* | [**optionDetails**](docs/Api/ProductOptionApi.md#optiondetails) | **GET** /product_options/{id} | Get product option details by ID
*ProductOptionApi* | [**optionsAdd**](docs/Api/ProductOptionApi.md#optionsadd) | **POST** /product_options | Add new option
*ProductOptionApi* | [**optionsDeleteMultiple**](docs/Api/ProductOptionApi.md#optionsdeletemultiple) | **DELETE** /product_options | Delete options
*ProductOptionApi* | [**optionsList**](docs/Api/ProductOptionApi.md#optionslist) | **GET** /product_options/limit/{limit}/page/{page} | Get list of product options
*ProductOptionApi* | [**optionsUpdateImage**](docs/Api/ProductOptionApi.md#optionsupdateimage) | **PUT** /product_options/{id}/images | Update option value image path
*ProductOptionApi* | [**productOptionsUpdateImage**](docs/Api/ProductOptionApi.md#productoptionsupdateimage) | **POST** /product_options/{id}/images | Add image to product option
*ProductOptionValueApi* | [**optionValueAdd**](docs/Api/ProductOptionValueApi.md#optionvalueadd) | **POST** /optionvalue/{id} | Add option value to option
*ProductOptionValueApi* | [**optionValueDelete**](docs/Api/ProductOptionValueApi.md#optionvaluedelete) | **DELETE** /optionvalue | Delete option value
*ProductOptionValueApi* | [**optionValueDeleteById**](docs/Api/ProductOptionValueApi.md#optionvaluedeletebyid) | **DELETE** /optionvalue/{id} | Delete option value by ID
*ProductOptionValueApi* | [**optionValueEdit**](docs/Api/ProductOptionValueApi.md#optionvalueedit) | **PUT** /optionvalue/{id} | Edit option value
*ProductsApi* | [**productAdd**](docs/Api/ProductsApi.md#productadd) | **POST** /products | Add new product to store
*ProductsApi* | [**productBulkAdd**](docs/Api/ProductsApi.md#productbulkadd) | **POST** /bulk_products | Add multiple products to store
*ProductsApi* | [**productBulkUpdate**](docs/Api/ProductsApi.md#productbulkupdate) | **PUT** /products/quantity | Update products quantity
*ProductsApi* | [**productBulkUpdate1**](docs/Api/ProductsApi.md#productbulkupdate1) | **PUT** /bulk_products | Update multiple products to store
*ProductsApi* | [**productBulkUpdateSku**](docs/Api/ProductsApi.md#productbulkupdatesku) | **PUT** /products/quantitybysku | Update products quantity by sku
*ProductsApi* | [**productDelete**](docs/Api/ProductsApi.md#productdelete) | **DELETE** /products/{id} | Delete product by ID
*ProductsApi* | [**productUpdate**](docs/Api/ProductsApi.md#productupdate) | **PUT** /products/{id} | Update product by ID
*ProductsApi* | [**productsByLevel**](docs/Api/ProductsApi.md#productsbylevel) | **GET** /products/category/{id} | Get list of products by category ID
*ProductsApi* | [**productsDetails**](docs/Api/ProductsApi.md#productsdetails) | **GET** /products/{id} | Get product details by ID
*ProductsApi* | [**productsGetproductbysku**](docs/Api/ProductsApi.md#productsgetproductbysku) | **GET** /products/getproductbysku/{sku} | Get product by sku
*ProductsApi* | [**productsInsertOtherImage**](docs/Api/ProductsApi.md#productsinsertotherimage) | **POST** /products/{id}/images/other/{sort_order} | Add image to product by product ID, you can send an array of images too.
*ProductsApi* | [**productsList**](docs/Api/ProductsApi.md#productslist) | **GET** /products | Get list of products
*ProductsApi* | [**productsPagination**](docs/Api/ProductsApi.md#productspagination) | **GET** /products/category/{id}/limit/{limit}/page/{page} | Get list of products by category ID and page and limit
*ProductsApi* | [**productsPagination1**](docs/Api/ProductsApi.md#productspagination1) | **GET** /products/limit/{limit}/page/{page} | Get list of products by page and limit
*ProductsApi* | [**productsSearch**](docs/Api/ProductsApi.md#productssearch) | **GET** /products/search/{search} | Search products
*ProductsApi* | [**productsSearchPagination**](docs/Api/ProductsApi.md#productssearchpagination) | **GET** /products/search/{search}/limit/{limit}/page/{page} | Search products by page and limit
*ProductsApi* | [**productsUpdateImage**](docs/Api/ProductsApi.md#productsupdateimage) | **POST** /products/{id}/images | Set primary image to product by product ID
*ShippingMethodsApi* | [**shippingmethodsList**](docs/Api/ShippingMethodsApi.md#shippingmethodslist) | **GET** /shippingmethods | Get shipping methods
*StoreApi* | [**storeCopy**](docs/Api/StoreApi.md#storecopy) | **POST** /stores/copy/{id} | Create a new store(copy existing store)
*StoreApi* | [**storeGet**](docs/Api/StoreApi.md#storeget) | **GET** /stores/{id} | Get store
*StoreApi* | [**storeList**](docs/Api/StoreApi.md#storelist) | **GET** /stores/ | Get list of stores
*StoreApi* | [**storeStats**](docs/Api/StoreApi.md#storestats) | **GET** /stores/stats | Stat of Opencart store
*StoreApi* | [**storeUpdate**](docs/Api/StoreApi.md#storeupdate) | **PUT** /stores/{id} | Update store by ID
*SystemDataApi* | [**checksumList**](docs/Api/SystemDataApi.md#checksumlist) | **GET** /checksums | Get checksums of product specific tables
*SystemDataApi* | [**countriesDetails**](docs/Api/SystemDataApi.md#countriesdetails) | **GET** /countries/{id} | Get zones
*SystemDataApi* | [**countriesList**](docs/Api/SystemDataApi.md#countrieslist) | **GET** /countries | Get list of countries
*SystemDataApi* | [**ordersUtcOffset**](docs/Api/SystemDataApi.md#ordersutcoffset) | **GET** /utc_offset | Get UTC offset
*SystemDataApi* | [**productsProductclasses**](docs/Api/SystemDataApi.md#productsproductclasses) | **GET** /init | Get product classes and other select values
*SystemDataApi* | [**systemDataByType**](docs/Api/SystemDataApi.md#systemdatabytype) | **GET** /init/{type} | Get system information
*VoucherApi* | [**voucherAdd**](docs/Api/VoucherApi.md#voucheradd) | **POST** /vouchers | Add new voucher to store
*VoucherApi* | [**voucherDelete**](docs/Api/VoucherApi.md#voucherdelete) | **DELETE** /vouchers/{id} | Delete voucher by ID
*VoucherApi* | [**voucherDeleteMultiple**](docs/Api/VoucherApi.md#voucherdeletemultiple) | **DELETE** /vouchers | Delete vouchers
*VoucherApi* | [**voucherList**](docs/Api/VoucherApi.md#voucherlist) | **GET** /vouchers/limit/{limit}/page/{page} | Get list of vouchers
*VoucherApi* | [**voucherUpdate**](docs/Api/VoucherApi.md#voucherupdate) | **PUT** /vouchers/{id} | Update voucher by ID
*VoucherApi* | [**voucherthemesList**](docs/Api/VoucherApi.md#voucherthemeslist) | **GET** /voucherthemes | Get list of voucher themes


## Documentation For Models

 - [Address](docs/Model/Address.md)
 - [AddressCustomField](docs/Model/AddressCustomField.md)
 - [ApiResponse](docs/Model/ApiResponse.md)
 - [Attribute](docs/Model/Attribute.md)
 - [AttributeDescription](docs/Model/AttributeDescription.md)
 - [AttributeGroup](docs/Model/AttributeGroup.md)
 - [AttributeGroupEditObject](docs/Model/AttributeGroupEditObject.md)
 - [AttributeGroupGroupDescription](docs/Model/AttributeGroupGroupDescription.md)
 - [BulkProductEditObject](docs/Model/BulkProductEditObject.md)
 - [Category](docs/Model/Category.md)
 - [CategoryDescription](docs/Model/CategoryDescription.md)
 - [CategoryEditObject](docs/Model/CategoryEditObject.md)
 - [CouponEditObject](docs/Model/CouponEditObject.md)
 - [CouponObject](docs/Model/CouponObject.md)
 - [Customer](docs/Model/Customer.md)
 - [CustomerCustomField](docs/Model/CustomerCustomField.md)
 - [CustomerEditObject](docs/Model/CustomerEditObject.md)
 - [CustomerGroup](docs/Model/CustomerGroup.md)
 - [CustomerGroupDescription](docs/Model/CustomerGroupDescription.md)
 - [CustomerGroupEditObject](docs/Model/CustomerGroupEditObject.md)
 - [DeleteAttributeGroups](docs/Model/DeleteAttributeGroups.md)
 - [DeleteAttributes](docs/Model/DeleteAttributes.md)
 - [DeleteCategories](docs/Model/DeleteCategories.md)
 - [DeleteCoupon](docs/Model/DeleteCoupon.md)
 - [DeleteCustomerGroups](docs/Model/DeleteCustomerGroups.md)
 - [DeleteCustomers](docs/Model/DeleteCustomers.md)
 - [DeleteManufacturer](docs/Model/DeleteManufacturer.md)
 - [DeleteOptionValues](docs/Model/DeleteOptionValues.md)
 - [DeleteOptions](docs/Model/DeleteOptions.md)
 - [DeleteVoucher](docs/Model/DeleteVoucher.md)
 - [FeaturedProduct](docs/Model/FeaturedProduct.md)
 - [Forgotten](docs/Model/Forgotten.md)
 - [History](docs/Model/History.md)
 - [InvoiceNumber](docs/Model/InvoiceNumber.md)
 - [Login](docs/Model/Login.md)
 - [Manufacturer](docs/Model/Manufacturer.md)
 - [OptionDescription](docs/Model/OptionDescription.md)
 - [OptionValue](docs/Model/OptionValue.md)
 - [OptionValueDescription](docs/Model/OptionValueDescription.md)
 - [OptionValueImage](docs/Model/OptionValueImage.md)
 - [Order](docs/Model/Order.md)
 - [OrderCustomer](docs/Model/OrderCustomer.md)
 - [OrderProduct](docs/Model/OrderProduct.md)
 - [OrderProductOption](docs/Model/OrderProductOption.md)
 - [OrderStatusSetter](docs/Model/OrderStatusSetter.md)
 - [OrderStatusSetterName](docs/Model/OrderStatusSetterName.md)
 - [OrdertrackingnumberSetter](docs/Model/OrdertrackingnumberSetter.md)
 - [PaymentAddress](docs/Model/PaymentAddress.md)
 - [PaymentMethod](docs/Model/PaymentMethod.md)
 - [Product](docs/Model/Product.md)
 - [ProductAttribute](docs/Model/ProductAttribute.md)
 - [ProductAttributeDescription](docs/Model/ProductAttributeDescription.md)
 - [ProductDescription](docs/Model/ProductDescription.md)
 - [ProductDiscount](docs/Model/ProductDiscount.md)
 - [ProductEditObject](docs/Model/ProductEditObject.md)
 - [ProductOption](docs/Model/ProductOption.md)
 - [ProductOptionData](docs/Model/ProductOptionData.md)
 - [ProductOptionValue](docs/Model/ProductOptionValue.md)
 - [ProductQuantity](docs/Model/ProductQuantity.md)
 - [ProductQuantitySku](docs/Model/ProductQuantitySku.md)
 - [ProductSpecial](docs/Model/ProductSpecial.md)
 - [Reset](docs/Model/Reset.md)
 - [Review](docs/Model/Review.md)
 - [Reward](docs/Model/Reward.md)
 - [ShippingAddress](docs/Model/ShippingAddress.md)
 - [ShippingMethod](docs/Model/ShippingMethod.md)
 - [Store](docs/Model/Store.md)
 - [Transaction](docs/Model/Transaction.md)
 - [VoucherEditObject](docs/Model/VoucherEditObject.md)
 - [VoucherObject](docs/Model/VoucherObject.md)


## Documentation For Authorization



## Bearer


- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header



## Author



