<?php


namespace RTMTrade\OpenCart\AdminApi\Model;


use DateTime;

class SimpleOrder
{

    private ?int $id;
    private ?string $name;
    private ?string $status;
    private ?DateTime $dateAdded;
    /**
     * @var int[]
     */
    private array $products;
    private ?float $total;
    private ?string $currencyCode;
    private ?string $currencyValue;

    /**
     * SimpleOrder constructor.
     */
    public function __construct()
    {
        $this->id = null;
        $this->name = null;
        $this->status = null;
        $this->dateAdded = null;
        $this->products = [];
        $this->total = 0;
        $this->currencyCode = null;
        $this->currencyValue = null;
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return SimpleOrder
     */
    public function setId(?int $id): SimpleOrder
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     * @return SimpleOrder
     */
    public function setName(?string $name): SimpleOrder
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * @param string|null $status
     * @return SimpleOrder
     */
    public function setStatus(?string $status): SimpleOrder
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return DateTime|null
     */
    public function getDateAdded(): ?DateTime
    {
        return $this->dateAdded;
    }

    /**
     * @param DateTime|null $dateAdded
     * @return SimpleOrder
     */
    public function setDateAdded(?DateTime $dateAdded): SimpleOrder
    {
        $this->dateAdded = $dateAdded;
        return $this;
    }

    /**
     * @return int[]
     */
    public function getProducts(): array
    {
        return $this->products;
    }

    /**
     * @param int[] $products
     * @return SimpleOrder
     */
    public function setProducts(array $products): SimpleOrder
    {
        $this->products = $products;
        return $this;
    }

    /**
     * @return float|int|null
     */
    public function getTotal()
    {
        return $this->total;
    }

    /**
     * @param float|int|null $total
     * @return SimpleOrder
     */
    public function setTotal($total)
    {
        $this->total = $total;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCurrencyCode(): ?string
    {
        return $this->currencyCode;
    }

    /**
     * @param string|null $currencyCode
     * @return SimpleOrder
     */
    public function setCurrencyCode(?string $currencyCode): SimpleOrder
    {
        $this->currencyCode = $currencyCode;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCurrencyValue(): ?string
    {
        return $this->currencyValue;
    }

    /**
     * @param string|null $currencyValue
     * @return SimpleOrder
     */
    public function setCurrencyValue(?string $currencyValue): SimpleOrder
    {
        $this->currencyValue = $currencyValue;
        return $this;
    }

}