<?php

namespace RTMTrade\OpenCart\AdminApi\Model;

use DateTime;

/**
 * Class ProductDiscount
 * @package RTMTrade\OpenCart\AdminApi\Model
 * @author Beau Fiechter (RTM Business)
 * @link https://gitlab.rtmbusiness.nl/spyder/opencart-admin-api-php
 */
class ProductDiscount
{

    private ?string $name;
    private ?int $customerGroupId;
    private ?float $price;
    private ?int $priority;
    private ?int $quantity;
    private ?DateTime $dateStart;
    private ?DateTime $dateEnd;

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     * @return ProductDiscount
     */
    public function setName(?string $name): ProductDiscount
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getCustomerGroupId(): ?int
    {
        return $this->customerGroupId;
    }

    /**
     * @param int|null $customerGroupId
     * @return ProductDiscount
     */
    public function setCustomerGroupId(?int $customerGroupId): ProductDiscount
    {
        $this->customerGroupId = $customerGroupId;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getPrice(): ?float
    {
        return $this->price;
    }

    /**
     * @param float|null $price
     * @return ProductDiscount
     */
    public function setPrice(?float $price): ProductDiscount
    {
        $this->price = $price;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getPriority(): ?int
    {
        return $this->priority;
    }

    /**
     * @param int|null $priority
     * @return ProductDiscount
     */
    public function setPriority(?int $priority): ProductDiscount
    {
        $this->priority = $priority;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getQuantity(): ?int
    {
        return $this->quantity;
    }

    /**
     * @param int|null $quantity
     * @return ProductDiscount
     */
    public function setQuantity(?int $quantity): ProductDiscount
    {
        $this->quantity = $quantity;
        return $this;
    }

    /**
     * @return DateTime|null
     */
    public function getDateStart(): ?DateTime
    {
        return $this->dateStart;
    }

    /**
     * @param DateTime|null $dateStart
     * @return ProductDiscount
     */
    public function setDateStart(?DateTime $dateStart): ProductDiscount
    {
        $this->dateStart = $dateStart;
        return $this;
    }

    /**
     * @return DateTime|null
     */
    public function getDateEnd(): ?DateTime
    {
        return $this->dateEnd;
    }

    /**
     * @param DateTime|null $dateEnd
     * @return ProductDiscount
     */
    public function setDateEnd(?DateTime $dateEnd): ProductDiscount
    {
        $this->dateEnd = $dateEnd;
        return $this;
    }

}


