<?php

namespace RTMTrade\OpenCart\AdminApi\Model;


/**
 * Class ProductAttributeDescription
 * @package RTMTrade\OpenCart\AdminApi\Model
 * @author Beau Fiechter (RTM Business)
 * @link https://gitlab.rtmbusiness.nl/spyder/opencart-admin-api-php
 */
class ProductAttributeDescription
{

    private ?int $id;
    private ?int $attributeId;
    private ?int $attributeGroupId;
    private ?int $languageId;
    private ?string $name;
    private ?string $text;

    public function __construct()
    {
        $this->id = null;
        $this->attributeId = null;
        $this->attributeGroupId = null;
        $this->languageId = null;
        $this->name = null;
        $this->text = null;
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return ProductAttributeDescription
     */
    public function setId(?int $id): ProductAttributeDescription
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getAttributeId(): ?int
    {
        return $this->attributeId;
    }

    /**
     * @param int|null $attributeId
     * @return ProductAttributeDescription
     */
    public function setAttributeId(?int $attributeId): ProductAttributeDescription
    {
        $this->attributeId = $attributeId;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getAttributeGroupId(): ?int
    {
        return $this->attributeGroupId;
    }

    /**
     * @param int|null $attributeGroupId
     * @return ProductAttributeDescription
     */
    public function setAttributeGroupId(?int $attributeGroupId): ProductAttributeDescription
    {
        $this->attributeGroupId = $attributeGroupId;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getLanguageId(): ?int
    {
        return $this->languageId;
    }

    /**
     * @param int|null $languageId
     * @return ProductAttributeDescription
     */
    public function setLanguageId(?int $languageId): ProductAttributeDescription
    {
        $this->languageId = $languageId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     * @return ProductAttributeDescription
     */
    public function setName(?string $name): ProductAttributeDescription
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getText(): ?string
    {
        return $this->text;
    }

    /**
     * @param string|null $text
     * @return ProductAttributeDescription
     */
    public function setText(?string $text): ProductAttributeDescription
    {
        $this->text = $text;
        return $this;
    }


}


