<?php
/**
 * Manufacturer
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Documentation of Opencart Rest Admin Api (OAuth version)
 *
 * For this demo, first you have to call the `Token` service to get an access token.<br>Then click on the `Authorize` button and set the Bearer Token, for example: <strong>`Bearer 7487c50afc37dbf6e5a484dc49c363128036c356`</strong>.<br>Please do not forget the `Bearer` part, if you forget it, then you will get `Malformed auth header` error.<br>Then you have to call the `User` &rArr; `Login` service before you can access the other services.<br><div class=\"main_steps\">First step - Get access token</div><span class=\"method\">POST</span> <span class=\"links\">/oauth2/token/client_credentials</span> The received token needs to be added to every API call.<br><br><div class=\"main_steps\">Second step - Login user</div><span class=\"method\">POST</span> <span class=\"links\">/api/rest_admin/login</span> After successful login you can access the REST API services
 *
 * The version of the OpenAPI document: 1.0
 *
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.0-beta
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace RTMTrade\OpenCart\AdminApi\Model;

/**
 * Manufacturer Class Doc Comment
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class Manufacturer
{
    private ?string $name;
    private ?string $image;
    private ?int $sortOrder;
    private ?string $keyword;
    /**
     * @var int[]
     */
    private array $manufacturerStore;

    /**
     * Manufacturer constructor.
     * @param string|null $name
     * @param string|null $image
     * @param int|null $sortOrder
     * @param string|null $keyword
     * @param int[] $manufacturerStore
     */
    public function __construct(?string $name, ?string $image, ?int $sortOrder, ?string $keyword, array $manufacturerStore)
    {
        $this->name = $name;
        $this->image = $image;
        $this->sortOrder = $sortOrder;
        $this->keyword = $keyword;
        $this->manufacturerStore = $manufacturerStore;
    }

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     * @return Manufacturer
     */
    public function setName(?string $name): Manufacturer
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getImage(): ?string
    {
        return $this->image;
    }

    /**
     * @param string|null $image
     * @return Manufacturer
     */
    public function setImage(?string $image): Manufacturer
    {
        $this->image = $image;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getSortOrder(): ?int
    {
        return $this->sortOrder;
    }

    /**
     * @param int|null $sortOrder
     * @return Manufacturer
     */
    public function setSortOrder(?int $sortOrder): Manufacturer
    {
        $this->sortOrder = $sortOrder;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getKeyword(): ?string
    {
        return $this->keyword;
    }

    /**
     * @param string|null $keyword
     * @return Manufacturer
     */
    public function setKeyword(?string $keyword): Manufacturer
    {
        $this->keyword = $keyword;
        return $this;
    }

    /**
     * @return int[]
     */
    public function getManufacturerStore(): array
    {
        return $this->manufacturerStore;
    }

    /**
     * @param int[] $manufacturerStore
     * @return Manufacturer
     */
    public function setManufacturerStore(array $manufacturerStore): Manufacturer
    {
        $this->manufacturerStore = $manufacturerStore;
        return $this;
    }


}


