<?php

namespace RTMTrade\OpenCart\AdminApi\Model;

class Keyword
{

    private int $languageId;
    private string $keyword;

    /**
     * @param int $languageId
     * @param string $keyword
     */
    public function __construct(int $languageId, string $keyword)
    {
        $this->languageId = $languageId;
        $this->keyword = $keyword;
    }


    /**
     * @return int
     */
    public function getLanguageId(): int
    {
        return $this->languageId;
    }

    /**
     * @param int $languageId
     * @return Keyword
     */
    public function setLanguageId(int $languageId): Keyword
    {
        $this->languageId = $languageId;
        return $this;
    }

    /**
     * @return string
     */
    public function getKeyword(): string
    {
        return $this->keyword;
    }

    /**
     * @param string $keyword
     * @return Keyword
     */
    public function setKeyword(string $keyword): Keyword
    {
        $this->keyword = $keyword;
        return $this;
    }

}