<?php


namespace RTMTrade\OpenCart\AdminApi\Model;


class Country
{

    private ?int $id;
    private ?string $name;
    private ?string $isoCode2;
    private ?string $isoCode3;
    private ?string $addressFormat;
    private ?bool $postcodeRequired;
    private ?bool $status;

    /**
     * @var Zone[]
     */
    private array $zone;

    /**
     * Country constructor.
     * @param int|null $id
     * @param string|null $name
     * @param string|null $isoCode2
     * @param string|null $isoCode3
     * @param string|null $addressFormat
     * @param bool|null $postcodeRequired
     * @param bool|null $status
     * @param Zone[] $zone
     */
    public function __construct(?int $id, ?string $name, ?string $isoCode2, ?string $isoCode3, ?string $addressFormat, ?bool $postcodeRequired, ?bool $status, array $zone)
    {
        $this->id = $id;
        $this->name = $name;
        $this->isoCode2 = $isoCode2;
        $this->isoCode3 = $isoCode3;
        $this->addressFormat = $addressFormat;
        $this->postcodeRequired = $postcodeRequired;
        $this->status = $status;
        $this->zone = $zone;
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return Country
     */
    public function setId(?int $id): Country
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     * @return Country
     */
    public function setName(?string $name): Country
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getIsoCode2(): ?string
    {
        return $this->isoCode2;
    }

    /**
     * @param string|null $isoCode2
     * @return Country
     */
    public function setIsoCode2(?string $isoCode2): Country
    {
        $this->isoCode2 = $isoCode2;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getIsoCode3(): ?string
    {
        return $this->isoCode3;
    }

    /**
     * @param string|null $isoCode3
     * @return Country
     */
    public function setIsoCode3(?string $isoCode3): Country
    {
        $this->isoCode3 = $isoCode3;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAddressFormat(): ?string
    {
        return $this->addressFormat;
    }

    /**
     * @param string|null $addressFormat
     * @return Country
     */
    public function setAddressFormat(?string $addressFormat): Country
    {
        $this->addressFormat = $addressFormat;
        return $this;
    }

    /**
     * @return bool|null
     */
    public function getPostcodeRequired(): ?bool
    {
        return $this->postcodeRequired;
    }

    /**
     * @param bool|null $postcodeRequired
     * @return Country
     */
    public function setPostcodeRequired(?bool $postcodeRequired): Country
    {
        $this->postcodeRequired = $postcodeRequired;
        return $this;
    }

    /**
     * @return bool|null
     */
    public function getStatus(): ?bool
    {
        return $this->status;
    }

    /**
     * @param bool|null $status
     * @return Country
     */
    public function setStatus(?bool $status): Country
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return Zone[]
     */
    public function getZone(): array
    {
        return $this->zone;
    }

    /**
     * @param Zone[] $zone
     * @return Country
     */
    public function setZone(array $zone): Country
    {
        $this->zone = $zone;
        return $this;
    }


}