<?php

namespace RTMTrade\OpenCart\AdminApi\Api;

use AutoMapperPlus\AutoMapperInterface;
use AutoMapperPlus\Exception\UnregisteredMappingException;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\GuzzleException;
use Psr\Log\LoggerInterface;
use RTMTrade\OpenCart\AdminApi\ApiException;
use RTMTrade\OpenCart\AdminApi\Configuration;
use RTMTrade\OpenCart\AdminApi\HeaderSelector;
use stdClass;

class ProductFilterApi extends AbstractApi
{

    /**
     * ProductFilterApi constructor.
     * @param ClientInterface $client
     * @param Configuration $config
     * @param HeaderSelector $headerSelector
     * @param AutoMapperInterface $mapper
     * @param LoggerInterface|null $logger
     */
    public function __construct(ClientInterface $client, Configuration $config, HeaderSelector $headerSelector, AutoMapperInterface $mapper, LoggerInterface $logger = null)
    {
        parent::__construct($client, $config, $headerSelector, $mapper, $logger);
        $this->resourceName = 'product_filters';
        // todo: What does this return?
        $this->resourceClass = stdClass::class;

        $this->allowedOperations = [
            'listSubresourceById' => [
                'filters/group' => null // todo
            ],
            'paginationSubresource' => [
                'filters' => null, // todo
                'groups' => null // todo
            ]
        ];
    }

    /**
     * @param int $groupId
     * @return array
     * @throws ApiException
     * @throws GuzzleException
     * @throws UnregisteredMappingException
     */
    public function listByGroupId(int $groupId): array
    {
        [$response] = $this->listByGroupIdWithHttpInfo($groupId);
        return $this->mapper->mapMultiple($response->getData(), $this->resourceClass);
    }

    /**
     * @param int $groupId
     * @return array
     * @throws ApiException
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function listByGroupIdWithHttpInfo(int $groupId): array
    {
        $request = $this->createListBySubresourceRequest('groups', $groupId);
        return $this->sendRequest($request);
    }

    /**
     * @param int $limit
     * @param int $page
     * @return array
     * @throws ApiException
     * @throws GuzzleException
     * @throws UnregisteredMappingException
     */
    public function paginationGroups(int $limit, int $page): array
    {
        [$response] = $this->paginationGroupsWithHttpInfo($limit, $page);
        return $this->mapper->mapMultiple($response->getData(), $this->resourceClass);
    }

    /**
     * @param int $limit
     * @param int $page
     * @return array
     * @throws ApiException
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function paginationGroupsWithHttpInfo(int $limit, int $page): array
    {
        $request = $this->createPaginationSubresourceRequest('groups', $limit, $page);

        return $this->sendRequest($request);
    }

    /**
     * @param int $limit
     * @param int $page
     * @return array
     * @throws ApiException
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function pagination(int $limit, int $page): array
    {
        [$response] = $this->paginationGroupsWithHttpInfo($limit, $page);
        return $this->mapper->mapMultiple($response->getData(), $this->resourceClass);
    }

    /**
     * @param int $limit
     * @param int $page
     * @return array
     * @throws ApiException
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function paginationWithHttpInfo(int $limit, int $page): array
    {
        $request = $this->createPaginationSubresourceRequest('filters', $limit, $page);

        return $this->sendRequest($request);
    }

}
