<?php


namespace RTMTrade\OpenCart\AdminApi;


use DateTime;

class Token
{

    /**
     * @var string
     */
    private string $accessToken;
    /**
     * @var string
     */
    private string $tokenType;
    /**
     * @var integer
     */
    private int $expiresIn;
    /**
     * @var DateTime|null
     */
    private ?DateTime $since;


    /**
     * @return string
     */
    public function getAccessToken(): string
    {
        return $this->accessToken;
    }

    /**
     * @return int
     */
    public function getExpiresIn(): int
    {
        return $this->expiresIn;
    }

    /**
     * @return ?DateTime
     */
    public function getSince(): ?DateTime
    {
        return $this->since;
    }

    /**
     * @return string
     */
    public function getTokenType(): string
    {
        return $this->tokenType;
    }

    /**
     * @param mixed $accessToken
     * @return Token
     */
    public function setAccessToken($accessToken): Token
    {
        $this->accessToken = $accessToken;
        return $this;
    }

    /**
     * @param mixed $expires
     * @return Token
     */
    public function setExpiresIn($expires): Token
    {
        $this->expiresIn = $expires;
        return $this;
    }

    /**
     * @param mixed $since
     * @return Token
     */
    public function setSince(?DateTime $since): Token
    {
        $this->since = $since;
        return $this;
    }

    /**
     * @param mixed $tokenType
     * @return Token
     */
    public function setTokenType($tokenType): Token
    {
        $this->tokenType = $tokenType;
        return $this;
    }

    public function isExpired(): bool
    {
        return $this->since->getTimestamp() + $this->expiresIn < (new DateTime())->getTimestamp();
    }
}