<?php


namespace RTMTrade\OpenCart\AdminApi\Model;


use DateTime;

class User
{

    private int $id;
    private int $userGroupId;
    private ?string $username;
    private ?string $firstname;
    private ?string $lastname;
    private ?string $email;
    private ?string $image;
    private ?string $ip;
    private bool $status;
    private ?DateTime $dateAdded;
    private ?string $userGroup;

    /**
     * User constructor.
     */
    public function __construct()
    {
        $this->id = 0;
        $this->userGroupId = 0;
        $this->username = null;
        $this->firstname = null;
        $this->lastname = null;
        $this->email = null;
        $this->image = null;
        $this->ip = null;
        $this->status = false;
        $this->dateAdded = null;
        $this->userGroup = null;
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @param int $id
     * @return User
     */
    public function setId(int $id): User
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return int
     */
    public function getUserGroupId(): int
    {
        return $this->userGroupId;
    }

    /**
     * @param int $userGroupId
     * @return User
     */
    public function setUserGroupId(int $userGroupId): User
    {
        $this->userGroupId = $userGroupId;
        return $this;
    }

    /**
     * @return string
     */
    public function getUsername(): string
    {
        return $this->username;
    }

    /**
     * @param string $username
     * @return User
     */
    public function setUsername(string $username): User
    {
        $this->username = $username;
        return $this;
    }

    /**
     * @return string
     */
    public function getFirstname(): string
    {
        return $this->firstname;
    }

    /**
     * @param string $firstname
     * @return User
     */
    public function setFirstname(string $firstname): User
    {
        $this->firstname = $firstname;
        return $this;
    }

    /**
     * @return string
     */
    public function getLastname(): string
    {
        return $this->lastname;
    }

    /**
     * @param string $lastname
     * @return User
     */
    public function setLastname(string $lastname): User
    {
        $this->lastname = $lastname;
        return $this;
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return User
     */
    public function setEmail(string $email): User
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @return string
     */
    public function getImage(): string
    {
        return $this->image;
    }

    /**
     * @param string $image
     * @return User
     */
    public function setImage(string $image): User
    {
        $this->image = $image;
        return $this;
    }

    /**
     * @return string
     */
    public function getIp(): string
    {
        return $this->ip;
    }

    /**
     * @param string $ip
     * @return User
     */
    public function setIp(string $ip): User
    {
        $this->ip = $ip;
        return $this;
    }

    /**
     * @return bool
     */
    public function isStatus(): bool
    {
        return $this->status;
    }

    /**
     * @param bool $status
     * @return User
     */
    public function setStatus(bool $status): User
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return DateTime
     */
    public function getDateAdded(): DateTime
    {
        return $this->dateAdded;
    }

    /**
     * @param DateTime $dateAdded
     * @return User
     */
    public function setDateAdded(DateTime $dateAdded): User
    {
        $this->dateAdded = $dateAdded;
        return $this;
    }

    /**
     * @return string
     */
    public function getUserGroup(): string
    {
        return $this->userGroup;
    }

    /**
     * @param string $userGroup
     * @return User
     */
    public function setUserGroup(string $userGroup): User
    {
        $this->userGroup = $userGroup;
        return $this;
    }



}