<?php

namespace RTMTrade\OpenCart\AdminApi\Model;

use DateTime;

/**
 * Class Review
 * @package RTMTrade\OpenCart\AdminApi\Model
 * @author Beau Fiechter (RTM Business)
 * @link https://gitlab.rtmbusiness.nl/spyder/opencart-admin-api-php
 */
class Review
{

    private ?string $author;
    private ?string $text;
    private ?int $rating;
    private ?DateTime $dateAdded;

    /**
     * @return string|null
     */
    public function getAuthor(): ?string
    {
        return $this->author;
    }

    /**
     * @param string|null $author
     * @return Review
     */
    public function setAuthor(?string $author): Review
    {
        $this->author = $author;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getText(): ?string
    {
        return $this->text;
    }

    /**
     * @param string|null $text
     * @return Review
     */
    public function setText(?string $text): Review
    {
        $this->text = $text;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getRating(): ?int
    {
        return $this->rating;
    }

    /**
     * @param int|null $rating
     * @return Review
     */
    public function setRating(?int $rating): Review
    {
        $this->rating = $rating;
        return $this;
    }

    /**
     * @return DateTime|null
     */
    public function getDateAdded(): ?DateTime
    {
        return $this->dateAdded;
    }

    /**
     * @param DateTime|null $dateAdded
     * @return Review
     */
    public function setDateAdded(?DateTime $dateAdded): Review
    {
        $this->dateAdded = $dateAdded;
        return $this;
    }


}


